/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBody;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.interceptors.BareInInterceptor;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class RPCInInterceptor
extends AbstractInDatabindingInterceptor {
    private static final QName SOAP12_RESULT = new QName("http://www.w3.org/2003/05/soap-rpc", "result");
    private static final Logger LOG = LogUtils.getL7dLogger(RPCInInterceptor.class);
    static final long serialVersionUID = 5558035899310958522L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RPCInInterceptor() {
        super("unmarshal");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BindingOperationInfo getOperation(Message message, QName opName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "getOperation", new Object[]{message, opName});
        }
        BindingOperationInfo bop = ServiceModelUtil.getOperation((Exchange)message.getExchange(), (QName)opName);
        if (bop == null) {
            Endpoint ep = message.getExchange().getEndpoint();
            if (ep == null) {
                BindingOperationInfo bindingOperationInfo = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bindingOperationInfo = bindingOperationInfo;
                    LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "getOperation", bindingOperationInfo);
                }
                return bindingOperationInfo;
            }
            BindingInfo service = ep.getEndpointInfo().getBinding();
            boolean output = !this.isRequestor(message);
            for (BindingOperationInfo info : service.getOperations()) {
                SoapBody body;
                if (!info.getName().getLocalPart().equals(opName.getLocalPart()) || (body = output ? (SoapBody)info.getOutput().getExtensor(SoapBody.class) : (SoapBody)info.getInput().getExtensor(SoapBody.class)) == null || !opName.getNamespaceURI().equals(body.getNamespaceURI())) continue;
                BindingOperationInfo bindingOperationInfo = info;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bindingOperationInfo = bindingOperationInfo;
                    LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "getOperation", bindingOperationInfo);
                }
                return bindingOperationInfo;
            }
        }
        BindingOperationInfo bindingOperationInfo = bop;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bindingOperationInfo = bindingOperationInfo;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "getOperation", bindingOperationInfo);
        }
        return bindingOperationInfo;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(Message message) {
        BindingOperationInfo operation;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "handleMessage", new Object[]{message});
        }
        if (this.isGET(message)) {
            LOG.fine("RPCInInterceptor skipped in HTTP GET method");
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "handleMessage");
            }
            return;
        }
        DepthXMLStreamReader xmlReader = this.getXMLStreamReader(message);
        if (!StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader)) {
            message.setContent(Exception.class, (Object)new RuntimeException("There must be a method name element."));
        }
        String opName = xmlReader.getLocalName();
        if (this.isRequestor(message) && opName.endsWith("Response")) {
            opName = opName.substring(0, opName.length() - 8);
        }
        if (message.getExchange().getBindingOperationInfo() == null) {
            operation = this.getOperation(message, new QName(xmlReader.getNamespaceURI(), opName));
            if (operation == null) {
                new BareInInterceptor().handleMessage(message);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "handleMessage");
                }
                return;
            }
            this.setMessage(message, operation);
        } else {
            operation = message.getExchange().getBindingOperationInfo();
            if (!operation.getName().getLocalPart().equals(opName)) {
                String sa = (String)message.get((Object)"SOAPAction");
                throw new Fault("SOAP_ACTION_MISMATCH_OP", LOG, null, new Object[]{sa, opName});
            }
        }
        DataReader dr = this.getDataReader(message, XMLStreamReader.class);
        MessageInfo msg = !this.isRequestor(message) ? operation.getOperationInfo().getInput() : operation.getOperationInfo().getOutput();
        message.put(MessageInfo.class, (Object)msg);
        MessageContentsList parameters = new MessageContentsList();
        StaxUtils.nextEvent((XMLStreamReader)xmlReader);
        boolean hasNext = true;
        for (MessagePartInfo part : msg.getMessageParts()) {
            if (hasNext) {
                hasNext = StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader);
            }
            if (!hasNext) continue;
            QName qn = xmlReader.getName();
            if (qn.equals(SOAP12_RESULT)) {
                try {
                    while (xmlReader.getEventType() != 2) {
                        xmlReader.next();
                    }
                    xmlReader.next();
                }
                catch (XMLStreamException xMLStreamException) {
                    FFDCFilter.processException((Throwable)xMLStreamException, (String)"org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", (String)"152", (Object)((Object)this), (Object[])new Object[]{message});
                }
                StaxUtils.toNextElement((DepthXMLStreamReader)xmlReader);
                qn = xmlReader.getName();
            }
            Iterator partItr = msg.getMessageParts().iterator();
            while (!qn.getLocalPart().equals(part.getConcreteName().getLocalPart()) && partItr.hasNext()) {
                part = (MessagePartInfo)partItr.next();
            }
            if (!qn.getLocalPart().equals(part.getConcreteName().getLocalPart())) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("UNKNOWN_RPC_LIT_PART", LOG, new Object[]{qn}));
            }
            try {
                parameters.put(part, dr.read(part, (Object)xmlReader));
            }
            catch (Fault fault) {
                void f;
                FFDCFilter.processException((Throwable)fault, (String)"org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", (String)"182", (Object)((Object)this), (Object[])new Object[]{message});
                if (!this.isRequestor(message)) {
                    f.setFaultCode(Fault.FAULT_CODE_CLIENT);
                }
                throw f;
            }
        }
        message.setContent(List.class, (Object)parameters);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setMessage(Message message, BindingOperationInfo operation) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "setMessage", new Object[]{message, operation});
        }
        Exchange ex = message.getExchange();
        ex.put(BindingOperationInfo.class, (Object)operation);
        ex.setOneWay(operation.getOperationInfo().isOneWay());
        message.put((Object)"jakarta.xml.ws.wsdl.operation", (Object)operation.getName());
        ServiceInfo si = operation.getBinding().getService();
        QName serviceQName = si.getName();
        message.put((Object)"jakarta.xml.ws.wsdl.service", (Object)serviceQName);
        QName interfaceQName = si.getInterface().getName();
        message.put((Object)"jakarta.xml.ws.wsdl.interface", (Object)interfaceQName);
        EndpointInfo endpointInfo = ex.getEndpoint().getEndpointInfo();
        QName portQName = endpointInfo.getName();
        message.put((Object)"jakarta.xml.ws.wsdl.port", (Object)portQName);
        URI wsdlDescription = (URI)endpointInfo.getProperty("URI", URI.class);
        if (wsdlDescription == null) {
            String address = endpointInfo.getAddress();
            try {
                wsdlDescription = new URI(address + "?wsdl");
            }
            catch (URISyntaxException uRISyntaxException) {
                FFDCFilter.processException((Throwable)uRISyntaxException, (String)"org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", (String)"222", (Object)((Object)this), (Object[])new Object[]{message, operation});
            }
            endpointInfo.setProperty("URI", (Object)wsdlDescription);
        }
        message.put((Object)"jakarta.xml.ws.wsdl.description", (Object)wsdlDescription);
        this.setOperationSchemaValidation(message);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.RPCInInterceptor", "setMessage");
        }
    }
}

