/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.headers.Header;
import org.apache.cxf.headers.HeaderManager;
import org.apache.cxf.headers.HeaderProcessor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    public static final String ENVELOPE_EVENTS = "envelope.events";
    public static final String BODY_EVENTS = "body.events";
    public static final String ENVELOPE_PREFIX = "envelope.prefix";
    public static final String BODY_PREFIX = "body.prefix";
    private static final Logger LOG = LogUtils.getL7dLogger(ReadHeadersInterceptor.class);
    private Bus bus;
    private SoapVersion version;
    static final long serialVersionUID = -6758205324911702078L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReadHeadersInterceptor(Bus b) {
        super("read");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", new Object[]{b});
        }
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReadHeadersInterceptor(Bus b, SoapVersion v) {
        super("read");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", new Object[]{b, v});
        }
        this.version = v;
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ReadHeadersInterceptor(Bus b, String phase) {
        super(phase);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", new Object[]{b, phase});
        }
        this.bus = b;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SoapVersion readVersion(XMLStreamReader xmlReader, SoapMessage message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "readVersion", new Object[]{xmlReader, message});
        }
        String ns = xmlReader.getNamespaceURI();
        String lcname = xmlReader.getLocalName();
        if (ns == null || "".equals(ns)) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("NO_NAMESPACE", LOG, new Object[]{lcname}), Soap11.getInstance().getVersionMismatch());
        }
        SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
        if (soapVersion == null) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_VERSION", LOG, new Object[]{ns, lcname}), Soap11.getInstance().getVersionMismatch());
        }
        if (!"Envelope".equals(lcname)) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_ENVELOPE", LOG, new Object[]{lcname}), soapVersion.getSender());
        }
        message.setVersion(soapVersion);
        SoapVersion soapVersion2 = soapVersion;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapVersion2 = soapVersion2;
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "readVersion", soapVersion2);
        }
        return soapVersion2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive SoapMessage message) {
        block32: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "handleMessage", objectArray);
            }
            if (this.isGET((Message)message)) {
                LOG.fine("ReadHeadersInterceptor skipped in HTTP GET method");
                if (LOG == null) return;
                if (!LOG.isLoggable(Level.FINER)) return;
                LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "handleMessage");
                return;
            }
            String verb = (String)message.get("org.apache.cxf.request.method");
            if (verb != null && !"POST".equals(verb)) {
                Fault formula405 = new Fault("HTTP verb was not GET or POST", LOG);
                formula405.setStatusCode(405);
                throw formula405;
            }
            XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            boolean closeNeeded = false;
            if (xmlReader == null) {
                InputStream in = (InputStream)message.getContent(InputStream.class);
                if (in == null) {
                    throw new RuntimeException("Can't find input stream in message");
                }
                xmlReader = StaxUtils.createXMLStreamReader((InputStream)in);
                closeNeeded = true;
            }
            try {
                if (xmlReader.getEventType() == 1 || xmlReader.nextTag() == 1) {
                    SoapVersion soapVersion = ReadHeadersInterceptor.readVersion(xmlReader, message);
                    if (soapVersion == Soap12.getInstance() && this.version == Soap11.getInstance()) {
                        message.setVersion(this.version);
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("INVALID_11_VERSION", LOG, new Object[0]), this.version.getVersionMismatch());
                    }
                    PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                    Node nd = (Node)message.getContent(Node.class);
                    W3CDOMStreamWriter writer = (W3CDOMStreamWriter)message.get(W3CDOMStreamWriter.class);
                    Document doc = null;
                    if (writer != null) {
                        StaxUtils.copy((XMLStreamReader)filteredReader, (XMLStreamWriter)writer);
                        doc = writer.getDocument();
                    } else if (nd instanceof Document) {
                        doc = (Document)nd;
                        StaxUtils.readDocElements((Document)doc, (Node)doc, (XMLStreamReader)filteredReader, (boolean)false, (boolean)false);
                    } else {
                        HeadersProcessor processor;
                        HashMap<String, String> bodyNC;
                        boolean addNC = MessageUtils.getContextualBoolean((Message)message, (String)"org.apache.cxf.binding.soap.addNamespaceContext", (boolean)false);
                        HashMap<String, String> hashMap = bodyNC = addNC ? new HashMap<String, String>() : null;
                        if (addNC) {
                            this.addCurrentNamespaceDecls(xmlReader, bodyNC);
                        }
                        if ((doc = (processor = new HeadersProcessor(soapVersion)).process((XMLStreamReader)filteredReader)) != null) {
                            message.setContent(Node.class, doc);
                        } else {
                            message.put(ENVELOPE_EVENTS, processor.getEnvAttributeAndNamespaceEvents());
                            message.put(BODY_EVENTS, processor.getBodyAttributeAndNamespaceEvents());
                            message.put(ENVELOPE_PREFIX, processor.getEnvelopePrefix());
                            message.put(BODY_PREFIX, processor.getBodyPrefix());
                        }
                        if (addNC) {
                            this.addCurrentNamespaceDecls(xmlReader, bodyNC);
                            message.put("soap.body.ns.context", bodyNC);
                        }
                    }
                    if (doc != null) {
                        Element element = doc.getDocumentElement();
                        QName header = soapVersion.getHeader();
                        List elemList = DOMUtils.findAllElementsByTagNameNS((Element)element, (String)header.getNamespaceURI(), (String)header.getLocalPart());
                        for (Element elem : elemList) {
                            Element hel = DOMUtils.getFirstElement((Node)elem);
                            while (hel != null) {
                                Object obj;
                                if (elem.hasAttributes()) {
                                    NamedNodeMap nnp = elem.getAttributes();
                                    for (int ct = 0; ct < nnp.getLength(); ++ct) {
                                        Node headerAttrNode;
                                        Node attr = nnp.item(ct);
                                        Node node = headerAttrNode = hel.hasAttributes() ? hel.getAttributes().getNamedItemNS(attr.getNamespaceURI(), attr.getLocalName()) : null;
                                        if (headerAttrNode != null) continue;
                                        Attr attribute = hel.getOwnerDocument().createAttributeNS(attr.getNamespaceURI(), attr.getNodeName());
                                        attribute.setNodeValue(attr.getNodeValue());
                                        hel.setAttributeNodeNS(attribute);
                                    }
                                }
                                HeaderProcessor p = this.bus == null ? null : ((HeaderManager)this.bus.getExtension(HeaderManager.class)).getHeaderProcessor(hel.getNamespaceURI());
                                DataBinding dataBinding = null;
                                if (p == null || p.getDataBinding() == null) {
                                    obj = hel;
                                } else {
                                    dataBinding = p.getDataBinding();
                                    DataReader dataReader = dataBinding.createReader(Node.class);
                                    dataReader.setAttachments(message.getAttachments());
                                    dataReader.setProperty(DataReader.ENDPOINT, (Object)message.getExchange().getEndpoint());
                                    dataReader.setProperty(org.apache.cxf.common.i18n.Message.class.getName(), (Object)message);
                                    obj = dataReader.read((Object)hel);
                                }
                                SoapHeader shead = new SoapHeader(new QName(hel.getNamespaceURI(), hel.getLocalName()), obj, dataBinding);
                                String mu = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameMustUnderstand());
                                String act = hel.getAttributeNS(soapVersion.getNamespace(), soapVersion.getAttrNameRole());
                                if (!StringUtils.isEmpty((String)act)) {
                                    shead.setActor(act);
                                }
                                shead.setMustUnderstand(Boolean.valueOf(mu) != false || "1".equals(mu));
                                shead.setDirection(Header.Direction.DIRECTION_IN);
                                message.getHeaders().add(shead);
                                hel = DOMUtils.getNextElement((Element)hel);
                            }
                        }
                    }
                    if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.IN, (Message)message)) {
                        message.getInterceptorChain().add((Interceptor)new CheckClosingTagsInterceptor());
                    }
                }
                if (!closeNeeded) break block32;
            }
            catch (XMLStreamException e) {
                try {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                    FFDCFilter.processException((Throwable)e, (String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", (String)"292", (Object)this, (Object[])objectArray);
                    throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[]{e.getMessage()}), (Throwable)e, message.getVersion().getSender());
                }
                catch (Throwable throwable) {
                    if (!closeNeeded) throw throwable;
                    try {
                        StaxUtils.close((XMLStreamReader)xmlReader);
                        throw throwable;
                    }
                    catch (XMLStreamException xMLStreamException) {
                        void e2;
                        Object[] objectArray = new Object[1];
                        objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                        FFDCFilter.processException((Throwable)xMLStreamException, (String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", (String)"299", (Object)this, (Object[])objectArray);
                        throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[]{e2.getMessage()}), (Throwable)e2, message.getVersion().getSender());
                    }
                }
            }
            try {
                StaxUtils.close((XMLStreamReader)xmlReader);
            }
            catch (XMLStreamException soapVersion) {
                Object[] objectArray = new Object[1];
                objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                FFDCFilter.processException((Throwable)soapVersion, (String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", (String)"299", (Object)this, (Object[])objectArray);
                throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", LOG, new Object[]{e.getMessage()}), (Throwable)e, message.getVersion().getSender());
            }
        }
        if (LOG == null) return;
        if (!LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "handleMessage");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addCurrentNamespaceDecls(XMLStreamReader xmlReader, Map<String, String> bodyNsMap) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "addCurrentNamespaceDecls", new Object[]{xmlReader, bodyNsMap});
        }
        for (int i = 0; i < xmlReader.getNamespaceCount(); ++i) {
            String nsuri = xmlReader.getNamespaceURI(i);
            if ("".equals(nsuri)) {
                bodyNsMap.remove("");
                continue;
            }
            bodyNsMap.put(xmlReader.getNamespacePrefix(i), nsuri);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor", "addCurrentNamespaceDecls");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class HeadersProcessor {
        private static XMLEventFactory eventFactory;
        private final String ns;
        private final String header;
        private final String body;
        private final String envelope;
        private final List<XMLEvent> events = new ArrayList<XMLEvent>(8);
        private List<XMLEvent> envEvents;
        private List<XMLEvent> bodyEvents;
        private StaxUtils.StreamToDOMContext context;
        private Document doc;
        private Node parent;
        private QName lastStartElementQName;
        private String envelopePrefix;
        private String bodyPrefix;
        static final long serialVersionUID = -9104504187873694107L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HeadersProcessor(SoapVersion version) {
            this.header = version.getHeader().getLocalPart();
            this.ns = version.getEnvelope().getNamespaceURI();
            this.envelope = version.getEnvelope().getLocalPart();
            this.body = version.getBody().getLocalPart();
        }

        public Document process(XMLStreamReader reader) throws XMLStreamException {
            int read = 0;
            int event = reader.getEventType();
            while (reader.hasNext()) {
                switch (event) {
                    case 1: {
                        int i;
                        ++read;
                        this.addEvent(eventFactory.createStartElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), null, null));
                        for (i = 0; i < reader.getNamespaceCount(); ++i) {
                            this.addEvent(eventFactory.createNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
                        }
                        for (i = 0; i < reader.getAttributeCount(); ++i) {
                            this.addEvent(eventFactory.createAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i)));
                        }
                        if (this.doc == null) break;
                        StaxUtils.readDocElements((Document)this.doc, (Node)this.parent, (XMLStreamReader)reader, (StaxUtils.StreamToDOMContext)this.context);
                        break;
                    }
                    case 2: {
                        if (read > 0) {
                            this.addEvent(eventFactory.createEndElement(new QName(reader.getNamespaceURI(), reader.getLocalName(), reader.getPrefix()), null));
                        }
                        --read;
                        break;
                    }
                    case 4: {
                        String s = reader.getText();
                        if (s == null) break;
                        this.addEvent(eventFactory.createCharacters(s));
                        break;
                    }
                    case 5: {
                        this.addEvent(eventFactory.createComment(reader.getText()));
                        break;
                    }
                    case 12: {
                        this.addEvent(eventFactory.createCData(reader.getText()));
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 10: 
                    case 13: {
                        break;
                    }
                }
                event = reader.next();
            }
            return this.doc;
        }

        /*
         * WARNING - void declaration
         */
        private void addEvent(XMLEvent event) {
            if (event.isStartElement()) {
                this.lastStartElementQName = event.asStartElement().getName();
                if (this.header.equals(this.lastStartElementQName.getLocalPart()) && this.ns.equals(this.lastStartElementQName.getNamespaceURI())) {
                    this.context = new StaxUtils.StreamToDOMContext(true, false, false);
                    this.doc = DOMUtils.createDocument();
                    this.parent = this.doc;
                    try {
                        for (XMLEvent ev : this.events) {
                            this.parent = StaxUtils.readDocElement((Document)this.doc, (Node)this.parent, (XMLEvent)ev, (StaxUtils.StreamToDOMContext)this.context);
                        }
                    }
                    catch (XMLStreamException xMLStreamException) {
                        void e;
                        FFDCFilter.processException((Throwable)xMLStreamException, (String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor$HeadersProcessor", (String)"429", (Object)this, (Object[])new Object[]{event});
                        throw new Fault((Throwable)e);
                    }
                } else {
                    if (this.ns.equals(this.lastStartElementQName.getNamespaceURI())) {
                        if (this.body.equals(this.lastStartElementQName.getLocalPart())) {
                            this.bodyPrefix = this.lastStartElementQName.getPrefix();
                        } else if (this.envelope.equals(this.lastStartElementQName.getLocalPart())) {
                            this.envelopePrefix = this.lastStartElementQName.getPrefix();
                        }
                    }
                    this.events.add(event);
                }
            } else {
                if (event.isNamespace() || event.isAttribute()) {
                    String lastEl = this.lastStartElementQName.getLocalPart();
                    if (this.body.equals(lastEl) && this.ns.equals(this.lastStartElementQName.getNamespaceURI())) {
                        if (this.bodyEvents == null) {
                            this.bodyEvents = new ArrayList<XMLEvent>();
                        }
                        this.bodyEvents.add(event);
                    } else if (this.envelope.equals(lastEl) && this.ns.equals(this.lastStartElementQName.getNamespaceURI())) {
                        if (this.envEvents == null) {
                            this.envEvents = new ArrayList<XMLEvent>();
                        }
                        this.envEvents.add(event);
                    }
                }
                this.events.add(event);
            }
        }

        public List<XMLEvent> getBodyAttributeAndNamespaceEvents() {
            if (this.bodyEvents == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.bodyEvents);
        }

        public List<XMLEvent> getEnvAttributeAndNamespaceEvents() {
            if (this.envEvents == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(this.envEvents);
        }

        public String getEnvelopePrefix() {
            return this.envelopePrefix;
        }

        public String getBodyPrefix() {
            return this.bodyPrefix;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor$HeadersProcessor", HeadersProcessor.class, null, null);
            try {
                eventFactory = XMLEventFactory.newInstance();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor$HeadersProcessor", (String)"345", null, (Object[])new Object[0]);
                eventFactory = StaxUtils.createWoodstoxEventFactory();
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class CheckClosingTagsInterceptor
    extends AbstractSoapInterceptor {
        static final long serialVersionUID = -5875341780111098749L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public CheckClosingTagsInterceptor() {
            super("post-logical");
        }

        /*
         * WARNING - void declaration
         */
        public void handleMessage(@Sensitive SoapMessage message) throws Fault {
            XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
            if (xmlReader != null) {
                try {
                    while (xmlReader.hasNext()) {
                        if (xmlReader.next() != 8) continue;
                        return;
                    }
                }
                catch (XMLStreamException xMLStreamException) {
                    void e;
                    Object[] objectArray = new Object[1];
                    objectArray[0] = "<sensitive org.apache.cxf.binding.soap.SoapMessage>";
                    FFDCFilter.processException((Throwable)xMLStreamException, (String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor$CheckClosingTagsInterceptor", (String)"96", (Object)this, (Object[])objectArray);
                    throw new SoapFault(e.getMessage(), (Throwable)e, message.getVersion().getSender());
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.binding.soap.interceptor.ReadHeadersInterceptor$CheckClosingTagsInterceptor", CheckClosingTagsInterceptor.class, null, null);
        }
    }
}

