/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.jmx.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jaxws.bus.LibertyApplicationBusFactory;
import com.ibm.ws.jaxws.jmx.internal.CXFModelMBean;
import com.ibm.ws.jaxws.jmx.internal.JMXBusInitializer;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.cxf.endpoint.ManagedEndpoint;
import org.apache.cxf.management.jmx.export.runtime.ModelMBeanAssembler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JMXMBeanServerDelegation
implements MBeanServer {
    private static final TraceComponent tc = Tr.register(JMXMBeanServerDelegation.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private static final String ERR_UNSUPPORTED_METHOD = "This method is not supported.";
    private static final String ERR_FAIL_TO_INIT_RMMB = "Fail to instantiate instance of RequiredModelMBean.";
    private static final String ERR_BC_NOT_INIT = "BundleContext was not initialized yet.";
    private static final String ERR_NOT_MBEAN = "The object is not instance of MBean.";
    private static final String ERR_BAD_OBJECTNAME = "The object name is invalid.";
    private static final JMXMBeanServerDelegation INSTANCE = new JMXMBeanServerDelegation();
    private static final String WEBSPHERE_DOMAIN_NAME = "WebSphere:feature=jaxws,";
    private static final String MBEAN_FIELD_TYPE_KEY = "type";
    private static final String MBEAN_FIELD_INSTANCE_ID_KEY = "instance.id";
    private static final String MBEAN_FIELD_BUS_ID_KEY = "bus.id";
    private static final String MBEAN_FIELD_SERVICE_KEY = "service";
    private static final String MBEAN_FIELD_PORT_KEY = "port";
    private static final String MBEAN_FIELD_NAME_KEY = "name";
    private static final String MBEAN_FIELD_NAME_VALUE_DEFAULT = "NOT_SET";
    private static final String MBEAN_FIELD_NAME_DELIMITER = "@";
    private static final String MBEAN_TYPE_BUS = "Bus";
    private static final String MBEAN_TYPE_WORK_QUEUE_MANAGER = "WorkQueueManager";
    private static final String MBEAN_TYPE_SERVICE_ENDPOINT = "Bus.Service.Endpoint";
    private static final String STR_EMPTY_STRING = "";
    private BundleContext context = null;
    private Hashtable<String, ServiceRegistration> serviceTable;
    private Hashtable<String, String> objectNameMap;
    private JMXBusInitializer jmxInitializer = null;
    static final long serialVersionUID = -507740860077128710L;

    public static JMXMBeanServerDelegation getInstance() {
        return INSTANCE;
    }

    protected void activate(ComponentContext cc) {
        BundleContext context;
        JMXMBeanServerDelegation.INSTANCE.context = context = cc.getBundleContext();
        LibertyApplicationBusFactory busFactory = LibertyApplicationBusFactory.getInstance();
        this.jmxInitializer = new JMXBusInitializer(JMXMBeanServerDelegation.getInstance());
        busFactory.registerApplicationBusListener(this.jmxInitializer);
    }

    protected void deactivate(ComponentContext cc) {
        LibertyApplicationBusFactory busFactory = LibertyApplicationBusFactory.getInstance();
        busFactory.unregisterApplicationBusListener(this.jmxInitializer);
        if (null != this.serviceTable) {
            Enumeration<String> keys = this.serviceTable.keys();
            while (keys.hasMoreElements()) {
                String k = keys.nextElement();
                ServiceRegistration r = this.serviceTable.get(k);
                if (null == r) continue;
                r.unregister();
            }
            this.serviceTable.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String objName = name.toString();
        String objNameForWebSphere = this.generateObjectNameForWebSphereDomain(object, name);
        ServiceRegistration registration = null;
        ServiceRegistration registration2 = null;
        if (null != this.context) {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("service.vendor", "IBM");
            properties.put("jmx.objectname", objName);
            Hashtable<String, String> properties2 = new Hashtable<String, String>();
            properties2.put("service.vendor", "IBM");
            properties2.put("jmx.objectname", objNameForWebSphere);
            ModelMBeanAssembler assembler = new ModelMBeanAssembler();
            ModelMBeanInfo mbi = assembler.getModelMbeanInfo(object.getClass());
            CXFModelMBean rtMBean = null;
            if (null != mbi) {
                try {
                    rtMBean = new CXFModelMBean();
                    rtMBean.setModelMBeanInfo(mbi);
                    ((RequiredModelMBean)rtMBean).setManagedResource(object, "ObjectReference");
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.jmx.internal.JMXMBeanServerDelegation", (String)"162", (Object)this, (Object[])new Object[]{object, name});
                    throw new MBeanRegistrationException((Exception)e, ERR_FAIL_TO_INIT_RMMB);
                }
                registration = this.context.registerService(RequiredModelMBean.class.getName(), (Object)rtMBean, properties);
                if (this.shouldBeRegisteredToWebSphereDomain(name)) {
                    registration2 = this.context.registerService(RequiredModelMBean.class.getName(), (Object)rtMBean, properties2);
                }
            } else {
                Class<?>[] interfaceClasses;
                String publishedInterface = null;
                for (Class<?> interfaceClass : interfaceClasses = object.getClass().getInterfaces()) {
                    String interfaceName = interfaceClass.getName();
                    if (!interfaceName.endsWith("MBean")) continue;
                    publishedInterface = interfaceName;
                }
                if (null != publishedInterface) {
                    registration = this.context.registerService(publishedInterface, object, properties);
                    if (this.shouldBeRegisteredToWebSphereDomain(name)) {
                        registration2 = this.context.registerService(publishedInterface, object, properties2);
                    }
                } else {
                    throw new MBeanRegistrationException(null, ERR_NOT_MBEAN);
                }
            }
            if (null == this.serviceTable) {
                this.serviceTable = new Hashtable();
            }
            if (null != registration) {
                this.serviceTable.put(objName, registration);
            }
            if (null != registration2) {
                this.serviceTable.put(objNameForWebSphere, registration2);
            }
            if (null == this.objectNameMap) {
                this.objectNameMap = new Hashtable();
            }
        } else {
            throw new MBeanRegistrationException(null, ERR_BC_NOT_INIT);
        }
        this.objectNameMap.put(objName, objNameForWebSphere);
        return new ObjectInstance(name, RequiredModelMBean.class.getName());
    }

    @Override
    @FFDCIgnore(value={IllegalStateException.class})
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        String objName = name.toString();
        String objNameForWebSphere = null;
        if (null != this.objectNameMap) {
            objNameForWebSphere = this.objectNameMap.get(objName);
        }
        if (null != this.serviceTable) {
            ServiceRegistration registration = this.serviceTable.get(objName);
            ServiceRegistration registration2 = null;
            if (null != objNameForWebSphere && objNameForWebSphere.length() > 0) {
                registration2 = this.serviceTable.get(objNameForWebSphere);
            }
            if (null == registration && null == registration2) {
                throw new InstanceNotFoundException("Specific object name is not registered. ObjectName:" + objName);
            }
            if (null != registration) {
                try {
                    registration.unregister();
                    this.serviceTable.remove(objName);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            if (null != registration2) {
                try {
                    registration2.unregister();
                    this.serviceTable.remove(objNameForWebSphere);
                }
                catch (IllegalStateException illegalStateException) {}
            }
        } else {
            throw new MBeanRegistrationException(null, ERR_BC_NOT_INIT);
        }
    }

    @Override
    public Object instantiate(String className) throws ReflectionException, MBeanException {
        if (className.equalsIgnoreCase("javax.management.modelmbean.RequiredModelMBean")) {
            RequiredModelMBean rtMBean = new RequiredModelMBean();
            return rtMBean;
        }
        return null;
    }

    @Override
    public boolean isRegistered(ObjectName name) {
        ServiceRegistration registration;
        boolean found = false;
        if (null != this.serviceTable && null != (registration = this.serviceTable.get(name.toString()))) {
            found = true;
        }
        return found;
    }

    private String generateObjectNameForWebSphereDomain(Object object, ObjectName name) throws MBeanRegistrationException {
        if (null == name) {
            throw new MBeanRegistrationException(null, ERR_BAD_OBJECTNAME);
        }
        String objectNameStr = name.toString();
        String domainName = name.getDomain();
        if (null == objectNameStr || objectNameStr.length() <= 0 || null == domainName || domainName.length() <= 0) {
            throw new MBeanRegistrationException(null, ERR_BAD_OBJECTNAME);
        }
        String targetNameStr = objectNameStr.replaceFirst(domainName + ":", WEBSPHERE_DOMAIN_NAME);
        String nameValue = name.getKeyProperty(MBEAN_FIELD_NAME_KEY);
        if (null == nameValue || nameValue.length() <= 0) {
            String nameTargetValue = MBEAN_FIELD_NAME_VALUE_DEFAULT;
            String typeValue = name.getKeyProperty(MBEAN_FIELD_TYPE_KEY);
            if (null != typeValue && typeValue.equalsIgnoreCase(MBEAN_TYPE_SERVICE_ENDPOINT)) {
                String busIdValue = name.getKeyProperty(MBEAN_FIELD_BUS_ID_KEY);
                String serviceValue = name.getKeyProperty(MBEAN_FIELD_SERVICE_KEY);
                String portValue = name.getKeyProperty(MBEAN_FIELD_PORT_KEY);
                String instanceIdValue = name.getKeyProperty(MBEAN_FIELD_INSTANCE_ID_KEY);
                final String addressValue = ((ManagedEndpoint)object).getAddress();
                String urlPattern = STR_EMPTY_STRING;
                if (null != addressValue) {
                    urlPattern = AccessController.doPrivileged(new PrivilegedAction<String>(){
                        static final long serialVersionUID = -104051567903035225L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        @FFDCIgnore(value={MalformedURLException.class})
                        public String run() {
                            try {
                                URL addressURL = new URL(addressValue);
                                return addressURL.getPath();
                            }
                            catch (MalformedURLException e) {
                                return addressValue;
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxws.jmx.internal.JMXMBeanServerDelegation$1", 1.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
                        }
                    });
                }
                if ((null == urlPattern || urlPattern.length() <= 0) && null != instanceIdValue) {
                    urlPattern = instanceIdValue;
                }
                if (null != busIdValue && null != serviceValue && null != portValue && null != urlPattern) {
                    nameTargetValue = "\"" + busIdValue.replace("\"", STR_EMPTY_STRING) + MBEAN_FIELD_NAME_DELIMITER + serviceValue.replace("\"", STR_EMPTY_STRING) + MBEAN_FIELD_NAME_DELIMITER + portValue.replace("\"", STR_EMPTY_STRING) + MBEAN_FIELD_NAME_DELIMITER + urlPattern + "\"";
                    targetNameStr = new StringBuffer(WEBSPHERE_DOMAIN_NAME).append(MBEAN_FIELD_BUS_ID_KEY).append("=").append(busIdValue).append(",").append(MBEAN_FIELD_TYPE_KEY).append("=").append(typeValue).append(",").append(MBEAN_FIELD_SERVICE_KEY).append("=").append(serviceValue).append(",").append(MBEAN_FIELD_PORT_KEY).append("=").append(portValue).append(",").append(MBEAN_FIELD_NAME_KEY).append("=").append(nameTargetValue).toString();
                } else {
                    targetNameStr = targetNameStr + ",name=" + nameTargetValue;
                }
            } else {
                targetNameStr = targetNameStr + ",name=" + nameTargetValue;
            }
        }
        return targetNameStr;
    }

    private boolean shouldBeRegisteredToWebSphereDomain(ObjectName name) {
        boolean result = true;
        String typeValue = name.getKeyProperty(MBEAN_FIELD_TYPE_KEY);
        if (null == typeValue) {
            result = true;
        } else if (typeValue.equalsIgnoreCase(MBEAN_TYPE_BUS) || typeValue.equalsIgnoreCase(MBEAN_TYPE_WORK_QUEUE_MANAGER)) {
            result = false;
        }
        return result;
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new MBeanRegistrationException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new MBeanRegistrationException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        throw new MBeanRegistrationException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        throw new MBeanRegistrationException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return null;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return null;
    }

    @Override
    public Integer getMBeanCount() {
        return null;
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public String getDefaultDomain() {
        return null;
    }

    @Override
    public String[] getDomains() {
        return null;
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new MBeanException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public Object instantiate(String className, Object[] params, String[] signature) throws ReflectionException, MBeanException {
        throw new MBeanException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public Object instantiate(String className, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, MBeanException, InstanceNotFoundException {
        throw new MBeanException(null, ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInputStream deserialize(ObjectName name, byte[] data) throws InstanceNotFoundException, OperationsException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInputStream deserialize(String className, byte[] data) throws OperationsException, ReflectionException {
        throw new OperationsException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ObjectInputStream deserialize(String className, ObjectName loaderName, byte[] data) throws InstanceNotFoundException, OperationsException, ReflectionException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName mbeanName) throws InstanceNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName loaderName) throws InstanceNotFoundException {
        throw new InstanceNotFoundException(ERR_UNSUPPORTED_METHOD);
    }

    @Override
    public ClassLoaderRepository getClassLoaderRepository() {
        return null;
    }
}

