/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLGetInterceptor;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.Conduit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyJaxWsCompatibleWSDLGetInterceptor
extends WSDLGetInterceptor {
    private static final TraceComponent tc = Tr.register(LibertyJaxWsCompatibleWSDLGetInterceptor.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private static final Document noWSDLDoc = DOMUtils.createDocument();
    private final String implBeanClazzName;
    private final String wsdlLocation;
    private final boolean wsdlLoationExisted;
    private final Document noWSDLLocationDoc;
    static final long serialVersionUID = -2309407646693240865L;

    public LibertyJaxWsCompatibleWSDLGetInterceptor(String implBeanClazzName, String wsdlLocation, boolean wsdlLoationExisted) {
        this.implBeanClazzName = implBeanClazzName;
        this.wsdlLocation = wsdlLocation;
        this.wsdlLoationExisted = wsdlLoationExisted;
        this.noWSDLLocationDoc = DOMUtils.createDocument();
        if (!wsdlLoationExisted) {
            Element root = this.noWSDLLocationDoc.createElement("Error");
            root.setTextContent(Tr.formatMessage((TraceComponent)tc, (String)"error.no.wsdl.find", (Object[])new Object[]{wsdlLocation, implBeanClazzName}));
            this.noWSDLLocationDoc.appendChild(root);
        }
    }

    public Document getDocument(Message message, String base, Map<String, String> params, String ctxUri, EndpointInfo endpointInfo) {
        if (this.wsdlLoationExisted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"warn.no.wsdl.generate", (Object[])new Object[]{this.implBeanClazzName});
            }
            return noWSDLDoc;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"error.no.wsdl.find", (Object[])new Object[]{this.wsdlLocation, this.implBeanClazzName});
        }
        return this.noWSDLLocationDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        String query = (String)message.get((Object)Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty((String)query)) {
            return;
        }
        String baseUri = (String)message.get((Object)"org.apache.cxf.request.url");
        String ctx = (String)message.get((Object)Message.PATH_INFO);
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            Map map = UrlUtils.parseQueryString((String)query);
            if (this.isRecognizedQuery(map, baseUri, ctx, message.getExchange().getEndpoint().getEndpointInfo())) {
                try {
                    Conduit c = message.getExchange().getDestination().getBackChannel(message);
                    Endpoint e = message.getExchange().getEndpoint();
                    MessageImpl mout = new MessageImpl();
                    mout.setExchange(message.getExchange());
                    message.getExchange().setOutMessage((Message)mout);
                    mout.put((Object)Message.RESPONSE_CODE, (Object)404);
                    mout.put((Object)"Content-Type", (Object)"text/xml");
                    c.prepare((Message)mout);
                    OutputStream os = (OutputStream)mout.getContent(OutputStream.class);
                    Document doc = this.getDocument(message, baseUri, map, ctx, message.getExchange().getEndpoint().getEndpointInfo());
                    String enc = null;
                    try {
                        enc = doc.getXmlEncoding();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsCompatibleWSDLGetInterceptor", (String)"141", (Object)((Object)this), (Object[])new Object[]{message});
                    }
                    if (enc == null) {
                        enc = "utf-8";
                    }
                    XMLStreamWriter writer = null;
                    try {
                        writer = StaxUtils.createXMLStreamWriter((OutputStream)os, (String)enc);
                        StaxUtils.writeNode((Node)doc, (XMLStreamWriter)writer, (boolean)true);
                        message.getInterceptorChain().abort();
                        writer.flush();
                        os.flush();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsCompatibleWSDLGetInterceptor", (String)"155", (Object)((Object)this), (Object[])new Object[]{message});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                            void ex;
                            Tr.info((TraceComponent)tc, (String)"error.write.wsdl.stream", (Object[])new Object[]{ex});
                        }
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                catch (IOException c) {
                    void e;
                    FFDCFilter.processException((Throwable)c, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsCompatibleWSDLGetInterceptor", (String)"172", (Object)((Object)this), (Object[])new Object[]{message});
                    throw new Fault((Throwable)e);
                }
                catch (XMLStreamException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jaxws.support.LibertyJaxWsCompatibleWSDLGetInterceptor", (String)"174", (Object)((Object)this), (Object[])new Object[]{message});
                    throw new Fault((Throwable)e);
                }
                finally {
                    message.getExchange().setOutMessage(null);
                }
            }
        }
    }

    public boolean isRecognizedQuery(Map<String, String> map, String baseUri, String ctx, EndpointInfo endpointInfo) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        Element root = noWSDLDoc.createElement("Error");
        root.setTextContent(Tr.formatMessage((TraceComponent)tc, (String)"error.no.wsdl.per.specification", (Object[])new Object[0]));
        noWSDLDoc.appendChild(root);
    }
}

