/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.support;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.InterfaceInfo;

@NoJSR250Annotations
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyLoggingInInterceptor
extends LoggingInInterceptor {
    public static final LibertyLoggingInInterceptor INSTANCE = new LibertyLoggingInInterceptor();
    private static final Logger LOG = LogUtils.getLogger(LoggingInInterceptor.class);
    private static final TraceComponent tc = Tr.register(LibertyLoggingInInterceptor.class, null);
    private static boolean loggingInterceptorConfigProp = false;
    static final long serialVersionUID = -2119331931886222911L;

    public LibertyLoggingInInterceptor() {
        super("receive");
    }

    public LibertyLoggingInInterceptor(String phase) {
        super(phase);
    }

    public LibertyLoggingInInterceptor(String id, String phase) {
        super(id, phase);
    }

    public LibertyLoggingInInterceptor(int lim) {
        this();
        this.limit = lim;
    }

    public LibertyLoggingInInterceptor(String id, int lim) {
        this(id, "receive");
        this.limit = lim;
    }

    public LibertyLoggingInInterceptor(PrintWriter w) {
        this();
        this.writer = w;
    }

    public LibertyLoggingInInterceptor(String id, PrintWriter w) {
        this(id, "receive");
        this.writer = w;
    }

    public LibertyLoggingInInterceptor(boolean loggingInterceptorConfigProp) {
        this();
        LibertyLoggingInInterceptor.loggingInterceptorConfigProp = loggingInterceptorConfigProp;
    }

    public void handleMessage(Message message) throws Fault {
        Logger logger = this.getMessageLogger(message);
        if (tc.isDebugEnabled()) {
            if (logger.isLoggable(Level.INFO) || this.writer != null) {
                this.logging(logger, message);
            }
        } else if (loggingInterceptorConfigProp && (logger.isLoggable(Level.INFO) || this.writer != null)) {
            this.logging(logger, message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    protected void logging(Logger logger, Message message) throws Fault {
        String uri;
        Object headers;
        String ct;
        String httpMethod;
        String encoding;
        if (message.containsKey((Object)LoggingMessage.ID_KEY)) {
            return;
        }
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        message.put((Object)LoggingMessage.ID_KEY, (Object)id);
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((uri = (String)message.get((Object)"org.apache.cxf.request.url")) != null) {
            buffer.getAddress().append(uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        if (!this.isShowBinaryContent() && this.isBinaryContent(ct)) {
            buffer.getMessage().append("--- Binary Content ---").append('\n');
            this.log(logger, buffer.toString());
            return;
        }
        InputStream is = (InputStream)message.getContent(InputStream.class);
        if (is != null) {
            CachedOutputStream bos = new CachedOutputStream();
            if (this.threshold > 0L) {
                bos.setThreshold(this.threshold);
            }
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                bos.flush();
                is.close();
                message.setContent(InputStream.class, (Object)bos.getInputStream());
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                if (bos.size() > (long)this.limit) {
                    buffer.getMessage().append("(message truncated to " + this.limit + " bytes)\n");
                }
                this.writePayload(buffer.getPayload(), bos, encoding, ct, this.prettyLogging);
                bos.close();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"187", (Object)((Object)this), (Object[])new Object[]{logger, message});
                throw new Fault((Throwable)e);
            }
        }
        Reader reader = (Reader)message.getContent(Reader.class);
        if (reader != null) {
            try {
                BufferedReader r = new BufferedReader(reader, this.limit);
                r.mark(this.limit);
                char[] b = new char[this.limit];
                int i = r.read(b);
                buffer.getPayload().append(b, 0, i);
                r.reset();
                message.setContent(Reader.class, (Object)r);
            }
            catch (Exception r) {
                void e;
                FFDCFilter.processException((Throwable)r, (String)"com.ibm.ws.jaxws.support.LibertyLoggingInInterceptor", (String)"201", (Object)((Object)this), (Object[])new Object[]{logger, message});
                throw new Fault((Throwable)e);
            }
        }
        this.log(logger, this.formatLoggingMessage(buffer));
    }

    @Trivial
    protected String formatLoggingMessage(LoggingMessage loggingMessage) {
        return loggingMessage.toString();
    }

    protected Logger getLogger() {
        return LOG;
    }

    @Trivial
    public void setEnableLoggingProp(boolean loggingInterceptorConfigProp) {
        LibertyLoggingInInterceptor.loggingInterceptorConfigProp = loggingInterceptorConfigProp;
    }

    @Trivial
    Logger getMessageLogger(Message message) {
        if (LibertyLoggingInInterceptor.isLoggingDisabledNow((Message)message)) {
            return null;
        }
        Endpoint ep = message.getExchange().getEndpoint();
        if (ep == null || ep.getEndpointInfo() == null) {
            return this.getLogger();
        }
        EndpointInfo endpoint = ep.getEndpointInfo();
        if (endpoint.getService() == null) {
            return this.getLogger();
        }
        Logger logger = (Logger)endpoint.getProperty("MessageLogger", Logger.class);
        if (logger == null) {
            String serviceName = endpoint.getService().getName().getLocalPart();
            InterfaceInfo iface = endpoint.getService().getInterface();
            String portName = endpoint.getName().getLocalPart();
            String portTypeName = iface.getName().getLocalPart();
            String logName = "org.apache.cxf.services." + serviceName + "." + portName + "." + portTypeName;
            logger = LogUtils.getL7dLogger(((Object)((Object)this)).getClass(), null, (String)logName);
            endpoint.setProperty("MessageLogger", (Object)logger);
        }
        return logger;
    }
}

