/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.internal.ManagedThreadFactoryService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.enterprise.concurrent.ManageableThread;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class ManagedThreadImpl
extends Thread
implements ManageableThread {
    private static final TraceComponent tc = Tr.register(ManagedThreadImpl.class, (String)"concurrent", (String)"com.ibm.ws.concurrent.resources.CWWKCMessages");
    private final ManagedThreadFactoryService.ManagedThreadFactoryImpl threadFactory;
    static final long serialVersionUID = 7868732330517710223L;

    ManagedThreadImpl(ManagedThreadFactoryService.ManagedThreadFactoryImpl threadFactory, Runnable runnable, String name) {
        super(threadFactory.threadGroup, runnable, name);
        this.threadFactory = threadFactory;
        if (threadFactory.service.createDaemonThreads != this.isDaemon() || threadFactory.service.defaultPriority != null && threadFactory.service.defaultPriority.intValue() != this.getPriority()) {
            AccessController.doPrivileged(new InitAction(), threadFactory.serverAccessControlContext);
        }
    }

    @Override
    public void interrupt() {
        if (this.threadFactory.sameMetaDataIdentity()) {
            AccessController.doPrivileged(new InterruptAction(), this.threadFactory.serverAccessControlContext);
        } else {
            super.interrupt();
        }
    }

    @Trivial
    private final void interruptSuper() {
        super.interrupt();
    }

    public final boolean isShutdown() {
        return this.threadFactory.service.isShutdown.get() || this.getState() == Thread.State.TERMINATED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Trivial
    @ManualTrace
    public void run() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"run", (Object[])new Object[0]);
        }
        try {
            ArrayList contextAppliedToThread = this.threadFactory.threadContextDescriptor.taskStarting();
            try {
                super.run();
            }
            finally {
                this.threadFactory.threadContextDescriptor.taskStopping(contextAppliedToThread);
            }
        }
        catch (Error contextAppliedToThread) {
            void x;
            FFDCFilter.processException((Throwable)contextAppliedToThread, (String)"com.ibm.ws.concurrent.internal.ManagedThreadImpl", (String)"98", (Object)this, (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run", (Object)x);
            }
            throw x;
        }
        catch (RuntimeException x) {
            FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.concurrent.internal.ManagedThreadImpl", (String)"102", (Object)this, (Object[])new Object[0]);
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"run", (Object)x);
            }
            throw x;
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"run");
        }
    }

    @Override
    public void start() {
        if (this.threadFactory.service.isShutdown.get()) {
            this.interrupt();
        }
        super.start();
    }

    @Trivial
    private class InterruptAction
    implements PrivilegedAction<Void> {
        private InterruptAction() {
        }

        @Override
        public Void run() {
            ManagedThreadImpl.this.interruptSuper();
            return null;
        }
    }

    @Trivial
    private class InitAction
    implements PrivilegedAction<Void> {
        private InitAction() {
        }

        @Override
        public Void run() {
            if (((ManagedThreadImpl)ManagedThreadImpl.this).threadFactory.service.createDaemonThreads != ManagedThreadImpl.this.isDaemon()) {
                ManagedThreadImpl.this.setDaemon(((ManagedThreadImpl)ManagedThreadImpl.this).threadFactory.service.createDaemonThreads);
            }
            if (((ManagedThreadImpl)ManagedThreadImpl.this).threadFactory.service.defaultPriority != null && ((ManagedThreadImpl)ManagedThreadImpl.this).threadFactory.service.defaultPriority.intValue() != ManagedThreadImpl.this.getPriority()) {
                ManagedThreadImpl.this.setPriority(((ManagedThreadImpl)ManagedThreadImpl.this).threadFactory.service.defaultPriority);
            }
            return null;
        }
    }
}

