/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.OpcodeType;
import com.ibm.ws.wsoc.RemoteOutputStream;
import com.ibm.ws.wsoc.RemoteWriter;
import com.ibm.ws.wsoc.ServiceManager;
import com.ibm.ws.wsoc.WsocConnLink;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import jakarta.websocket.EncodeException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RemoteEndpointBasicImpl {
    private static final TraceComponent tc = Tr.register(RemoteEndpointBasicImpl.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    WsByteBufferPoolManager wsbbManager = null;
    WsocConnLink connLink = null;
    MessageWriteState messageWriteState = MessageWriteState.PARTIAL_NOT_IN_USE;
    static final long serialVersionUID = 3878061313123655127L;

    public void initialize(WsocConnLink _connLink) {
        this.connLink = _connLink;
        this.messageWriteState = MessageWriteState.PARTIAL_NOT_IN_USE;
    }

    private WsByteBufferPoolManager getBufferManager() {
        return ServiceManager.getBufferPoolManager();
    }

    public void sendPing(@Sensitive ByteBuffer data) throws IOException {
        this.sendBinaryCommon(data, OpcodeType.PING, true);
    }

    public void sendPong(@Sensitive ByteBuffer data) throws IOException {
        this.sendBinaryCommon(data, OpcodeType.PONG, true);
    }

    /*
     * WARNING - void declaration
     */
    public void sendBinaryFromAsyncRemote(@Sensitive ByteBuffer data, OpcodeType type) {
        try {
            this.sendBinary(data, type);
        }
        catch (IOException iOException) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive java.nio.ByteBuffer>";
            objectArray[1] = type;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.wsoc.RemoteEndpointBasicImpl", (String)"69", (Object)this, (Object[])objectArray);
            this.connLink.callOnError((Throwable)e);
        }
    }

    public void sendBinary(@Sensitive ByteBuffer data, OpcodeType type) throws IOException {
        if (this.messageWriteState != MessageWriteState.PARTIAL_NOT_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Send while Send outstanding error.  throw IllegalStateException", (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        WsocConnLink.RETURN_STATUS ret = this.sendBinaryCommon(data, type, false);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            IllegalStateException up = new IllegalStateException("write not allowed.  Most likely cause is that another Write or Close is in progress");
            throw up;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBinary(@Sensitive ByteBuffer data, OpcodeType type, boolean isLast) throws IOException {
        OpcodeType t = type;
        if (this.messageWriteState == MessageWriteState.PARTIAL_TEXT_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Send while Send outstanding error.  throw IllegalStateException", (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        if (this.messageWriteState == MessageWriteState.PARTIAL_NOT_IN_USE) {
            this.messageWriteState = MessageWriteState.PARTIAL_BINARY_IN_USE;
            t = isLast ? OpcodeType.BINARY_WHOLE : OpcodeType.BINARY_PARTIAL_FIRST;
        } else {
            t = isLast ? OpcodeType.BINARY_PARTIAL_LAST : OpcodeType.BINARY_PARTIAL_CONTINUATION;
        }
        try {
            WsocConnLink.RETURN_STATUS ret = this.sendBinaryCommon(data, t, false);
            if (ret != WsocConnLink.RETURN_STATUS.OK) {
                IllegalStateException up = new IllegalStateException("write not allowed.  Most likely cause is that another Write or Close is in progress");
                throw up;
            }
        }
        finally {
            if (isLast) {
                this.messageWriteState = MessageWriteState.PARTIAL_NOT_IN_USE;
            }
        }
    }

    private WsocConnLink.RETURN_STATUS sendBinaryCommon(@Sensitive ByteBuffer data, OpcodeType type, boolean wait) throws IOException {
        WsByteBuffer wsbb = this.getBufferManager().wrap(data);
        return this.connLink.writeBufferForBasicRemoteSync(wsbb, type, -1, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendText(@Sensitive String textToSend, boolean isLast) throws IOException {
        OpcodeType t = null;
        if (this.messageWriteState == MessageWriteState.PARTIAL_BINARY_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Send while Send outstanding error.  throw IllegalStateException. messageWriteState is: " + (Object)((Object)this.messageWriteState)), (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        if (this.messageWriteState == MessageWriteState.PARTIAL_NOT_IN_USE) {
            this.messageWriteState = MessageWriteState.PARTIAL_TEXT_IN_USE;
            t = isLast ? OpcodeType.TEXT_WHOLE : OpcodeType.TEXT_PARTIAL_FIRST;
        } else {
            t = isLast ? OpcodeType.TEXT_PARTIAL_LAST : OpcodeType.TEXT_PARTIAL_CONTINUATION;
        }
        try {
            WsocConnLink.RETURN_STATUS ret = this.sendTextCommon(textToSend, t);
            if (ret != WsocConnLink.RETURN_STATUS.OK) {
                IllegalStateException up = new IllegalStateException("write not allowed.  Most likely cause is that another Write or Close is in progress");
                throw up;
            }
        }
        finally {
            if (isLast) {
                this.messageWriteState = MessageWriteState.PARTIAL_NOT_IN_USE;
            }
        }
    }

    public void sendText(@Sensitive String textToSend) throws IOException {
        if (this.messageWriteState != MessageWriteState.PARTIAL_NOT_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Send while Send outstanding error.  throw IllegalStateException", (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        WsocConnLink.RETURN_STATUS ret = this.sendTextCommon(textToSend, OpcodeType.TEXT_WHOLE);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            IllegalStateException up = new IllegalStateException("write not allowed.  Most likely cause is that another Write or Close is in progress");
            throw up;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WsocConnLink.RETURN_STATUS sendTextCommon(@Sensitive String textToSend, OpcodeType type) throws IOException {
        WsocConnLink.RETURN_STATUS ret = null;
        byte[] ba = textToSend.getBytes();
        ba = textToSend.getBytes(Utils.UTF8_CHARSET);
        WsByteBuffer wsbb = this.getBufferManager().allocate(ba.length);
        wsbb.put(ba);
        wsbb.position(0);
        wsbb.limit(ba.length);
        try {
            ret = this.connLink.writeBufferForBasicRemoteSync(wsbb, type, -1, false);
        }
        finally {
            wsbb.release();
        }
        return ret;
    }

    public void sendObject(@Sensitive Object data) throws IOException, EncodeException {
        if (this.messageWriteState != MessageWriteState.PARTIAL_NOT_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Send while Send outstanding error.  throw IllegalStateException", (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        WsocConnLink.RETURN_STATUS ret = this.connLink.writeObjectBasicRemoteSync(data);
        if (ret != WsocConnLink.RETURN_STATUS.OK) {
            IllegalStateException up = new IllegalStateException("write not allowed.  Most likely cause is that another Write or Close is in progress");
            throw up;
        }
    }

    public OutputStream getSendStream() throws IOException {
        if (this.messageWriteState != MessageWriteState.PARTIAL_NOT_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Send while Send outstanding error.  throw IllegalStateException", (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        RemoteOutputStream ros = new RemoteOutputStream();
        ros.initialize(this.connLink);
        return ros;
    }

    public Writer getSendWriter() throws IOException {
        if (this.messageWriteState != MessageWriteState.PARTIAL_NOT_IN_USE) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Send while Send outstanding error.  throw IllegalStateException", (Object[])new Object[0]);
            }
            IllegalStateException up = new IllegalStateException();
            throw up;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        RemoteWriter rw = new RemoteWriter(bos);
        rw.initialize(this.connLink);
        return rw;
    }

    public static enum MessageWriteState {
        PARTIAL_NOT_IN_USE,
        PARTIAL_TEXT_IN_USE,
        PARTIAL_BINARY_IN_USE;

    }
}

