/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.corba;

import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

public class Field {
    final long fieldID;
    static final Unsafe unsafe = Field.getUnsafe();
    static final Logger logger = Logger.getLogger(Field.class.getName());

    private static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            Class<Unsafe> uc = Unsafe.class;
            java.lang.reflect.Field[] fields = uc.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals("theUnsafe")) continue;
                fields[i].setAccessible(true);
                unsafe = (Unsafe)fields[i].get(uc);
                break;
            }
        }
        catch (Exception ignore) {
            logger.log(Level.FINE, "exception getting unsafe", ignore);
        }
        return unsafe;
    }

    public Field(java.lang.reflect.Field f) {
        this.fieldID = Modifier.isStatic(f.getModifiers()) ? unsafe.staticFieldOffset(f) : unsafe.objectFieldOffset(f);
    }

    public void set(Object obj, Object val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putObject(obj, this.fieldID, val);
    }

    public void setByte(Object obj, byte val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putByte(obj, this.fieldID, val);
    }

    public void setBoolean(Object obj, boolean val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putBoolean(obj, this.fieldID, val);
    }

    public void setShort(Object obj, short val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putShort(obj, this.fieldID, val);
    }

    public void setChar(Object obj, char val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putChar(obj, this.fieldID, val);
    }

    public void setInt(Object obj, int val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putInt(obj, this.fieldID, val);
    }

    public void setLong(Object obj, long val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putLong(obj, this.fieldID, val);
    }

    public void setFloat(Object obj, float val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putFloat(obj, this.fieldID, val);
    }

    public void setDouble(Object obj, double val) throws IllegalArgumentException, IllegalAccessException {
        unsafe.putDouble(obj, this.fieldID, val);
    }

    public Object get(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getObject(obj, this.fieldID);
    }

    public byte getByte(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getByte(obj, this.fieldID);
    }

    public boolean getBoolean(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getBoolean(obj, this.fieldID);
    }

    public short getShort(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getShort(obj, this.fieldID);
    }

    public char getChar(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getChar(obj, this.fieldID);
    }

    public int getInt(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getInt(obj, this.fieldID);
    }

    public long getLong(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getLong(obj, this.fieldID);
    }

    public float getFloat(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getFloat(obj, this.fieldID);
    }

    public double getDouble(Object obj) throws IllegalArgumentException, IllegalAccessException {
        return unsafe.getDouble(obj, this.fieldID);
    }
}

