/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.diagnostics.class_scanner.ano;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.AsmHelper;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ArrayEntryType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ArrayInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.EnumerationInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ObjectFieldInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ObjectInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ObjectReferenceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.PropertiesType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.PropertyType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ValueInstanceType;
import com.ibm.ws.jpa.diagnostics.class_scanner.ano.jaxb.classinfo10.ValueType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.objectweb.asm.Type;

public class AsmObjectValueAnalyzer {
    private static final AtomicLong objIDCounter = new AtomicLong(0L);
    private static final String PROPNAME_ACTUAL_TYPE = "actual.type";

    public static ValueInstanceType processValue(Object value) {
        return AsmObjectValueAnalyzer.processValueInternal(value, new HashMap<Object, Long>());
    }

    public static ValueInstanceType processEnum(String name, String desc, String value) {
        return AsmObjectValueAnalyzer.processEnumInternal(name, desc, value, new HashMap<Object, Long>());
    }

    private static ValueInstanceType processValueInternal(Object value, Map<Object, Long> objMap) {
        ValueInstanceType vit = new ValueInstanceType();
        if (value == null) {
            vit.setType(ValueType.NULL);
            return vit;
        }
        if ("org.objectweb.asm.Type".equals(value.getClass().getName())) {
            Type type = (Type)value;
            ObjectInstanceType oit = new ObjectInstanceType();
            oit.setClassName(type.getClassName());
            vit.setObject(oit);
            vit.setType(ValueType.OBJECT);
            return vit;
        }
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            vit.setType(ValueType.ARRAY);
            ArrayInstanceType ait = new ArrayInstanceType();
            vit.setArray(ait);
            int length = Array.getLength(value);
            ait.setLength(length);
            if (length > 0) {
                for (int index = 0; index < length; ++index) {
                    ArrayEntryType aet = new ArrayEntryType();
                    aet.setIndex(index);
                    ait.getEntry().add(aet);
                    Object oVal = Array.get(value, index);
                    ValueInstanceType arrayVit = AsmObjectValueAnalyzer.processValueInternal(oVal, objMap);
                    aet.setValue(arrayVit);
                }
            }
            return vit;
        }
        if (cls.isPrimitive()) {
            if (cls.equals(Boolean.TYPE)) {
                vit.setType(ValueType.BOOLEAN);
                vit.setSimple(String.format("%b", value));
            } else if (cls.equals(Byte.TYPE)) {
                vit.setType(ValueType.BYTE);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(Character.TYPE)) {
                vit.setType(ValueType.CHAR);
                vit.setSimple(String.format("%c", value));
            } else if (cls.equals(Double.TYPE)) {
                vit.setType(ValueType.DOUBLE);
                vit.setSimple(String.format("%f", value));
            } else if (cls.equals(Float.TYPE)) {
                vit.setType(ValueType.FLOAT);
                vit.setSimple(String.format("%f", value));
            } else if (cls.equals(Integer.TYPE)) {
                vit.setType(ValueType.INT);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(Long.TYPE)) {
                vit.setType(ValueType.LONG);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(Short.TYPE)) {
                vit.setType(ValueType.SHORT);
                vit.setSimple(String.format("%d", value));
            } else {
                vit.setType(ValueType.UNKNOWN);
            }
            return vit;
        }
        if (Number.class.isAssignableFrom(cls)) {
            if (cls.equals(Byte.class)) {
                vit.setType(ValueType.JAVA_LANG_BYTE);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(Double.class)) {
                vit.setType(ValueType.JAVA_LANG_DOUBLE);
                vit.setSimple(String.format("%f", value));
            } else if (cls.equals(Float.class)) {
                vit.setType(ValueType.JAVA_LANG_FLOAT);
                vit.setSimple(String.format("%f", value));
            } else if (cls.equals(Integer.class)) {
                vit.setType(ValueType.JAVA_LANG_INTEGER);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(Long.class)) {
                vit.setType(ValueType.JAVA_LANG_LONG);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(Short.class)) {
                vit.setType(ValueType.JAVA_LANG_SHORT);
                vit.setSimple(String.format("%d", value));
            } else if (cls.equals(AtomicInteger.class)) {
                vit.setType(ValueType.JAVA_LANG_INTEGER);
                vit.setSimple(String.format("%d", ((AtomicInteger)value).get()));
                PropertiesType props = new PropertiesType();
                PropertyType prop = new PropertyType();
                prop.setName(PROPNAME_ACTUAL_TYPE);
                prop.setValue("java.util.concurrent.atomic.AtomicInteger");
                props.getProperty().add(prop);
                vit.setProperties(props);
            } else if (cls.equals(AtomicLong.class)) {
                vit.setType(ValueType.JAVA_LANG_INTEGER);
                vit.setSimple(String.format("%d", ((AtomicLong)value).get()));
                PropertiesType props = new PropertiesType();
                PropertyType prop = new PropertyType();
                prop.setName(PROPNAME_ACTUAL_TYPE);
                prop.setValue("java.util.concurrent.atomic.AtomicLong");
                props.getProperty().add(prop);
                vit.setProperties(props);
            } else if (cls.equals(BigDecimal.class)) {
                vit.setType(ValueType.JAVA_LANG_STRING);
                vit.setSimple(String.format("%s", ((BigDecimal)value).toString()));
                PropertiesType props = new PropertiesType();
                PropertyType prop = new PropertyType();
                prop.setName(PROPNAME_ACTUAL_TYPE);
                prop.setValue("java.math.BigDecimal");
                props.getProperty().add(prop);
                vit.setProperties(props);
            } else if (cls.equals(BigInteger.class)) {
                vit.setType(ValueType.JAVA_LANG_STRING);
                vit.setSimple(String.format("%s", ((BigInteger)value).toString()));
                PropertiesType props = new PropertiesType();
                PropertyType prop = new PropertyType();
                prop.setName(PROPNAME_ACTUAL_TYPE);
                prop.setValue("java.math.BigInteger");
                props.getProperty().add(prop);
                vit.setProperties(props);
            } else {
                vit.setType(ValueType.UNKNOWN);
                vit.setSimple(value.toString());
                PropertiesType props = new PropertiesType();
                PropertyType prop = new PropertyType();
                prop.setName(PROPNAME_ACTUAL_TYPE);
                prop.setValue(value.getClass().getName());
                props.getProperty().add(prop);
                vit.setProperties(props);
            }
            return vit;
        }
        if (cls.equals(Boolean.class)) {
            vit.setType(ValueType.JAVA_LANG_BOOLEAN);
            vit.setSimple(String.format("%b", value));
        } else if (cls.equals(Character.class)) {
            vit.setType(ValueType.JAVA_LANG_CHARACTER);
            vit.setSimple(String.format("%c", value));
        } else if (cls.equals(String.class)) {
            vit.setType(ValueType.JAVA_LANG_STRING);
            vit.setSimple(String.format("%s", value));
        } else {
            vit.setType(ValueType.OBJECT);
            if (objMap != null && objMap.containsKey(value)) {
                ObjectReferenceType ort = new ObjectReferenceType();
                ort.setRefId(objMap.get(value));
                vit.setObjectref(ort);
            } else {
                Long id = objIDCounter.incrementAndGet();
                objMap.put(value, id);
                ObjectInstanceType oit = new ObjectInstanceType();
                AsmObjectValueAnalyzer.processObjectInternal(oit, value, objMap);
                vit.setObject(oit);
            }
        }
        return vit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processObjectInternal(ObjectInstanceType oit, Object value, Map<Object, Long> objMap) {
        Class<?> c = value.getClass();
        oit.setClassName(c.getName());
        List<ObjectFieldInstanceType> ofitList = oit.getField();
        HashSet<Field> fieldsSet = new HashSet<Field>();
        HashSet historySet = new HashSet();
        int breakoutCount = 200;
        for (Class<?> classWalker = c; --breakoutCount > 0 && !historySet.contains(classWalker) && classWalker != null && !Object.class.equals(classWalker); classWalker = classWalker.getSuperclass()) {
            historySet.add(classWalker);
            Field[] declaredFields = classWalker.getDeclaredFields();
            if (declaredFields == null || declaredFields.length <= 0) continue;
            for (Field f : declaredFields) {
                fieldsSet.add(f);
            }
        }
        for (Field f : fieldsSet) {
            ObjectFieldInstanceType ofit = new ObjectFieldInstanceType();
            ofitList.add(ofit);
            boolean accessible = f.isAccessible();
            try {
                f.setAccessible(true);
                Class<?> fClass = f.getType();
                ofit.setClassName(fClass.getName());
                ofit.setName(f.getName());
                Object fValue = f.get(value);
                ValueInstanceType vit = AsmObjectValueAnalyzer.processValueInternal(fValue, objMap);
                ofit.setValue(vit);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(AsmObjectValueAnalyzer.class.getName() + ".processObjectInternal"), (String)"220");
            }
            finally {
                f.setAccessible(accessible);
            }
        }
    }

    private static ValueInstanceType processEnumInternal(String name, String desc, String value, Map<Object, Long> objMap) {
        ValueInstanceType vit = new ValueInstanceType();
        vit.setType(ValueType.ENUM);
        EnumerationInstanceType eit = new EnumerationInstanceType();
        vit.setEnum(eit);
        Type type = Type.getType((String)desc);
        if (type != null) {
            String processedName = AsmHelper.normalizeClassName(type.getClassName());
            eit.setClassName(processedName);
            eit.setValue(value);
        }
        return vit;
    }
}

