/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.startlevel.BundleStartLevel;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BundleInstallStatus {
    private List<Throwable> otherExceptions = null;
    private Collection<Bundle> bundlesToStart = null;
    private List<FeatureResource> missingBundles = null;
    private List<String> missingFeatures = null;
    private List<String> conflictFeatures = null;
    protected volatile IllegalStateException invalidContextEx = null;
    private Map<String, Throwable> installExceptions = null;
    private Collection<Bundle> bundlesDelta = null;
    private Collection<Bundle> bundlesRemovedDelta = null;
    static final Comparator<Bundle> sortByStartLevel;
    static final long serialVersionUID = -1399972967751397786L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public boolean contextIsValid() {
        return this.invalidContextEx == null;
    }

    public void markContextInvalid(IllegalStateException ise) {
        this.invalidContextEx = ise;
    }

    public void rethrowInvalidContextException() {
        if (this.invalidContextEx != null) {
            throw this.invalidContextEx;
        }
    }

    public boolean canContinue(boolean continueOnError) {
        return continueOnError || !this.otherExceptions() && !this.bundlesMissing() && !this.featuresMissing() && !this.installExceptions() && !this.featuresConflict();
    }

    @Trivial
    public boolean otherExceptions() {
        return this.otherExceptions != null;
    }

    @Trivial
    public boolean bundlesMissing() {
        return this.missingBundles != null;
    }

    @Trivial
    public boolean featuresMissing() {
        return this.missingFeatures != null;
    }

    @Trivial
    public boolean bundlesToStart() {
        return this.bundlesToStart != null;
    }

    @Trivial
    public boolean installExceptions() {
        return this.installExceptions != null;
    }

    @Trivial
    public boolean featuresConflict() {
        return this.conflictFeatures != null;
    }

    public List<Throwable> getOtherExceptions() {
        return this.otherExceptions;
    }

    public List<FeatureResource> getMissingBundles() {
        return this.missingBundles;
    }

    public List<String> getMissingFeatures() {
        return this.missingFeatures;
    }

    public Collection<Bundle> getBundlesToStart() {
        return this.bundlesToStart;
    }

    public Map<String, Throwable> getInstallExceptions() {
        return this.installExceptions;
    }

    public Collection<String> getConflictFeatures() {
        return this.conflictFeatures;
    }

    public void addMissingBundle(FeatureResource fr) {
        if (this.missingBundles == null) {
            this.missingBundles = new ArrayList<FeatureResource>();
        }
        this.missingBundles.add(fr);
    }

    public void addMissingFeature(String bundleKey) {
        if (this.missingFeatures == null) {
            this.missingFeatures = new ArrayList<String>();
        }
        this.missingFeatures.add(bundleKey);
    }

    public void addBundleAddedDelta(Bundle bundle) {
        if (this.bundlesDelta == null) {
            this.bundlesDelta = new TreeSet<Bundle>(sortByStartLevel);
        }
        this.bundlesDelta.add(bundle);
    }

    public void addBundleRemovedDelta(Bundle bundle) {
        if (this.bundlesRemovedDelta == null) {
            this.bundlesRemovedDelta = new HashSet<Bundle>();
        }
        this.bundlesRemovedDelta.add(bundle);
    }

    public void addBundleToStart(Bundle bundle) {
        if (this.bundlesToStart == null) {
            this.bundlesToStart = new TreeSet<Bundle>(sortByStartLevel);
        }
        this.bundlesToStart.add(bundle);
    }

    public void addInstallException(String bundleKey, Throwable e) {
        if (this.installExceptions == null) {
            this.installExceptions = new HashMap<String, Throwable>();
        }
        this.installExceptions.put(bundleKey, e);
    }

    public void addOtherException(Throwable t) {
        if (this.otherExceptions == null) {
            this.otherExceptions = new ArrayList<Throwable>();
        }
        this.otherExceptions.add(t);
    }

    public void addConflictFeature(String feature) {
        if (this.conflictFeatures == null) {
            this.conflictFeatures = new ArrayList<String>();
        }
        this.conflictFeatures.add(feature);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[missingBundles=" + this.missingBundles + ",missingFeatures=" + this.missingFeatures + ",bundlesToStart=" + this.bundlesToStart + ",otherExceptions=" + this.otherExceptions + ",installExceptions=" + this.installExceptions + ",conflictingFeatures=" + this.conflictFeatures + "]";
    }

    public Collection<Bundle> getBundlesAddedDelta() {
        return this.bundlesDelta;
    }

    public Collection<Bundle> getBundlesRemovedDelta() {
        return this.bundlesRemovedDelta;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.BundleInstallStatus", BundleInstallStatus.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
        sortByStartLevel = new Comparator<Bundle>(){
            static final long serialVersionUID = -7502055521353185039L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public int compare(Bundle b1, Bundle b2) {
                int sl2;
                int sl1 = ((BundleStartLevel)b1.adapt(BundleStartLevel.class)).getStartLevel();
                int result = Integer.signum(sl1 - (sl2 = ((BundleStartLevel)b2.adapt(BundleStartLevel.class)).getStartLevel()));
                if (result == 0) {
                    int idResult = Long.signum(b1.getBundleId() - b2.getBundleId());
                    return idResult == 0 ? 0 : idResult;
                }
                return result;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.BundleInstallStatus$1", 1.class, (String)"featureManager", (String)"com.ibm.ws.kernel.feature.internal.resources.ProvisionerMessages");
            }
        };
    }
}

