/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ejs.cm.logger.TraceWriter;
import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.impl.DatabaseHelper;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import jakarta.resource.ResourceException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Collections;

public class InformixHelper
extends DatabaseHelper {
    private static final TraceComponent tc = com.ibm.websphere.ras.Tr.register(InformixHelper.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private transient com.ibm.ejs.ras.TraceComponent infxTc = Tr.register((String)"com.ibm.ws.informix.logwriter", (String)"WAS.database", null);

    InformixHelper(WSManagedConnectionFactoryImpl mcf) {
        super(mcf);
        this.dataStoreHelperClassName = "com.ibm.websphere.rsadapter.InformixDataStoreHelper";
        mcf.defaultIsolationLevel = 4;
        Collections.addAll(this.staleConCodes, -79735, -79716, -43207, -27002, -25580, -908, 43012);
        Collections.addAll(this.staleStmtCodes, -710);
    }

    @Override
    public void doStatementCleanup(PreparedStatement stmt) throws SQLException {
        if (this.dataStoreHelper != null) {
            this.doStatementCleanupLegacy(stmt);
            return;
        }
        stmt.setFetchDirection(1000);
        stmt.setMaxFieldSize(0);
        stmt.setMaxRows(0);
        Integer queryTimeout = this.mcf.dsConfig.get().queryTimeout;
        if (queryTimeout == null) {
            queryTimeout = this.defaultQueryTimeout;
        }
        stmt.setQueryTimeout(queryTimeout);
    }

    @Override
    public PrintWriter getPrintWriter() throws ResourceException {
        if (this.genPw == null) {
            this.genPw = new PrintWriter((Writer)new TraceWriter(this.infxTc), true);
        }
        com.ibm.websphere.ras.Tr.debug((TraceComponent)this.infxTc, (String)"returning", (Object[])new Object[]{this.genPw});
        return this.genPw;
    }

    @Override
    public com.ibm.ejs.ras.TraceComponent getTracer() {
        return this.infxTc;
    }

    @Override
    public long getUpdateCount(WSJdbcStatement stmt) throws SQLException {
        try {
            return super.getUpdateCount(stmt);
        }
        catch (SQLException x) {
            if (x.getErrorCode() == -79733) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    com.ibm.websphere.ras.Tr.debug((TraceComponent)tc, (String)"Returning stmt.getUpdateCount = -1 to work around Informix bug", (Object[])new Object[]{x.getMessage()});
                }
                return -1L;
            }
            throw x;
        }
    }

    @Override
    boolean isAuthException(SQLException x) {
        int ec = x.getErrorCode();
        return x instanceof SQLInvalidAuthorizationSpecException || x.getSQLState() != null && x.getSQLState().startsWith("28") || -951 == ec || -952 == ec || -956 == ec || -1782 == ec || -11018 == ec || -11033 == ec || -25590 == ec || -29007 == ec;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSManagedConnectionFactoryImpl mcf) {
        return TraceComponent.isAnyTracingEnabled() && this.infxTc.isDebugEnabled() && !mcf.loggingEnabled;
    }

    @Override
    public boolean shouldTraceBeEnabled(WSRdbManagedConnectionImpl mc) {
        return this.shouldTraceBeEnabled(mc.mcf);
    }

    @Override
    public boolean shouldTraceBeDisabled(WSRdbManagedConnectionImpl mc) {
        return TraceComponent.isAnyTracingEnabled() && !this.infxTc.isDebugEnabled() && mc.mcf.loggingEnabled;
    }
}

