/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDatabaseMetaData;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcStatement;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Wrapper;
import java.util.Calendar;
import java.util.Map;

public class WSJdbcResultSet
extends WSJdbcObject
implements ResultSet {
    private static final TraceComponent tc = Tr.register(WSJdbcResultSet.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    protected ResultSet rsetImpl;
    protected String sql;

    public WSJdbcResultSet(ResultSet rsImpl, WSJdbcObject parent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{AdapterUtil.toString(rsImpl), parent});
        }
        this.mcf = parent.mcf;
        this.rsetImpl = rsImpl;
        this.init(parent);
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public boolean absolute(int arg0) throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            return this.rsetImpl.absolute(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.absolute", (String)"93", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            this.rsetImpl.afterLast();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.afterLast", (String)"118", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            this.rsetImpl.beforeFirst();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.beforeFirst", (String)"144", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"cancelRowUpdates", (Object[])new Object[0]);
        }
        try {
            this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
            this.rsetImpl.cancelRowUpdates();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.cancelRowUpdates", (String)"183", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.rsetImpl.clearWarnings();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.clearWarnings", (String)"208", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected SQLException closeWrapper(boolean closeWrapperOnly) {
        if (this.parentWrapper.childWrapper == this) {
            this.parentWrapper.childWrapper = null;
        } else {
            this.parentWrapper.childWrappers.remove(this);
        }
        if (closeWrapperOnly) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"closeWrapper skipping close of ResultSet implementation object", (Object[])new Object[0]);
            }
        } else {
            try {
                this.rsetImpl.close();
            }
            catch (SQLException closeX) {
                FFDCFilter.processException((Throwable)closeX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.closeWrapper", (String)"246", (Object)this);
                this.rsetImpl = null;
                return WSJdbcUtil.mapException(this, closeX);
            }
        }
        if (this.parentWrapper != null && this.parentWrapper instanceof WSJdbcStatement && ((WSJdbcStatement)this.parentWrapper).closeOnCompletion) {
            WSJdbcStatement parentStmt = (WSJdbcStatement)this.parentWrapper;
            if (parentStmt.childWrapper == null && (parentStmt.childWrappers == null || parentStmt.childWrappers.isEmpty())) {
                try {
                    parentStmt.close();
                }
                catch (SQLException closeX) {
                    FFDCFilter.processException((Throwable)closeX, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.closeWrapper", (String)"281", (Object)this);
                    this.rsetImpl = null;
                    return WSJdbcUtil.mapException(this, closeX);
                }
            }
        }
        this.rsetImpl = null;
        return null;
    }

    @Override
    public void deleteRow() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"deleteRow", (Object[])new Object[0]);
        }
        try {
            this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
            this.rsetImpl.deleteRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.deleteRow", (String)"355", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int findColumn(String arg0) throws SQLException {
        try {
            return this.rsetImpl.findColumn(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.findColumn", (String)"384", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            return this.rsetImpl.first();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.first", (String)"411", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        try {
            Array ra = this.rsetImpl.getArray(arg0);
            if (ra != null && this.freeResourcesOnClose) {
                this.arrays.add(ra);
            }
            return ra;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getArray", (String)"438", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        try {
            Array ra = this.rsetImpl.getArray(arg0);
            if (ra != null && this.freeResourcesOnClose) {
                this.arrays.add(ra);
            }
            return ra;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getArray", (String)"465", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        try {
            InputStream stream = this.rsetImpl.getAsciiStream(arg0);
            if (stream != null && this.freeResourcesOnClose) {
                this.resources.add(stream);
            }
            return stream;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getAsciiStream", (String)"501", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        try {
            InputStream stream = this.rsetImpl.getAsciiStream(arg0);
            if (stream != null && this.freeResourcesOnClose) {
                this.resources.add(stream);
            }
            return stream;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getAsciiStream", (String)"537", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"566", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"596", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"625", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        try {
            return this.rsetImpl.getBigDecimal(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBigDecimal", (String)"656", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        try {
            InputStream stream = this.rsetImpl.getBinaryStream(arg0);
            if (stream != null && this.freeResourcesOnClose) {
                this.resources.add(stream);
            }
            return stream;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBinaryStream", (String)"691", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        try {
            InputStream stream = this.rsetImpl.getBinaryStream(arg0);
            if (stream != null && this.freeResourcesOnClose) {
                this.resources.add(stream);
            }
            return stream;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBinaryStream", (String)"727", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        try {
            Blob blob = this.rsetImpl.getBlob(arg0);
            if (blob != null && this.freeResourcesOnClose) {
                this.blobs.add(blob);
            }
            return blob;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBlob", (String)"754", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getBoolean(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBoolean", (String)"784", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getBoolean(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBoolean", (String)"813", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public byte getByte(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getByte(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getByte", (String)"842", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public byte getByte(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getByte(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getByte", (String)"871", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public byte[] getBytes(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getBytes(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBytes", (String)"901", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public byte[] getBytes(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getBytes(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBytes", (String)"931", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        try {
            Blob blob = this.rsetImpl.getBlob(arg0);
            if (blob != null && this.freeResourcesOnClose) {
                this.blobs.add(blob);
            }
            return blob;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getBlob", (String)"958", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        try {
            Reader reader = this.rsetImpl.getCharacterStream(arg0);
            if (reader != null && this.freeResourcesOnClose) {
                this.resources.add(reader);
            }
            return reader;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCharacterStream", (String)"983", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        try {
            Reader reader = this.rsetImpl.getCharacterStream(arg0);
            if (reader != null && this.freeResourcesOnClose) {
                this.resources.add(reader);
            }
            return reader;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCharacterStream", (String)"1010", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        try {
            Clob clob = this.rsetImpl.getClob(arg0);
            if (clob != null && this.freeResourcesOnClose) {
                this.clobs.add(clob);
            }
            return clob;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getClob", (String)"1037", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        try {
            Clob clob = this.rsetImpl.getClob(arg0);
            if (clob != null && this.freeResourcesOnClose) {
                this.clobs.add(clob);
            }
            return clob;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getClob", (String)"1064", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            return this.rsetImpl.getConcurrency();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getConcurrency", (String)"1092", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected final WSJdbcObject getConnectionWrapper() {
        return this.parentWrapper.parentWrapper;
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            return this.rsetImpl.getCursorName();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getCursorName", (String)"1129", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Date getDate(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getDate(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1158", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        try {
            return this.rsetImpl.getDate(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1190", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Date getDate(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getDate(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1219", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        try {
            return this.rsetImpl.getDate(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDate", (String)"1251", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public double getDouble(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getDouble(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDouble", (String)"1280", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public double getDouble(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getDouble(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getDouble", (String)"1309", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.rsetImpl.getFetchDirection();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFetchDirection", (String)"1336", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.rsetImpl.getFetchSize();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFetchSize", (String)"1363", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public float getFloat(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getFloat(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFloat", (String)"1392", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public float getFloat(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getFloat(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getFloat", (String)"1422", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            return this.rsetImpl.getHoldability();
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getHoldability"), (String)"1375", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getHoldability", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getHoldability"), (String)"1394", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getHoldability"), (String)"1401", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getHoldability", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public int getInt(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getInt(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getInt", (String)"1451", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getInt(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getInt(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getInt", (String)"1480", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected final Wrapper getJDBCImplObject() {
        return this.rsetImpl;
    }

    @Override
    public long getLong(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getLong(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getLong", (String)"1509", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public long getLong(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getLong(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getLong", (String)"1538", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object[])new Object[0]);
        }
        ResultSetMetaData rsetMData = null;
        try {
            rsetMData = this.rsetImpl.getMetaData();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getMetaData", (String)"1579", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)"Exception");
            }
            throw this.runtimeXIfNotClosed(nullX);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)rsetMData);
        }
        return rsetMData;
    }

    @Override
    public Reader getNCharacterStream(int i) throws SQLException {
        try {
            return this.rsetImpl.getNCharacterStream(i);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getNCharacterStream"), (String)"1563", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getNCharacterStream"), (String)"1598", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getNCharacterStream"), (String)"1605", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        try {
            return this.rsetImpl.getNCharacterStream(columnLabel);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getNCharacterStream"), (String)"1592", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getNCharacterStream"), (String)"1643", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getNCharacterStream"), (String)"1650", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try {
            NClob clob = this.rsetImpl.getNClob(columnIndex);
            if (clob != null && this.freeResourcesOnClose) {
                this.clobs.add(clob);
            }
            return clob;
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getNClob"), (String)"1621", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getNClob"), (String)"1637", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getNClob"), (String)"1644", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        try {
            NClob clob = this.rsetImpl.getNClob(columnLabel);
            if (clob != null && this.freeResourcesOnClose) {
                this.clobs.add(clob);
            }
            return clob;
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getNClob"), (String)"1664", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getNClob"), (String)"1680", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getNClob"), (String)"1687", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public String getNString(int i) throws SQLException {
        try {
            return this.rsetImpl.getNString(i);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getNString"), (String)"1621", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getNString", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getNString"), (String)"1774", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNString", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getNString"), (String)"1781", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNString", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        try {
            return this.rsetImpl.getNString(columnLabel);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getNString"), (String)"1650", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getNString", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getNString"), (String)"1819", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNString", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getNString"), (String)"1826", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getNString", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public Object getObject(int arg0) throws SQLException {
        try {
            Object result = this.rsetImpl.getObject(arg0);
            this.addFreedResources(result);
            return result;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1617", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        try {
            Object result = this.rsetImpl.getObject(arg0, arg1);
            this.addFreedResources(result);
            return result;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1646", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Object getObject(String arg0) throws SQLException {
        try {
            Object result = this.rsetImpl.getObject(arg0);
            this.addFreedResources(result);
            return result;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1684", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        try {
            Object result = this.rsetImpl.getObject(arg0, arg1);
            this.addFreedResources(result);
            return result;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getObject", (String)"1713", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getRef(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRef", (String)"1740", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getRef(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRef", (String)"1767", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public int getRow() throws SQLException {
        try {
            return this.rsetImpl.getRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getRow", (String)"1808", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try {
            return this.rsetImpl.getRowId(columnIndex);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getRowId"), (String)"1973", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getRowId", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getRowId"), (String)"1989", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getRowId", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getRowId"), (String)"1996", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getRowId", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        try {
            return this.rsetImpl.getRowId(columnLabel);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getRowId"), (String)"2016", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getRowId", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getRowId"), (String)"2032", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getRowId", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getRowId"), (String)"2039", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getRowId", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public short getShort(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getShort(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getShort", (String)"1837", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public short getShort(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getShort(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getShort", (String)"1866", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try {
            SQLXML xml = this.rsetImpl.getSQLXML(columnIndex);
            if (xml != null && this.freeResourcesOnClose) {
                this.xmls.add(xml);
            }
            return xml;
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getSQLXML"), (String)"2115", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getSQLXML", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getSQLXML"), (String)"2131", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getSQLXML", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getSQLXML"), (String)"2138", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getSQLXML", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        try {
            SQLXML xml = this.rsetImpl.getSQLXML(columnLabel);
            if (xml != null && this.freeResourcesOnClose) {
                this.xmls.add(xml);
            }
            return xml;
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".getSQLXML"), (String)"2158", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.getSQLXML", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".getSQLXML"), (String)"2174", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getSQLXML", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".getSQLXML"), (String)"2181", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"getSQLXML", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED || this.parentWrapper == null) {
            throw this.createClosedException("ResultSet");
        }
        if (this.parentWrapper instanceof WSJdbcDatabaseMetaData) {
            return null;
        }
        return (Statement)((Object)this.parentWrapper);
    }

    @Override
    public String getString(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getString(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getString", (String)"1926", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public String getString(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getString(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getString", (String)"1955", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Time getTime(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getTime(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"1984", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        try {
            return this.rsetImpl.getTime(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"2016", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Time getTime(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getTime(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"2045", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        try {
            return this.rsetImpl.getTime(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTime", (String)"2077", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2106", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2138", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2167", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        try {
            return this.rsetImpl.getTimestamp(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getTimestamp", (String)"2199", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected final TraceComponent getTracer() {
        return tc;
    }

    @Override
    public int getType() throws SQLException {
        try {
            return this.rsetImpl.getType();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getType", (String)"2235", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        try {
            InputStream stream = this.rsetImpl.getUnicodeStream(arg0);
            if (stream != null && this.freeResourcesOnClose) {
                this.resources.add(stream);
            }
            return stream;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getUnicodeStream", (String)"2273", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        try {
            InputStream stream = this.rsetImpl.getUnicodeStream(arg0);
            if (stream != null && this.freeResourcesOnClose) {
                this.resources.add(stream);
            }
            return stream;
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getUnicodeStream", (String)"2312", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.rsetImpl.getWarnings();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getWarnings", (String)"2345", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void insertRow() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"insertRow", (Object[])new Object[0]);
        }
        try {
            this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
            this.rsetImpl.insertRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.insertRow", (String)"2398", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected void introspectWrapperSpecificInfo(FFDCLogger info) {
        info.append("Underlying ResultSet: " + AdapterUtil.toString(this.rsetImpl), this.rsetImpl);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            return this.rsetImpl.isAfterLast();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isAfterLast", (String)"2425", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            return this.rsetImpl.isBeforeFirst();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isBeforeFirst", (String)"2452", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            return this.rsetImpl.isFirst();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isFirst", (String)"2479", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        try {
            return this.rsetImpl.isLast();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.isLast", (String)"2508", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean last() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            return this.rsetImpl.last();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.last", (String)"2535", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            this.rsetImpl.moveToCurrentRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.moveToCurrentRow", (String)"2561", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            this.rsetImpl.moveToInsertRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.moveToInsertRow", (String)"2592", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            boolean moreRows = this.rsetImpl.next();
            return moreRows;
        }
        catch (SQLException ex) {
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            return this.rsetImpl.previous();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.previous", (String)"2654", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"refreshRow", (Object[])new Object[0]);
        }
        try {
            this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
            this.rsetImpl.refreshRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.refreshRow", (String)"2714", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        try {
            if (((DSConfig)this.dsConfig.get()).beginTranForResultSetScrollingAPIs) {
                this.getConnectionWrapper().beginTransactionIfNecessary();
            }
            return this.rsetImpl.relative(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.relative", (String)"2748", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            return this.rsetImpl.rowDeleted();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowDeleted", (String)"2777", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            return this.rsetImpl.rowInserted();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowInserted", (String)"2805", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            return this.rsetImpl.rowUpdated();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.rowUpdated", (String)"2833", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    protected final RuntimeException runtimeXIfNotClosed(RuntimeException runtimeX) throws SQLException {
        if (this.state == WSJdbcWrapper.State.CLOSED) {
            throw this.createClosedException("ResultSet");
        }
        return runtimeX;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setFetchDirection", (Object[])new Object[]{AdapterUtil.getFetchDirectionString(direction)});
        }
        try {
            this.rsetImpl.setFetchDirection(direction);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.setFetchDirection", (String)"2860", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"setFetchSize", (Object[])new Object[]{rows});
        }
        try {
            this.rsetImpl.setFetchSize(rows);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.setFetchSize", (String)"2891", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(columnIndex, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"2922", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateAsciiStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3280", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3287", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateAsciiStream", (String)"2922", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateAsciiStream(int i, InputStream x, long length) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"2981", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateAsciiStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3355", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3362", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3010", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateAsciiStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3400", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3407", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateAsciiStream", (String)"2953", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.rsetImpl.updateAsciiStream(columnLabel, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3070", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateAsciiStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3476", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateAsciiStream"), (String)"3483", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateAsciiStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        try {
            this.rsetImpl.updateBigDecimal(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBigDecimal", (String)"2983", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        try {
            this.rsetImpl.updateBigDecimal(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBigDecimal", (String)"3013", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(columnIndex, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3157", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBinaryStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3579", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3586", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBinaryStream", (String)"3044", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBinaryStream(int i, InputStream x, long length) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3216", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBinaryStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3654", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3661", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3245", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBinaryStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3699", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3706", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBinaryStream", (String)"3075", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.rsetImpl.updateBinaryStream(columnLabel, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3304", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBinaryStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3774", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBinaryStream"), (String)"3781", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBinaryStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBlob(int i, InputStream x) throws SQLException {
        try {
            this.rsetImpl.updateBlob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3333", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3819", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBlob"), (String)"3826", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBlob(int i, InputStream x, long length) throws SQLException {
        try {
            this.rsetImpl.updateBlob(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3362", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3864", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBlob"), (String)"3871", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x) throws SQLException {
        try {
            this.rsetImpl.updateBlob(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3391", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3909", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBlob"), (String)"3916", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBlob(String columnLabel, InputStream x, long length) throws SQLException {
        try {
            this.rsetImpl.updateBlob(columnLabel, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3420", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateBlob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateBlob"), (String)"3954", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateBlob"), (String)"3961", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateBlob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        try {
            this.rsetImpl.updateBoolean(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBoolean", (String)"3105", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        try {
            this.rsetImpl.updateBoolean(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBoolean", (String)"3135", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        try {
            this.rsetImpl.updateByte(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateByte", (String)"3165", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        try {
            this.rsetImpl.updateByte(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateByte", (String)"3195", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        try {
            this.rsetImpl.updateBytes(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBytes", (String)"3225", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        try {
            this.rsetImpl.updateBytes(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBytes", (String)"3255", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(columnIndex, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"3623", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4173", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4180", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateCharacterStream", (String)"3286", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateCharacterStream(int i, Reader x, long length) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"3682", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4248", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4255", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"3711", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4293", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4300", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateCharacterStream", (String)"3317", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this.rsetImpl.updateCharacterStream(columnLabel, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"3770", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4368", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateCharacterStream"), (String)"4375", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateClob(int i, Reader x) throws SQLException {
        try {
            this.rsetImpl.updateClob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateClob"), (String)"3799", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateClob"), (String)"4413", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateClob"), (String)"4420", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateClob(int i, Reader x, long length) throws SQLException {
        try {
            this.rsetImpl.updateClob(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateClob"), (String)"3828", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateClob"), (String)"4458", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateClob"), (String)"4465", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x) throws SQLException {
        try {
            this.rsetImpl.updateClob(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateClob"), (String)"3857", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateClob"), (String)"4503", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateClob"), (String)"4510", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this.rsetImpl.updateClob(columnLabel, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateClob"), (String)"3886", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateClob"), (String)"4548", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateClob"), (String)"4555", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        try {
            this.rsetImpl.updateDate(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDate", (String)"3347", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        try {
            this.rsetImpl.updateDate(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDate", (String)"3377", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        try {
            this.rsetImpl.updateDouble(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDouble", (String)"3407", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        try {
            this.rsetImpl.updateDouble(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateDouble", (String)"3437", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        try {
            this.rsetImpl.updateFloat(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateFloat", (String)"3467", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        try {
            this.rsetImpl.updateFloat(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateFloat", (String)"3497", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        try {
            this.rsetImpl.updateInt(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateInt", (String)"3527", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        try {
            this.rsetImpl.updateInt(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateInt", (String)"3557", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        try {
            this.rsetImpl.updateLong(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateLong", (String)"3587", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        try {
            this.rsetImpl.updateLong(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateLong", (String)"3617", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader) throws SQLException {
        try {
            this.rsetImpl.updateNCharacterStream(i, reader);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4205", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4883", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4890", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNCharacterStream(int i, Reader reader, long length) throws SQLException {
        try {
            this.rsetImpl.updateNCharacterStream(i, reader, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4234", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4928", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4935", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        try {
            this.rsetImpl.updateNCharacterStream(columnLabel, reader);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4264", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4974", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4981", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        try {
            this.rsetImpl.updateNCharacterStream(columnLabel, reader, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"4294", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNCharacterStream", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"5020", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNCharacterStream"), (String)"5027", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNCharacterStream", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        try {
            this.rsetImpl.updateNClob(columnIndex, nClob);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4581", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4597", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNClob"), (String)"4604", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNClob(int i, Reader x) throws SQLException {
        try {
            this.rsetImpl.updateNClob(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4323", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNClob"), (String)"5108", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNClob"), (String)"5115", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNClob(int i, Reader x, long length) throws SQLException {
        try {
            this.rsetImpl.updateNClob(i, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4352", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNClob"), (String)"5153", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNClob"), (String)"5160", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        try {
            this.rsetImpl.updateNClob(columnLabel, nClob);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4682", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4698", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNClob"), (String)"4705", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader x) throws SQLException {
        try {
            this.rsetImpl.updateNClob(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4381", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNClob"), (String)"5241", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNClob"), (String)"5248", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNClob(String columnLabel, Reader x, long length) throws SQLException {
        try {
            this.rsetImpl.updateNClob(columnLabel, x, length);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNClob"), (String)"4410", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNClob", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNClob"), (String)"5286", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNClob"), (String)"5293", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNClob", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNString(int i, String x) throws SQLException {
        try {
            this.rsetImpl.updateNString(i, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNString"), (String)"4439", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNString", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNString"), (String)"5331", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNString", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNString"), (String)"5338", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNString", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNString(String columnLabel, String x) throws SQLException {
        try {
            this.rsetImpl.updateNString(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateNString"), (String)"4468", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateNString", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateNString"), (String)"5376", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNString", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateNString"), (String)"5383", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateNString", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        try {
            this.rsetImpl.updateNull(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateNull", (String)"3646", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateNull(String arg0) throws SQLException {
        try {
            this.rsetImpl.updateNull(arg0);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateNull", (String)"3675", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        try {
            this.rsetImpl.updateObject(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3705", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateObject(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3737", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        try {
            this.rsetImpl.updateObject(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3767", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        try {
            this.rsetImpl.updateObject(arg0, arg1, arg2);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateObject", (String)"3799", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"updateRow", (Object[])new Object[0]);
        }
        try {
            this.parentWrapper.parentWrapper.beginTransactionIfNecessary();
            this.rsetImpl.updateRow();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRow", (String)"3851", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        try {
            this.rsetImpl.updateRowId(columnIndex, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateRowId"), (String)"5064", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateRowId", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateRowId"), (String)"5080", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateRowId", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateRowId"), (String)"5087", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateRowId", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        try {
            this.rsetImpl.updateRowId(columnLabel, x);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateRowId"), (String)"5107", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateRowId", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateRowId"), (String)"5123", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateRowId", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateRowId"), (String)"5130", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateRowId", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        try {
            this.rsetImpl.updateShort(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateShort", (String)"3881", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        try {
            this.rsetImpl.updateShort(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateShort", (String)"3911", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        try {
            this.rsetImpl.updateString(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateString", (String)"3941", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        try {
            this.rsetImpl.updateSQLXML(columnIndex, xmlObject);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateSQLXML"), (String)"5237", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateSQLXML", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateSQLXML"), (String)"5253", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateSQLXML", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateSQLXML"), (String)"5260", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateSQLXML", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        try {
            this.rsetImpl.updateSQLXML(columnLabel, xmlObject);
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".updateSQLXML"), (String)"5280", (Object)this);
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (AbstractMethodError methError) {
            throw AdapterUtil.notSupportedX("ResultSet.updateSQLXML", methError);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".updateSQLXML"), (String)"5296", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateSQLXML", (Object[])new Object[]{runX});
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".updateSQLXML"), (String)"5303", (Object)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"updateSQLXML", (Object[])new Object[]{err});
            }
            throw err;
        }
    }

    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        try {
            this.rsetImpl.updateString(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateString", (String)"3971", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        try {
            this.rsetImpl.updateTime(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTime", (String)"4001", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        try {
            this.rsetImpl.updateTime(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTime", (String)"4031", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        try {
            this.rsetImpl.updateTimestamp(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTimestamp", (String)"4061", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        try {
            this.rsetImpl.updateTimestamp(arg0, arg1);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateTimestamp", (String)"4091", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            return this.rsetImpl.wasNull();
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.wasNull", (String)"4119", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try {
            return this.rsetImpl.getURL(columnIndex);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getURL", (String)"3935", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        try {
            return this.rsetImpl.getURL(columnName);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.getURL", (String)"3964", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateArray(int i, Array array) throws SQLException {
        try {
            this.rsetImpl.updateArray(i, array);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateArray", (String)"3993", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateArray(String columnName, Array array) throws SQLException {
        try {
            this.rsetImpl.updateArray(columnName, array);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateArray", (String)"4009", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob b) throws SQLException {
        try {
            this.rsetImpl.updateBlob(columnIndex, b);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBlob", (String)"4038", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateBlob(String columnName, Blob b) throws SQLException {
        try {
            this.rsetImpl.updateBlob(columnName, b);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateBlob", (String)"4066", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateClob(int i, Clob c) throws SQLException {
        try {
            this.rsetImpl.updateClob(i, c);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateClob", (String)"4094", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateClob(String columnName, Clob c) throws SQLException {
        try {
            this.rsetImpl.updateClob(columnName, c);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateClob", (String)"4123", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref r) throws SQLException {
        try {
            this.rsetImpl.updateRef(columnIndex, r);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRef", (String)"4152", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    @Override
    public void updateRef(String columnName, Ref r) throws SQLException {
        try {
            this.rsetImpl.updateRef(columnName, r);
        }
        catch (SQLException ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.rsadapter.jdbc.WSJdbcResultSet.updateRef", (String)"4180", (Object)this);
            throw WSJdbcUtil.mapException(this, ex);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
    }

    protected void addFreedResources(Object result) {
        if (this.freeResourcesOnClose) {
            if (result instanceof Closeable) {
                this.resources.add((Closeable)result);
            } else if (result instanceof Array) {
                this.arrays.add((Array)result);
            } else if (result instanceof Blob) {
                this.blobs.add((Blob)result);
            } else if (result instanceof Clob) {
                this.clobs.add((Clob)result);
            } else if (result instanceof SQLXML) {
                this.xmls.add((SQLXML)result);
            }
        }
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

