/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.SecureAction;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcProxyMethod;
import com.ibm.ws.rsadapter.jdbc.WSJdbcTracer;
import com.ibm.ws.rsadapter.jdbc.WSJdbcUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLRecoverableException;
import java.sql.Wrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.CommonDataSource;

public abstract class WSJdbcWrapper
implements InvocationHandler,
Wrapper {
    static final SecureAction priv = (SecureAction)AccessController.doPrivileged(SecureAction.get());
    public transient AtomicReference<DSConfig> dsConfig;
    final Map<Class<?>, Object> ifcToDynamicWrapper = new HashMap();
    final Map<Object, Object> dynamicWrapperToImpl = new HashMap<Object, Object>();
    protected WSManagedConnectionFactoryImpl mcf;

    void activate() throws SQLException {
    }

    protected final SQLException createClosedException(String ifc) {
        String message = AdapterUtil.getNLSMessage("OBJECT_CLOSED", ifc);
        if (this.dsConfig.get().heritageReplaceExceptions) {
            try {
                return AccessController.doPrivileged(() -> {
                    Class<?> ObjectClosedException = this.mcf.getHelper().dataStoreHelper.getClass().getClassLoader().loadClass("com.ibm.websphere.ce.cm.ObjectClosedException");
                    return (SQLException)ObjectClosedException.getConstructor(String.class).newInstance(message);
                });
            }
            catch (PrivilegedActionException x) {
                FFDCFilter.processException((Throwable)x.getCause(), (String)WSJdbcWrapper.class.getName(), (String)"122", (Object)this);
            }
        }
        return new SQLRecoverableException(message, "08003", 0);
    }

    protected abstract Object getJDBCImplObject() throws SQLException;

    protected <T> T getJDBCImplObject(Class<T> interfaceClass) throws SQLException {
        Object impl = WSJdbcTracer.getImpl(this.getJDBCImplObject());
        return (T)(interfaceClass.isInstance(impl) ? impl : (this.mcf.jdbcDriverSpecVersion >= 40 && ((Wrapper)impl).isWrapperFor(interfaceClass) ? ((Wrapper)impl).unwrap(interfaceClass) : null));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        WSJdbcProxyMethod methImpl = WSJdbcProxyMethod.getSpecialCase(method);
        if (methImpl != null) {
            return methImpl.invoke(this, proxy, method, args);
        }
        TraceComponent tc = this.getTracer();
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)WSJdbcWrapper.toString(proxy, method), (Object[])args);
        }
        Object result = null;
        boolean isOperationComplete = false;
        Set<Method> vendorMethods = this.mcf.vendorMethods;
        if (!vendorMethods.contains(method)) {
            try {
                Method wrappedMethod = this.getClass().getMethod(method.getName(), method.getParameterTypes());
                result = wrappedMethod.invoke((Object)this, args);
                isOperationComplete = true;
            }
            catch (NoSuchMethodException methX) {
                vendorMethods.add(method);
            }
            catch (SecurityException secureX) {
                vendorMethods.add(method);
            }
            catch (IllegalAccessException accessX) {
                vendorMethods.add(method);
            }
            catch (InvocationTargetException invokeX) {
                Throwable x = invokeX.getTargetException();
                FFDCFilter.processException((Throwable)x, (String)(this.getClass().getName() + ".invoke"), (String)"134", (Object)this);
                Throwable throwable = x = x instanceof SQLException ? WSJdbcUtil.mapException(this, (SQLException)x) : x;
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)WSJdbcWrapper.toString(proxy, method), (Object)x);
                }
                throw x;
            }
        }
        if (!isOperationComplete) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"Operation not found on the main wrapper.", (Object[])new Object[0]);
            }
            if (!WSJdbcProxyMethod.isSafe(method) || !WSJdbcProxyMethod.isSafeReturnType(method.getReturnType()) && !WSJdbcProxyMethod.overrideUnsafeReturnType(method)) {
                SQLFeatureNotSupportedException unsafeX = new SQLFeatureNotSupportedException(AdapterUtil.getNLSMessage("OPERATION_NOT_PERMITTED", method.getName()));
                Exception x = null;
                for (Class<?> xType : method.getExceptionTypes()) {
                    if (!xType.equals(SQLException.class) && !xType.equals(SQLFeatureNotSupportedException.class)) continue;
                    x = unsafeX;
                    break;
                }
                if (x == null) {
                    x = new RuntimeException(unsafeX);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)WSJdbcWrapper.toString(proxy, method), (Object)unsafeX);
                }
                throw x;
            }
            this.activate();
            Object implObject = this.dynamicWrapperToImpl.get(proxy);
            if (implObject == null) {
                String message = AdapterUtil.getNLSMessage("OBJECT_CLOSED", "Wrapper");
                Exception closedX = new SQLRecoverableException(message, "08003", 0);
                boolean raisesSQLX = false;
                for (Class<?> xClass : method.getExceptionTypes()) {
                    raisesSQLX |= xClass.equals(SQLException.class);
                }
                if (!raisesSQLX) {
                    closedX = new RuntimeException(closedX);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)WSJdbcWrapper.toString(proxy, method), (Object)closedX);
                }
                throw closedX;
            }
            WSJdbcConnection connWrapper = null;
            if (this instanceof WSJdbcObject && (connWrapper = (WSJdbcConnection)((WSJdbcObject)this).getConnectionWrapper()) != null && (this.dsConfig.get().beginTranForVendorAPIs || WSJdbcProxyMethod.alwaysBeginTranMethods.contains(method.getName()))) {
                connWrapper.beginTransactionIfNecessary();
            }
            try {
                result = this.invokeOperation(implObject, method, args);
                if (connWrapper != null && WSJdbcProxyMethod.isClientInfoSetter(method.getName())) {
                    connWrapper.managedConn.clientInfoExplicitlySet = true;
                }
            }
            catch (InvocationTargetException invokeX) {
                Throwable x = invokeX.getTargetException();
                FFDCFilter.processException((Throwable)x, (String)(this.getClass().getName() + ".invoke"), (String)"171", (Object)this);
                Throwable throwable = x = x instanceof SQLException ? WSJdbcUtil.mapException(this, (SQLException)x) : x;
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)WSJdbcWrapper.toString(proxy, method), (Object)x);
                }
                throw x;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)WSJdbcWrapper.toString(proxy, method), result);
        }
        return result;
    }

    Object invokeOperation(Object implObject, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, SQLException {
        TraceComponent tc = this.getTracer();
        if (tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("invoking " + AdapterUtil.toString(implObject) + "." + method.getName()), (Object[])new Object[0]);
        }
        return method.invoke(implObject, args);
    }

    protected abstract TraceComponent getTracer();

    protected abstract RuntimeException runtimeXIfNotClosed(RuntimeException var1) throws SQLException;

    @Override
    public boolean isWrapperFor(Class<?> interfaceClass) throws SQLException {
        boolean isWrapper;
        TraceComponent tc = this.getTracer();
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isWrapperFor", (Object[])new Object[]{interfaceClass});
        }
        try {
            this.activate();
            isWrapper = interfaceClass.isInterface() && (interfaceClass.isInstance(this) || (this.mcf.jdbcDriverSpecVersion >= 40 && !(this instanceof CommonDataSource) ? ((Wrapper)WSJdbcTracer.getImpl(this.getJDBCImplObject())).isWrapperFor(interfaceClass) : this.getJDBCImplObject(interfaceClass) != null));
        }
        catch (SQLException sqlX) {
            FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".isWrapperFor"), (String)"296", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isWrapperFor", (Object)sqlX);
            }
            throw WSJdbcUtil.mapException(this, sqlX);
        }
        catch (NullPointerException nullX) {
            throw this.runtimeXIfNotClosed(nullX);
        }
        catch (RuntimeException runX) {
            FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".isWrapperFor"), (String)"307", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isWrapperFor", (Object)runX);
            }
            throw runX;
        }
        catch (Error err) {
            FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".isWrapperFor"), (String)"314", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"isWrapperFor", (Object)err);
            }
            throw err;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isWrapperFor", (Object)(isWrapper ? Boolean.TRUE : Boolean.FALSE));
        }
        return isWrapper;
    }

    static String toString(Object proxy, Method meth) {
        return "Proxy@" + Integer.toHexString(System.identityHashCode(proxy)) + '.' + meth.getName();
    }

    @Override
    public <T> T unwrap(final Class<T> interfaceClass) throws SQLException {
        Object result;
        TraceComponent tc = this.getTracer();
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"unwrap", (Object[])new Object[]{interfaceClass});
        }
        this.activate();
        if (interfaceClass.isInstance(this)) {
            result = this;
        } else if (this.ifcToDynamicWrapper.containsKey(interfaceClass)) {
            result = this.ifcToDynamicWrapper.get(interfaceClass);
        } else {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"No existing wrappers found. Need to create a new wrapper.", (Object[])new Object[0]);
                }
                if (!interfaceClass.isInterface()) {
                    throw new SQLException(AdapterUtil.getNLSMessage("NOT_AN_INTERFACE", interfaceClass.getName()));
                }
                T implObject = this.getJDBCImplObject(interfaceClass);
                if (implObject == null) {
                    throw new SQLException(AdapterUtil.getNLSMessage("NO_WRAPPED_OBJECT", this, interfaceClass.getName()));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"Creating a wrapper for:", (Object[])new Object[]{AdapterUtil.toString(implObject)});
                }
                result = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)WSJdbcWrapper.this);
                    }
                });
                this.ifcToDynamicWrapper.put(interfaceClass, result);
                this.dynamicWrapperToImpl.put(result, implObject);
            }
            catch (SQLException sqlX) {
                FFDCFilter.processException((Throwable)sqlX, (String)(this.getClass().getName() + ".unwrap"), (String)"441", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"unwrap", (Object)sqlX);
                }
                throw WSJdbcUtil.mapException(this, sqlX);
            }
            catch (NullPointerException nullX) {
                throw this.runtimeXIfNotClosed(nullX);
            }
            catch (RuntimeException runX) {
                FFDCFilter.processException((Throwable)runX, (String)(this.getClass().getName() + ".unwrap"), (String)"451", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"unwrap", (Object)runX);
                }
                throw runX;
            }
            catch (Error err) {
                FFDCFilter.processException((Throwable)err, (String)(this.getClass().getName() + ".unwrap"), (String)"458", (Object)this);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"unwrap", (Object)err);
                }
                throw err;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"unwrap", (Object)result);
        }
        return (T)result;
    }

    public static enum State {
        ACTIVE,
        INACTIVE,
        CLOSED;

    }
}

