/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.FragmentComposer;
import jakarta.servlet.ServletOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CacheProxyOutputStream
extends ServletOutputStream {
    private static TraceComponent tc = Tr.register(CacheProxyOutputStream.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private OutputStream outputStream = null;
    private boolean closed = false;
    private final ByteArrayOutputStream cachingStream = new ByteArrayOutputStream();
    private boolean caching = false;
    boolean flushrequired = false;
    boolean outputStreamFlushed = false;
    boolean delayWrite = false;
    boolean postDelayCachingValue = false;

    public CacheProxyOutputStream(FragmentComposer fc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CacheProxyOutputStream(FragmentComposer fc)", (Object[])new Object[0]);
        }
    }

    public CacheProxyOutputStream(OutputStream outputStream, FragmentComposer fc) {
        this.outputStream = outputStream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CacheProxyOutputStream(OutputStream outputStream, FragmentComposer fc)" + outputStream), (Object[])new Object[0]);
        }
    }

    public CacheProxyOutputStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CacheProxyOutputStream()", (Object[])new Object[0]);
        }
    }

    public CacheProxyOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CacheProxyOutputStream(OutputStream outputStream)" + outputStream), (Object[])new Object[0]);
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream outputStream) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setOutputStream this=" + (Object)((Object)this) + " " + outputStream), (Object[])new Object[0]);
        }
        this.outputStream = outputStream;
        this.closed = false;
        this.flushrequired = false;
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("reset this=" + (Object)((Object)this)), (Object[])new Object[0]);
        }
        this.cachingStream.reset();
        this.caching = false;
        this.outputStream = null;
        this.closed = false;
        this.flushrequired = false;
        this.outputStreamFlushed = false;
        this.delayWrite = false;
        this.postDelayCachingValue = false;
    }

    public void resetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("resetBuffer this=" + (Object)((Object)this)), (Object[])new Object[0]);
        }
        this.cachingStream.reset();
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCaching: this=" + (Object)((Object)this) + " caching=" + caching), (Object[])new Object[0]);
        }
    }

    public boolean isCaching() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isCaching: this=" + (Object)((Object)this) + " caching=" + this.caching), (Object[])new Object[0]);
        }
        return this.caching;
    }

    public void setDelayWrite(boolean flag, boolean pdcv) {
        this.delayWrite = flag;
        this.postDelayCachingValue = pdcv;
    }

    public byte[] getCachedData() {
        return this.cachingStream.toByteArray();
    }

    public void write(int character) throws IOException {
        this.flushrequired = true;
        if (this.caching) {
            this.cachingStream.write(character);
        }
        if (TraceComponent.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" write(int): " + (Object)((Object)this) + " outputStream=" + this.outputStream + " " + String.valueOf(character)), (Object[])new Object[0]);
        }
        this.outputStream.write(character);
    }

    public void write(byte[] array) throws IOException {
        this.flushrequired = true;
        if (this.caching) {
            this.cachingStream.write(array);
        }
        if (TraceComponent.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" write(byte[]):  length=" + array.length + " " + (Object)((Object)this) + " outputStream=" + this.outputStream + " " + new String(array)), (Object[])new Object[0]);
        }
        this.outputStream.write(array);
    }

    public void write(byte[] array, int offset, int length) throws IOException {
        this.flushrequired = true;
        if (this.caching) {
            this.cachingStream.write(array, offset, length);
        }
        if (TraceComponent.isAnyTracingEnabled() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" write(byte[],int,int):  length=" + length + " " + (Object)((Object)this) + " outputStream=" + this.outputStream + " " + new String(array, offset, length)), (Object[])new Object[0]);
        }
        this.outputStream.write(array, offset, length);
    }

    public void flush() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("flush this=" + (Object)((Object)this) + " caching=" + this.caching + " flushrequired=" + this.flushrequired), (Object[])new Object[0]);
        }
        this.outputStreamFlushed = true;
        if (this.flushrequired) {
            if (this.outputStream != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("flush outputstream: " + this.outputStream + " content: " + this.outputStream.toString()), (Object[])new Object[0]);
                }
                this.outputStream.flush();
            }
            this.flushrequired = false;
            if (this.delayWrite && !this.caching) {
                this.caching = this.postDelayCachingValue;
                this.delayWrite = false;
            }
        }
    }

    public void close() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close() this= " + (Object)((Object)this) + " outputStream=" + this.outputStream + " "), (Object[])new Object[0]);
        }
        this.closed = true;
        this.outputStream.close();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void initListener(FragmentComposer fc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initListener with " + fc), (Object[])new Object[0]);
        }
    }
}

