/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.FragmentComposer;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class CacheProxyWriter
extends PrintWriter {
    private static TraceComponent tc = Tr.register(CacheProxyWriter.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    boolean trouble = false;
    Object lock = new Object();
    CharArrayWriter cachingWriter = new CharArrayWriter();
    boolean caching = false;
    boolean flushrequired = false;
    boolean writerFlushed = false;
    boolean delayWrite = false;
    boolean postDelayCachingValue = false;
    public static final String lineSeparator = CacheProxyWriter.getLineSeparator();

    public CacheProxyWriter() {
        this(new NullWriter());
    }

    public CacheProxyWriter(Writer writer) {
        super(writer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("CTOR " + this.toString()), (Object[])new Object[0]);
        }
    }

    public CacheProxyWriter(FragmentComposer fc) {
        this((Writer)new NullWriter(), fc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CacheProxyWriter()", (Object[])new Object[0]);
        }
    }

    public CacheProxyWriter(Writer writer, FragmentComposer fc) {
        super(writer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)" CacheProxyWriter(Writer writer)", (Object[])new Object[0]);
        }
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setWriter(Writer writer) {
        this.out = writer;
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RESET=" + this), (Object[])new Object[0]);
        }
        this.cachingWriter.reset();
        this.caching = false;
        this.out = null;
        this.flushrequired = false;
        this.writerFlushed = false;
        this.delayWrite = false;
        this.postDelayCachingValue = false;
    }

    public void resetBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("resetBuffer=" + this), (Object[])new Object[0]);
        }
        this.cachingWriter.reset();
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setCaching: this=" + this + " caching=" + caching), (Object[])new Object[0]);
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public char[] getCachedData() {
        char[] toChar = this.cachingWriter.toCharArray();
        if (toChar.length > 0 && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(this + ": getCachedData " + toChar.length + " " + toChar), (Object[])new Object[0]);
        }
        return toChar;
    }

    public void setDelayWrite(boolean flag, boolean pdcv) {
        this.delayWrite = flag;
        this.postDelayCachingValue = pdcv;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.writerFlushed = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("flush this=" + this + " caching=" + this.caching + " flushrequired=" + this.flushrequired + " delayWrite=" + this.delayWrite), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Flusing " + this.out), (Object[])new Object[0]);
        }
        if (this.flushrequired) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.ensureOpen();
                    this.out.flush();
                }
            }
            catch (IOException x) {
                this.trouble = true;
            }
            this.flushrequired = false;
        }
        if (this.delayWrite & !this.caching) {
            this.caching = true;
            this.delayWrite = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flush", (Object)("caching=" + this.caching));
        }
    }

    @Override
    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close", (Object[])new Object[]{this});
        }
        this.flush();
        try {
            this.out.close();
        }
        catch (Exception ex) {
            this.trouble = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close", (Object)this);
        }
    }

    @Override
    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    @Override
    protected void setError() {
        this.trouble = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int c) {
        this.flushrequired = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.valueOf(c), (Object[])new Object[0]);
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.caching) {
                    this.cachingWriter.write(c);
                }
                this.out.write(c);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] buf, int off, int len) {
        this.flushrequired = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)String.valueOf(buf, off, len), (Object[])new Object[0]);
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.caching) {
                    this.cachingWriter.write(buf, off, len);
                }
                this.out.write(buf, off, len);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String s, int off, int len) {
        this.flushrequired = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)s.substring(off, off + len), (Object[])new Object[0]);
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.caching) {
                    this.cachingWriter.write(s, off, off + len);
                }
                this.out.write(s, off, len);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    @Override
    public void write(String s) {
        this.write(s, 0, s.length());
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.caching) {
                    this.cachingWriter.write(lineSeparator);
                }
                this.out.write(lineSeparator);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    private static final String getLineSeparator() {
        Object obj = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
        return (String)obj;
    }

    static class NullWriter
    extends Writer {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] c, int i, int j) {
        }
    }
}

