/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.servlet.CacheProxyRequest;
import com.ibm.ws.cache.servlet.CacheProxyResponse;
import com.ibm.ws.cache.servlet.FragmentComposer;
import com.ibm.ws.cache.servlet.FragmentInfo;
import com.ibm.ws.cache.servlet.JSPCache;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;

public class ESISupport {
    private static TraceComponent tc = Tr.register(ESISupport.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    public static int NO_ESI = 0;
    public static int ESI_10 = 100;
    public static int ESI_10PLUS = 101;
    public static int ESI_09 = 90;
    public static int ESI_08 = 80;
    static int maxTimeLimitInSeconds = 86400;

    public static final void handleESIPreProcessing(CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleESIPreProcessing()", (Object[])new Object[0]);
        }
        FragmentComposer fragmentComposer = response.getFragmentComposer();
        FragmentComposer parentFragmentComposer = fragmentComposer.parent;
        int esiVersion = NO_ESI;
        if (parentFragmentComposer == null) {
            String s = ESISupport.getHeaderDirect(request, "Surrogate-Capability");
            if (s != null) {
                int esiIndex;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("got Surrogate-Capability header: " + s), (Object[])new Object[0]);
                }
                if ((esiIndex = s.indexOf("ESI/1.0")) != -1) {
                    esiVersion = ESI_10;
                    if (s.indexOf(43, esiIndex) != -1) {
                        esiVersion = ESI_10PLUS;
                    }
                } else if (s.indexOf("ESI/0.9+") != -1) {
                    esiVersion = ESI_09;
                } else if (s.indexOf("ESI/0.8") != -1) {
                    esiVersion = ESI_08;
                }
            }
        } else {
            esiVersion = parentFragmentComposer.getESIVersion();
        }
        fragmentComposer.setESIVersion(esiVersion);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("esiVersion: " + esiVersion), (Object[])new Object[0]);
        }
        if (esiVersion == ESI_08) {
            if (request.getAttribute("IBM-DYNACACHE-RRD-BUFFERING") != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"rrd request, set buffering for next include", (Object[])new Object[0]);
                }
                response.setBufferingOutput(true);
                request.removeAttribute("IBM-DYNACACHE-RRD-BUFFERING");
            }
        } else if (esiVersion != NO_ESI) {
            String dispatcherType = (String)request.getAttribute("com.ibm.servlet.engine.webapp.dispatch_type");
            boolean forward = false;
            if (dispatcherType != null && dispatcherType.equals("forward")) {
                forward = true;
            }
            if (forward && parentFragmentComposer != null) {
                if (!ESISupport.parentResponseIsJSFFacesServlet(parentFragmentComposer)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"forward occuring on esi request, moving output buffering", (Object[])new Object[0]);
                    }
                    parentFragmentComposer.getResponse().setBufferingOutput(false);
                    response.setBufferingOutput(true);
                }
            } else if (parentFragmentComposer == null) {
                response.setBufferingOutput(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleESIPreProcessing()");
        }
    }

    private static boolean parentResponseIsJSFFacesServlet(FragmentComposer parentFragmentComposer) {
        boolean isFacesServlet = false;
        if (null != parentFragmentComposer) {
            String servletClassName = parentFragmentComposer.getRequest().getServletClassName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ServletClassName: " + servletClassName), (Object[])new Object[0]);
            }
            boolean bl = isFacesServlet = servletClassName.indexOf("jakarta.faces.webapp.FacesServlet") != -1;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parentFragmentComposerisFacesServlet: " + isFacesServlet), (Object[])new Object[0]);
            }
        }
        return isFacesServlet;
    }

    public static final void handleESIPostProcessing(CacheProxyResponse response, FragmentInfo fragmentInfo, boolean exceptionThrown) throws IOException {
        boolean isSendRedirect;
        int esiVersion = response.getFragmentComposer().getESIVersion();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleESIPostProcessing() esiVersion=" + esiVersion), (Object[])new Object[0]);
        }
        FragmentComposer composer = response.getFragmentComposer();
        for (isSendRedirect = false; !isSendRedirect && composer != null; isSendRedirect |= composer.isSendRedirect) {
            composer = composer.parent;
        }
        if (esiVersion != NO_ESI && response.isBufferingOutput() && !isSendRedirect) {
            JSPCache jspCache = (JSPCache)ServerCache.getJspCache((String)fragmentInfo.getInstanceName());
            if (!response.containsHeader("Surrogate-Control") || jspCache.alwaysSetSurrogateControlHdr()) {
                ESISupport.setSurrogateControl(response, fragmentInfo, exceptionThrown, esiVersion);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Surrogate-Control already set", (Object[])new Object[0]);
            }
        }
        response.flushOutput();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleESIPostProcessing()");
        }
    }

    private static void setSurrogateControl(CacheProxyResponse response, FragmentInfo fragmentInfo, boolean exceptionThrown, int esiVersion) {
        StringBuffer sb = null;
        FragmentComposer parentFragmentComposer = response.getFragmentComposer().parent;
        while (parentFragmentComposer != null) {
            if (parentFragmentComposer.fragmentInfo != null && parentFragmentComposer.fragmentInfo.isEdgeable() && !parentFragmentComposer.fragmentInfo.isUncacheable()) {
                fragmentInfo = parentFragmentComposer.fragmentInfo;
            }
            parentFragmentComposer = parentFragmentComposer.parent;
        }
        CacheProxyResponse surrogateResponse = response;
        while (surrogateResponse instanceof HttpServletResponseWrapper) {
            surrogateResponse = (HttpServletResponse)((HttpServletResponseWrapper)surrogateResponse).getResponse();
        }
        if (!surrogateResponse.isCommitted()) {
            if (fragmentInfo == null || !fragmentInfo.isEdgeable() || fragmentInfo.isUncacheable() || exceptionThrown || fragmentInfo.getDoNotCache() && fragmentInfo.isEdgeable()) {
                sb = new StringBuffer(128).append("no-store");
                if (response.getContainsESIContent()) {
                    sb.append(", content=\"ESI/1.0");
                    if (esiVersion == ESI_10PLUS) {
                        sb.append("+\"");
                    } else {
                        sb.append("\"");
                    }
                }
            } else {
                sb = fragmentInfo.getExpirationTime() > 0L ? new StringBuffer(128).append("max-age=").append((fragmentInfo.getExpirationTime() - System.currentTimeMillis()) / 1000L) : new StringBuffer(128).append("max-age=").append(maxTimeLimitInSeconds);
                if (response.getContainsESIContent()) {
                    if (esiVersion == ESI_10PLUS) {
                        sb.append(",content=\"ESI/1.0+\"");
                    } else {
                        sb.append(",content=\"ESI/1.0\"");
                    }
                }
                sb.append(", depid=\"").append(fragmentInfo.getId());
                Enumeration vEnum = fragmentInfo.getTemplates();
                while (vEnum.hasMoreElements()) {
                    sb.append("\", depid=\"").append((String)vEnum.nextElement());
                }
                vEnum = fragmentInfo.getDataIds();
                while (vEnum.hasMoreElements()) {
                    sb.append("\", depid=\"").append((String)vEnum.nextElement());
                }
                sb.append("\"");
                if (esiVersion == ESI_10PLUS || esiVersion == ESI_09 || esiVersion == ESI_08) {
                    sb.append(",").append(fragmentInfo.getESICacheId());
                }
            }
            if (surrogateResponse instanceof IExtendedResponse) {
                ((IExtendedResponse)surrogateResponse).setInternalHeader("Surrogate-Control", sb.toString());
            } else {
                surrogateResponse.setHeader("Surrogate-Control", sb.toString());
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleESIPostProcessing, Surrogate-Control already set", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("set surrogate-control to:" + sb.toString()), (Object[])new Object[0]);
        }
    }

    private static final void buildESIInclude(CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo, int esiVersion) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("buildESIInclude() esiVersion=" + esiVersion), (Object[])new Object[0]);
        }
        PrintWriter pw = null;
        try {
            pw = response.getWriter();
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.cache.servlet.CacheHook.buildESIInclude", (String)"719");
            String enc = response.getCharacterEncoding();
            pw = enc != null ? new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), enc)) : new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        StringBuffer sb = new StringBuffer(128).append("<esi:include src=\"");
        if (fragmentInfo.getAlternateUrl() != null) {
            int index2;
            String altUrl = fragmentInfo.getAlternateUrl();
            if (altUrl.startsWith("/")) {
                altUrl = request._getContextPath() + altUrl;
            } else {
                int idx = request.getAbsoluteUri().indexOf(request.getRelativeUri());
                String path = request.getAbsoluteUri().substring(0, idx);
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                altUrl = path + altUrl;
            }
            String fragmentInfoUri = fragmentInfo.getURI();
            if (esiVersion == ESI_10) {
                int index1 = fragmentInfoUri.indexOf(63);
                if (index1 > -1) {
                    fragmentInfoUri = fragmentInfoUri.substring(0, index1);
                }
                fragmentInfoUri = fragmentInfoUri + fragmentInfo.getESIQueryString();
            }
            if ((index2 = fragmentInfoUri.indexOf(63)) > -1) {
                fragmentInfoUri = fragmentInfoUri.replace('?', '&');
            }
            altUrl = altUrl.indexOf("?") == -1 ? altUrl + "?dynacache_alturl=" + fragmentInfoUri : altUrl + "&dynacache_alturl=" + fragmentInfoUri;
            sb.append(altUrl);
        } else if (esiVersion == ESI_10) {
            int index = fragmentInfo.getURI().indexOf(63);
            if (index > -1) {
                sb.append(fragmentInfo.getURI().substring(0, index));
            } else {
                sb.append(fragmentInfo.getURI());
            }
            sb.append(fragmentInfo.getESIQueryString());
        } else {
            sb.append(fragmentInfo.getURI());
        }
        pw.print(sb.append("\" />").toString());
        pw.flush();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("buildESIInclude() " + sb.toString()));
        }
    }

    public static boolean shouldBuildESIInclude(CacheProxyRequest request, CacheProxyResponse response, FragmentInfo fragmentInfo) throws IOException {
        int esiVersion = response.getFragmentComposer().getESIVersion();
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("shouldBuildESIInclude() esiVersion=" + esiVersion + " isEdgeable=" + fragmentInfo.isEdgeable()), (Object[])new Object[0]);
        }
        if (esiVersion != NO_ESI && esiVersion != ESI_09 && esiVersion != ESI_08) {
            String alternatedUrl = request.getParameter("dynacache_alturl");
            int j = fragmentInfo.getURI().indexOf(63);
            String fragmentInfoUrl = j > -1 ? fragmentInfo.getURI().substring(0, j) : fragmentInfo.getURI();
            boolean isAltUrl = false;
            if (alternatedUrl != null && alternatedUrl.equals(fragmentInfoUrl)) {
                isAltUrl = true;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("shouldBuildESIInclude() alternatedUrl=" + alternatedUrl + " fragmentInfoUrl=" + fragmentInfoUrl + " isAltUrl=" + isAltUrl), (Object[])new Object[0]);
            }
            if (fragmentInfo.isEdgeable() && !response.getFragmentComposer().isExternalPage() && !isAltUrl) {
                ESISupport.buildESIInclude(request, response, fragmentInfo, esiVersion);
                fragmentInfo.setBuildEsiInclude(true);
                response.setContainsESIContent(true);
                response.getFragmentComposer().setCacheType(2);
                fragmentInfo.setEdgeable(false);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"shouldBuildESIInclude() return=true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"shouldBuildESIInclude() return=false");
        }
        return false;
    }

    static final String getHeaderDirect(HttpServletRequest req, String key) {
        return req.getHeader(key);
    }
}

