/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.ESIInvalidatorServlet;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.intf.ServletCacheUnit;
import com.ibm.ws.cache.servlet.CacheProxyResponseFactory;
import com.ibm.ws.cache.servlet.ESIProcessor;
import com.ibm.ws.cache.servlet.FragmentComposerFactory;
import com.ibm.ws.cache.web.ServletCacheUnitImpl;
import com.ibm.ws.cache.web.config.ConfigManager;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRegistration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="com.ibm.ws.cache.servlet", service={ServletContainerInitializer.class, ServletCacheServiceImpl.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class ServletCacheServiceImpl
implements ServletContainerInitializer,
ServletContextListener {
    private static TraceComponent tc = Tr.register(ServletCacheServiceImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private static ServletCacheUnit servletCacheUnit = new ServletCacheUnitImpl();
    private final AtomicReference<ServerCache> serverCacheReference = new AtomicReference<Object>(null);
    private final AtomicReference<ConfigManager> configManagerRef = new AtomicReference<Object>(null);
    public CacheProxyResponseFactory cacheProxyResponseFactory = null;
    public FragmentComposerFactory fragmentComposerFactory = null;
    private static ServletCacheServiceImpl instance;

    @Activate
    protected void start() throws RuntimeWarning, RuntimeError {
        String methodName = "start()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("start() coreCacheEnabled=" + ServerCache.coreCacheEnabled), (Object[])new Object[0]);
        }
        try {
            if (ServerCache.coreCacheEnabled) {
                ServerCache.servletCacheEnabled = true;
                servletCacheUnit.createBaseCache();
                instance = this;
                Tr.info((TraceComponent)tc, (String)"DYNA1055I", (Object[])new Object[0]);
            }
        }
        catch (IllegalStateException ex) {
            ServerCache.servletCacheEnabled = false;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ServletCacheServiceImpl.start", (String)"222", (Object)this);
            throw new RuntimeError("Servlet Cache Service was not initialized sucessful. Exception: " + ex.getMessage());
        }
        catch (Throwable ex) {
            ServerCache.servletCacheEnabled = false;
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ServletCacheServiceImpl.start", (String)"227", (Object)this);
            throw new RuntimeError("Servlet Cache Service was not initialized sucessful. Exception: " + ex.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("start() cacheEnabled=" + ServerCache.servletCacheEnabled));
        }
    }

    @Deactivate
    protected void stop() {
        String methodName = "stop()";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop()", (Object[])new Object[0]);
        }
        ESIProcessor[] esiProcessors = ESIProcessor.getRunning();
        for (int i = 0; i < esiProcessors.length; ++i) {
            esiProcessors[i].markDead();
        }
        servletCacheUnit.purgeState();
        ServerCache.servletCacheEnabled = false;
        instance = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop()");
        }
    }

    public static ServletCacheServiceImpl getInstance() {
        return instance;
    }

    public void contextInitialized(ServletContextEvent sce) {
        String methodName = "contextInitialized";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextInitialized", (Object[])new Object[]{sce.getServletContext().getContextPath()});
        }
        String webModuleName = null;
        try {
            String contextRoot = sce.getServletContext().getContextPath();
            if (!contextRoot.startsWith("/")) {
                contextRoot = "/" + contextRoot;
            }
            HashMap<String, String> appContext = new HashMap<String, String>();
            appContext.put("servlet", contextRoot);
            appContext.put("static", contextRoot);
            appContext.put("webservice", contextRoot);
            appContext.put("portlet", contextRoot);
            WebAppConfig wConfig = this.getWebModuleConfiguration(sce);
            appContext.put("webAppConfiguration", (String)wConfig);
            webModuleName = wConfig.getModuleName();
            this.getConfigManager().loadConfig(sce.getServletContext(), webModuleName, appContext);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ServletCacheServiceImpl", (String)"169", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextInitialized", webModuleName);
        }
    }

    private WebAppConfig getWebModuleConfiguration(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        while (context instanceof ServletContextFacade) {
            context = ((ServletContextFacade)context).getIServletContext();
        }
        IServletContext iContext = (IServletContext)context;
        WebAppConfig wConfig = iContext.getWebAppConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"webAppConfiguration", (Object[])new Object[]{wConfig});
        }
        return wConfig;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        String methodName = "contextDestroyed";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"contextDestroyed", (Object[])new Object[]{sce.getServletContext().getContextPath()});
        }
        try {
            ConfigManager configManager = this.getConfigManager();
            if (null != configManager) {
                configManager.deleteAppNameCacheEntries(this.getWebModuleConfiguration(sce).getModuleName());
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.ServletCacheServiceImpl", (String)"184", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"contextDestroyed");
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"onStartup", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("created listener to add to servletContext.  listener is: " + this), (Object[])new Object[0]);
        }
        ctx.addListener((EventListener)((Object)this));
        ServletRegistration.Dynamic dynamic = ctx.addServlet("ESIInvalidatorServlet", ESIInvalidatorServlet.class);
        dynamic.addMapping(new String[]{"/esiInvalidator"});
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"onStartup");
        }
    }

    public ServerCache getServerCache() {
        return this.serverCacheReference.get();
    }

    @Reference(service=ServerCache.class)
    protected void setServerCache(ServerCache sc) {
        this.serverCacheReference.set(sc);
    }

    protected void unsetServerCache(ServerCache serverCache) {
        this.serverCacheReference.compareAndSet(serverCache, null);
    }

    public ConfigManager getConfigManager() {
        return this.configManagerRef.get();
    }

    @Reference(service=ConfigManager.class)
    protected void setConfigManager(ConfigManager cm) {
        this.configManagerRef.set(cm);
    }

    protected void unsetConfigManager(ConfigManager configManager) {
        this.configManagerRef.compareAndSet(configManager, null);
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCacheProxyResponseFactory(CacheProxyResponseFactory factory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setCacheProxyResponseFactory: " + factory), (Object[])new Object[0]);
        }
        this.cacheProxyResponseFactory = factory;
    }

    protected void unsetCacheProxyResponseFactory(CacheProxyResponseFactory factory) {
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setFragmentComposerFactory(FragmentComposerFactory factory) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setFragmentComposerFactory: " + factory), (Object[])new Object[0]);
        }
        this.fragmentComposerFactory = factory;
    }

    protected void unsetFragmentComposerFactory(FragmentComposerFactory factory) {
    }

    static {
        ServerCache.cacheUnit.setServletCacheUnit(servletCacheUnit);
    }
}

