/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.monitor.internal.bci;

import com.ibm.websphere.monitor.annotation.ProbeFieldGet;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.monitor.internal.ListenerConfiguration;
import com.ibm.ws.monitor.internal.ProbeFilter;
import com.ibm.ws.monitor.internal.ProbeImpl;
import com.ibm.ws.monitor.internal.ProbeListener;
import com.ibm.ws.monitor.internal.bci.MethodInfo;
import com.ibm.ws.monitor.internal.bci.ProbeMethodAdapter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class ProbeFieldGetMethodAdapter
extends ProbeMethodAdapter {
    private static final String FIELD_FILTER_KEY;
    private static final String FIELD_TYPE_FILTER_KEY;
    private Map<ProbeListener, ProbeFilter> fieldFilters = new HashMap<ProbeListener, ProbeFilter>();
    private Map<ProbeListener, ProbeFilter> fieldTypeFilters = new HashMap<ProbeListener, ProbeFilter>();
    static final long serialVersionUID = -2462568950194283067L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ProbeFieldGetMethodAdapter(ProbeMethodAdapter probeMethodAdapter, MethodInfo methodInfo, Set<ProbeListener> interested) {
        super(probeMethodAdapter, methodInfo);
        for (ProbeListener listener : interested) {
            ProbeFilter fieldTypeFilter;
            ListenerConfiguration config = listener.getListenerConfiguration();
            ProbeFieldGet probeFieldGet = config.getProbeFieldGet();
            if (probeFieldGet == null) continue;
            ProbeFilter fieldFilter = (ProbeFilter)config.getTransformerData(FIELD_FILTER_KEY);
            if (fieldFilter == null) {
                String className = probeFieldGet.clazz();
                if (className.isEmpty()) {
                    className = probeMethodAdapter.getProbedClass().getName();
                }
                fieldFilter = new ProbeFilter(className, probeFieldGet.field(), null, null, null);
                config.setTransformerData(FIELD_FILTER_KEY, fieldFilter);
            }
            if ((fieldTypeFilter = (ProbeFilter)config.getTransformerData(FIELD_TYPE_FILTER_KEY)) == null) {
                fieldTypeFilter = new ProbeFilter(probeFieldGet.type(), null, null, null, null);
                config.setTransformerData(FIELD_TYPE_FILTER_KEY, fieldTypeFilter);
            }
            this.fieldFilters.put(listener, fieldFilter);
            this.fieldTypeFilters.put(listener, fieldTypeFilter);
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.fieldFilters.isEmpty() || opcode != 178 && opcode != 180) {
            super.visitFieldInsn(opcode, owner, name, desc);
            return;
        }
        Class<?> clazz = null;
        Field field = null;
        HashSet<ProbeListener> matchingListeners = new HashSet<ProbeListener>();
        Type fieldType = Type.getType((String)desc);
        for (ProbeListener listener : this.fieldFilters.keySet()) {
            ProbeFilter fieldFilter = this.fieldFilters.get(listener);
            ProbeFilter fieldTypeFilter = this.fieldTypeFilters.get(listener);
            if (!fieldFilter.basicMemberNameMatches(name) || !fieldTypeFilter.basicClassNameMatches(fieldType.getClassName())) continue;
            if (clazz == null) {
                clazz = this.getOwningClass(owner);
                field = this.getTargetField(clazz, name, desc);
            }
            if (!fieldFilter.matches(field) || !fieldTypeFilter.matches(field.getType())) continue;
            matchingListeners.add(listener);
        }
        if (!matchingListeners.isEmpty()) {
            String key = this.createKey(owner, name, desc);
            ProbeImpl probe = this.getProbe(key);
            long probeId = probe.getIdentifier();
            this.setProbeInProgress(true);
            if (opcode == 178) {
                this.visitInsn(1);
            } else {
                this.visitInsn(89);
                this.visitInsn(89);
            }
            super.visitFieldInsn(opcode, owner, name, desc);
            this.box(fieldType);
            this.visitLdcInsn(probeId);
            this.visitInsn(94);
            this.visitInsn(88);
            if (this.isStatic()) {
                this.visitInsn(1);
            } else {
                this.visitVarInsn(25, 0);
            }
            this.visitInsn(91);
            this.visitInsn(87);
            this.visitFireProbeInvocation();
            this.setProbeInProgress(false);
            this.setProbeListeners(probe, matchingListeners);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    String createKey(String owner, String fieldName, String desc) {
        StringBuilder sb = new StringBuilder("FIELD_GET: ");
        sb.append(this.getMethodName());
        sb.append(this.getDescriptor());
        sb.append(" gets ");
        sb.append(owner).append(".").append(fieldName);
        sb.append(" (").append(desc).append(")");
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.monitor.internal.bci.ProbeFieldGetMethodAdapter", ProbeFieldGetMethodAdapter.class, (String)"PMI", (String)"com.ibm.ws.pmi.properties.PMIMessages");
        FIELD_FILTER_KEY = ProbeFieldGet.class.getSimpleName() + ":FieldFilter";
        FIELD_TYPE_FILTER_KEY = ProbeFieldGet.class.getSimpleName() + ":FieldTypeFilter";
    }
}

