/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.utility.tasks;

import com.ibm.ws.collective.member.internal.ssh.SSHKeyGenerator;
import com.ibm.ws.collective.member.internal.ssh.SSHKeyUtility;
import com.ibm.ws.collective.utility.ICollectiveRegistrationMBeanConnection;
import com.ibm.ws.collective.utility.IFileUtility;
import com.ibm.ws.collective.utility.TaskErrorException;
import com.ibm.ws.collective.utility.tasks.BaseCommandTask;
import com.ibm.ws.collective.utility.utils.ConsoleWrapper;
import com.ibm.ws.collective.utility.utils.Trlog;
import com.ibm.ws.collective.utils.PasswordMaskUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeMBeanException;

public class RegisterHostTask
extends BaseCommandTask {
    private static final String className = RegisterHostTask.class.getName();
    private final SSHKeyGenerator sshKeyGen;
    private final SSHKeyUtility sshKeyUtil;
    private final ICollectiveRegistrationMBeanConnection registrationMBean;

    public RegisterHostTask(String scriptName, IFileUtility fileUtility, SSHKeyGenerator sshKeyGen, SSHKeyUtility sshKeyUtil, ICollectiveRegistrationMBeanConnection registrationMBean) {
        super(scriptName, fileUtility);
        this.sshKeyGen = sshKeyGen;
        this.sshKeyUtil = sshKeyUtil;
        this.registrationMBean = registrationMBean;
        this.reqConnectArgs.add("--host");
        this.reqConnectArgs.add("--port");
        this.reqConnectArgs.add("--user");
        this.reqConnectArgs.add("--password");
        this.promptableArgs.add("--password");
        this.flagArgs.add("--trace");
        this.flagArgs.add("--controller");
        this.knownArgs.addAll(this.reqConnectArgs);
        this.knownArgs.addAll(this.promptableArgs);
        this.knownArgs.addAll(this.confirmedArgs);
        this.knownArgs.addAll(this.flagArgs);
        this.addHostAuthInfoArgs(true);
        this.addAutoAcceptArgument();
    }

    @Override
    public String getTaskName() {
        return "registerHost";
    }

    @Override
    public String getTaskUsage() {
        return this.getTaskUsage("registerHost.usage.options");
    }

    @Override
    public String getTaskHelp() {
        String footer = this.buildScriptOptions("hostAuthInfo.option-key.", "hostAuthInfo.option-desc.") + this.buildScriptOptions("hostOnly.option-key.", "hostOnly.option-desc.") + this.buildScriptOptions("certProps.option-key.autoAccept", "certProps.option-desc.autoAccept") + this.buildScriptOptions("registerHost.option-key.", "registerHost.option-desc.");
        return this.getTaskHelp("registerHost.desc", "registerHost.usage.options", "connection.option-key.", "connection.option-desc.", null, footer, this.scriptName);
    }

    @Override
    public String getTaskDescription() {
        return this.getOption("registerHost.desc", new Object[0]);
    }

    @Override
    protected void abort(String message) throws TaskErrorException {
        this.stdout.println(this.getMessage("registerHost.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    private void abort(String message, String traceMethodName) throws TaskErrorException {
        Trlog.exit(className, traceMethodName, message);
        this.stdout.println(this.getMessage("registerHost.abort", new Object[0]));
        throw new TaskErrorException(message);
    }

    @Override
    protected void abortAndPerformCleanup(String message, File collectiveResourcesDir) throws TaskErrorException {
    }

    private boolean registerHost(String host, int port, String user, String password, String hostName, Map<String, Object> hostAuthInfo) throws TaskErrorException {
        String methodName = "registerHost";
        Trlog.enter(className, methodName, new Object[]{host, port, user, password.replaceAll(".", "*"), hostName});
        try {
            this.registrationMBean.registerHost(host, port, user, password, hostName, hostAuthInfo);
            Trlog.debug(className, methodName, "Host " + hostName + " successfully registered.");
            this.stdout.println(this.getMessage("registerHost.registerSuccess", hostName));
            return true;
        }
        catch (RuntimeMBeanException e) {
            Trlog.debug(className, methodName, "Caught RuntimeMBeanException: " + e.getMessage());
            if (e.getCause() instanceof IllegalStateException) {
                this.abort(this.getMessage("registerHost.registeredAlready", hostName), methodName);
            } else if (e.getCause() instanceof IllegalArgumentException) {
                this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
            } else {
                this.stderr.println(this.getMessage("error", e.getMessage()));
                this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
            }
        }
        catch (UnknownHostException e) {
            this.abort(this.getMessage("common.hostError", host), methodName);
        }
        catch (ConnectException e) {
            this.abort(this.getMessage("common.portError", String.valueOf(port)), methodName);
        }
        catch (IOException e) {
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
        }
        catch (Exception e) {
            this.stderr.println(this.getMessage("error", e.getMessage()));
            this.abort(this.getMessage("common.connectionError", host, port, user, e.getMessage()), methodName);
        }
        Trlog.exit(className, methodName, "return false");
        return false;
    }

    @Override
    public void handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws TaskErrorException {
        this.setupTrace(args, className, this.fileUtility);
        String methodName = "handleTask";
        Trlog.enter(className, methodName);
        this.stdin = stdin;
        this.stdout = stdout;
        this.stderr = stderr;
        boolean isThisHost = false;
        this.validateArgumentList(args, true);
        String hostName = this.getTaskTarget(args);
        if (hostName == null) {
            Trlog.debug(className, methodName, "The host name was not specified, defaulting to this host name");
            isThisHost = true;
            hostName = this.getHostName();
        }
        this.handleAutoAcceptArgument(args);
        String controllerHost = this.getControllerHost(args);
        int controllerPort = Integer.valueOf(this.getControllerPort(args));
        String user = this.getControllerUser(args);
        String password = this.getControllerPassword(args);
        boolean useSudo = Boolean.valueOf(this.getArgumentValue("--useSudo", args, null));
        Trlog.debug(className, methodName, "useSudo:\n" + useSudo);
        List<String> list = Arrays.asList(args);
        Boolean useCollectiveSSHKey = list.contains("--useCollectiveSSHKey");
        this.validateUseSSHKeyOverrides(list, useCollectiveSSHKey);
        Map<String, Object> hostAuthInfo = this.buildHostAuthInfo(args, this.sshKeyGen, this.sshKeyUtil, this.registrationMBean, null, controllerHost, controllerPort, user, password, hostName, isThisHost, true, null, null);
        Map hostAuthInfoWithMaskPassword = PasswordMaskUtil.maskPasswordsInMap(hostAuthInfo);
        Trlog.debug(className, methodName, "Resulting hostAuthInfo: " + hostAuthInfoWithMaskPassword);
        Trlog.debug(className, methodName, "Registering the host to the collective...");
        stdout.println(this.getMessage("registerHost.attemptRegister", new Object[0]));
        if (!this.registerHost(controllerHost, controllerPort, user, password, hostName, hostAuthInfo)) {
            Trlog.debug(className, methodName, "Host " + hostName + " could not be registered due to an error.");
            stdout.println(this.getMessage("registerHost.registerFailed", hostName));
        }
        if (isThisHost) {
            this.updateAuthorizedKeysFiles(this.sshKeyUtil);
        } else {
            this.notifyIfMoreWorkToDo(hostName);
            Trlog.debug(className, methodName, "Registered a host which is not this host");
        }
        Trlog.exit(className, methodName);
    }
}

