/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.appclient.boot;

import com.ibm.ws.kernel.boot.HelpActions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class ClientHelpActions
implements HelpActions {
    private static final Map<Category, List<Command>> commandsByCategory = Command.commandsMap();
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.ibm.ws.appclient.boot.resources.ClientLauncherOptions");

    public Object toAction(String val) {
        return Command.toCommand(val);
    }

    public boolean isHelpAction(Object action) {
        return action == Command.helpCmd;
    }

    public String allActions() {
        List<Command> cmds = Command.commands();
        StringBuilder builder = new StringBuilder();
        builder.append('{');
        for (Command c : cmds) {
            builder.append((Object)c);
            builder.append('|');
        }
        builder.deleteCharAt(builder.length() - 1);
        builder.append('}');
        return builder.toString();
    }

    public Collection<String> options(Object action) {
        if (action instanceof Command) {
            return ((Command)((Object)action)).options();
        }
        return new ArrayList<String>();
    }

    public Collection<?> getCategories() {
        return Arrays.asList(Category.values());
    }

    public Collection<?> geActionsForCategories(Object c) {
        return commandsByCategory.get(c);
    }

    public ResourceBundle getResourceBundle() {
        return rb;
    }

    private static enum Category {
        lifecycle,
        help,
        misc;

    }

    private static enum Command {
        createCmd(Category.lifecycle, "template"),
        debugCmd(Category.lifecycle, "autoAcceptSigner", "clean"),
        helpCmd(Category.help, new String[0]),
        packageCmd(Category.misc, "archive", "include"),
        runCmd(Category.lifecycle, "autoAcceptSigner", "clean");

        private final Category category;
        private final String[] opts;

        private Command(Category c, String ... options) {
            this.category = c;
            this.opts = options;
        }

        public Category getCategory() {
            return this.category;
        }

        public String toString() {
            String name = this.name();
            return name.substring(0, name.length() - 3);
        }

        public static Command toCommand(String name) {
            if (name == null) {
                return null;
            }
            if (name.startsWith("--")) {
                name = name.substring(2);
            }
            try {
                return Command.valueOf(name + "Cmd");
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public static List<Command> commands() {
            ArrayList<Command> command = new ArrayList<Command>(Arrays.asList(Command.values()));
            Collections.sort(command, new Comparator<Command>(){

                @Override
                public int compare(Command o1, Command o2) {
                    return o1.name().compareTo(o2.name());
                }
            });
            return command;
        }

        public static Map<Category, List<Command>> commandsMap() {
            HashMap<Category, List<Command>> result = new HashMap<Category, List<Command>>();
            for (Command c : Command.values()) {
                ArrayList<Command> commands = (ArrayList<Command>)result.get((Object)c.getCategory());
                if (commands == null) {
                    commands = new ArrayList<Command>();
                    result.put(c.getCategory(), commands);
                }
                commands.add(c);
            }
            return result;
        }

        public Collection<String> options() {
            ArrayList<String> options = new ArrayList<String>(Arrays.asList(this.opts));
            Collections.sort(options);
            return options;
        }
    }
}

