/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS30.jsonb20provider;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.spi.JsonbProvider;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@Produces(value={"*/*"})
@Consumes(value={"*/*"})
@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JsonBProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object>,
UnaryOperator<Jsonb> {
    private static final TraceComponent tc = Tr.register(JsonBProvider.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    private static final Charset DEFAULT_CHARSET = JsonBProvider.getDefaultCharset();
    private final JsonbProvider jsonbProvider;
    private final AtomicReference<Jsonb> jsonb = new AtomicReference();
    @Context
    protected Providers providers;
    static final long serialVersionUID = -2127741125492655161L;

    @FFDCIgnore(value={Exception.class})
    private static Charset getDefaultCharset() {
        Charset cs;
        block4: {
            cs = null;
            String csStr = null;
            try {
                csStr = AccessController.doPrivileged(() -> System.getProperty("com.ibm.ws.jaxrs.jsonbprovider.defaultCharset"));
                if (csStr != null) {
                    cs = Charset.forName(csStr);
                }
            }
            catch (Exception ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Could not load specified default charset: " + csStr), (Object[])new Object[0]);
            }
        }
        if (cs == null) {
            cs = StandardCharsets.UTF_8;
        }
        return cs;
    }

    /*
     * WARNING - void declaration
     */
    public JsonBProvider() {
        JsonbProvider jsonbProvider = AccessController.doPrivileged(new PrivilegedAction<JsonbProvider>(){
            static final long serialVersionUID = 5306583946063871339L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public JsonbProvider run() {
                try {
                    Bundle b = FrameworkUtil.getBundle(JsonBProvider.class);
                    if (b != null) {
                        BundleContext bc = b.getBundleContext();
                        ServiceReference sr = bc.getServiceReference(JsonbProvider.class);
                        return (JsonbProvider)bc.getService(sr);
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"io.openliberty.restfulWS30.jsonb20provider.JsonBProvider$1", (String)"107", (Object)this, (Object[])new Object[0]);
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS30.jsonb20provider.JsonBProvider$1", 1.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
            }
        });
        if (jsonbProvider == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("<init> provider not found in OSGi services - looking up via META-INF/services/" + JsonbProvider.class.getName()), (Object[])new Object[0]);
            }
            try {
                jsonbProvider = AccessController.doPrivileged(new PrivilegedExceptionAction<JsonbProvider>(){
                    static final long serialVersionUID = 8009382297216181942L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public JsonbProvider run() throws Exception {
                        Iterator<JsonbProvider> providers = ServiceLoader.load(JsonbProvider.class).iterator();
                        if (providers.hasNext()) {
                            return providers.next();
                        }
                        providers = ServiceLoader.load(JsonbProvider.class, JsonBProvider.class.getClassLoader()).iterator();
                        if (providers.hasNext()) {
                            return providers.next();
                        }
                        if (Boolean.getBoolean("com.ibm.ws.jaxrs.testing")) {
                            return null;
                        }
                        throw new IllegalArgumentException("jsonbProvider can't be null");
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS30.jsonb20provider.JsonBProvider$2", 2.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                void ex;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"io.openliberty.restfulWS30.jsonb20provider.JsonBProvider", (String)"141", (Object)this, (Object[])new Object[0]);
                Throwable t = ex.getCause();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new IllegalArgumentException(t);
            }
        }
        this.jsonbProvider = jsonbProvider;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean readable = false;
        if (!this.isUntouchable(type) && this.isJsonType(mediaType)) {
            readable = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("readable=" + readable), (Object[])new Object[0]);
        }
        return readable;
    }

    public Object readFrom(Class<Object> clazz, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        if (genericType instanceof ParameterizedType && CompletionStage.class.equals((Object)((ParameterizedType)genericType).getRawType())) {
            genericType = ((ParameterizedType)genericType).getActualTypeArguments()[0];
        }
        Object obj = this.getJsonb(mediaType, clazz).fromJson(entityStream, genericType);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("object=" + obj), (Object[])new Object[0]);
        }
        return obj;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        boolean writeable = false;
        if (!this.isUntouchable(type) && this.isJsonType(mediaType)) {
            writeable = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeable=" + writeable), (Object[])new Object[0]);
        }
        return writeable;
    }

    private boolean isUntouchable(Class<?> clazz) {
        String[] jsonpClasses = new String[]{"jakarta.json.JsonArray", "jakarta.json.JsonObject", "jakarta.json.JsonStructure"};
        boolean untouchable = false;
        for (String c : jsonpClasses) {
            if (!clazz.toString().equals(c)) continue;
            untouchable = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("untouchable=" + untouchable), (Object[])new Object[0]);
        }
        return untouchable;
    }

    private boolean isJsonType(MediaType mediaType) {
        return mediaType.getSubtype().toLowerCase().startsWith("json") || mediaType.getSubtype().toLowerCase().contains("+json");
    }

    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String json = this.getJsonb(mediaType, type).toJson(obj);
        entityStream.write(json.getBytes(JsonBProvider.charset(httpHeaders)));
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("object=" + obj), (Object[])new Object[0]);
        }
    }

    private Jsonb getJsonb(MediaType mediaType, Class<?> clazz) {
        Jsonb contextJsonb;
        ContextResolver cr = this.providers.getContextResolver(Jsonb.class, mediaType);
        if (cr != null && (contextJsonb = (Jsonb)cr.getContext(clazz)) != null) {
            return contextJsonb;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Context-injected Providers is null", (Object[])new Object[0]);
        }
        if (this.jsonbProvider == null) {
            return null;
        }
        Jsonb json = this.jsonb.get();
        if (json == null) {
            return this.jsonb.updateAndGet(this);
        }
        return json;
    }

    @Override
    public Jsonb apply(Jsonb t) {
        if (t != null) {
            return t;
        }
        return this.jsonbProvider.create().build();
    }

    private static Charset charset(MultivaluedMap<String, Object> httpHeaders) {
        if (httpHeaders == null) {
            return DEFAULT_CHARSET;
        }
        List charsets = (List)httpHeaders.get((Object)"Accept-Charset");
        return JsonBProvider.sortCharsets(charsets).stream().findFirst().orElseGet(() -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No matching charsets, using " + DEFAULT_CHARSET.name() + ", client requested " + charsets), (Object[])new Object[0]);
            }
            return DEFAULT_CHARSET;
        });
    }

    public static List<Charset> sortCharsets(List<?> charsetHeaderValues) {
        if (charsetHeaderValues == null || charsetHeaderValues.size() < 1) {
            return Collections.emptyList();
        }
        return charsetHeaderValues.stream().map(CharsetQualityTuple::parseTuple).sorted((t1, t2) -> Float.compare(t1.quality, t2.quality) * -1).filter(t -> t.charset != null && t.quality > 0.0f).map(t -> t.charset).collect(Collectors.toList());
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CharsetQualityTuple {
        Charset charset;
        float quality = 1.0f;
        static final long serialVersionUID = -8708448802511333477L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CharsetQualityTuple() {
        }

        @FFDCIgnore(value={IllegalCharsetNameException.class})
        static CharsetQualityTuple parseTuple(Object o) {
            CharsetQualityTuple tuple;
            block9: {
                String s = o instanceof String ? (String)o : o.toString();
                tuple = new CharsetQualityTuple();
                String[] sArr = s.split(";[qQ]=");
                if (sArr.length > 1) {
                    try {
                        float f = Float.parseFloat(sArr[1]);
                        tuple.quality = Float.min(1.0f, Float.max(0.0f, f));
                    }
                    catch (NumberFormatException f) {
                        FFDCFilter.processException((Throwable)f, (String)"io.openliberty.restfulWS30.jsonb20provider.JsonBProvider$CharsetQualityTuple", (String)"311", null, (Object[])new Object[]{o});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Invalid charset weight (" + s + ") - defaulting to 0."), (Object[])new Object[0]);
                        }
                        tuple.quality = 0.0f;
                    }
                }
                try {
                    if (Charset.isSupported(sArr[0])) {
                        tuple.charset = Charset.forName(sArr[0]);
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Unsupported charset, " + sArr[0]), (Object[])new Object[0]);
                    }
                }
                catch (IllegalCharsetNameException ex) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                    Tr.debug((TraceComponent)tc, (String)("Illegal charset name, " + sArr[0]), (Object[])new Object[0]);
                }
            }
            return tuple;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.restfulWS30.jsonb20provider.JsonBProvider$CharsetQualityTuple", CharsetQualityTuple.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
        }
    }
}

