/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tx.jta.impl;

import com.ibm.tx.jta.TransactionManagerFactory;
import com.ibm.tx.jta.impl.JCARecoveryData;
import com.ibm.tx.jta.impl.JCATranWrapper;
import com.ibm.tx.jta.impl.JCATranWrapperImpl;
import com.ibm.tx.jta.impl.TranManagerSet;
import com.ibm.tx.jta.impl.TransactionImpl;
import com.ibm.tx.jta.impl.TxXATerminator;
import com.ibm.tx.util.ByteArray;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.WorkCompletedException;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.SystemException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class TxExecutionContextHandler {
    private static final TraceComponent tc = Tr.register(TxExecutionContextHandler.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TxExecutionContextHandler _instance = new TxExecutionContextHandler();
    protected static final HashMap<ByteArray, JCATranWrapper> txnTable = new HashMap();

    public void associate(ExecutionContext ec, String providerId) throws WorkCompletedException {
        JCATranWrapper txWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doAssociate", (Object[])new Object[]{ec, providerId});
        }
        if (null == ec) {
            WorkCompletedException wce = new WorkCompletedException("Invalid ExecutionContext", "3");
            Tr.error((TraceComponent)tc, (String)"WTRN0091_ASSOCIATE_FAILED", (Object[])new Object[]{null, null});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Invalid ExecutionContext");
            }
            throw wce;
        }
        Xid xid = ec.getXid();
        if (null == xid) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Null Xid");
            }
            return;
        }
        if (!TxXATerminator.isValid(xid)) {
            WorkCompletedException wce = new WorkCompletedException("Invalid Xid", "3");
            Tr.error((TraceComponent)tc, (String)"WTRN0091_ASSOCIATE_FAILED", (Object[])new Object[]{ec, ec.getTransactionTimeout()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Invalid Xid");
            }
            throw wce;
        }
        int status = 6;
        try {
            status = TransactionManagerFactory.getTransactionManager().getStatus();
        }
        catch (SystemException e) {
            WorkCompletedException wce = new WorkCompletedException("3", (Throwable)e);
            Tr.error((TraceComponent)tc, (String)"WTRN0091_ASSOCIATE_FAILED", (Object[])new Object[]{ec, ec.getTransactionTimeout()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)((Object)wce));
            }
            throw wce;
        }
        if (status != 6) {
            WorkCompletedException wce = new WorkCompletedException("Already associated", "3");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Already associated");
            }
            throw wce;
        }
        if (providerId == null) {
            WorkCompletedException wce = new WorkCompletedException("Null providerId", "3");
            Tr.error((TraceComponent)tc, (String)"WTRN0091_ASSOCIATE_FAILED", (Object[])new Object[]{ec, ec.getTransactionTimeout()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)("Invalid providerId: " + providerId));
            }
            throw wce;
        }
        try {
            txWrapper = this.findTxWrapper((int)ec.getTransactionTimeout(), xid, providerId);
        }
        catch (WorkCompletedException wce) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Can't create new tx while quiescing");
            }
            throw wce;
        }
        if (txWrapper == null) {
            wce = new WorkCompletedException("Already have an association or already prepared", "2");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"Already have an association or already prepared");
            }
            throw wce;
        }
        try {
            ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).resume(txWrapper.getTransaction());
        }
        catch (InvalidTransactionException e) {
            WorkCompletedException wce = new WorkCompletedException("resume threw InvalidTransactionException", (Throwable)e);
            wce.setErrorCode("3");
            Tr.error((TraceComponent)tc, (String)"WTRN0091_ASSOCIATE_FAILED", (Object[])new Object[]{ec, ec.getTransactionTimeout()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"resume threw InvalidTransactionException");
            }
            throw wce;
        }
        catch (IllegalStateException e) {
            WorkCompletedException wce = new WorkCompletedException("resume threw IllegalStateException", (Throwable)e);
            wce.setErrorCode("3");
            Tr.error((TraceComponent)tc, (String)"WTRN0091_ASSOCIATE_FAILED", (Object[])new Object[]{ec, ec.getTransactionTimeout()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"associate", (Object)"resume threw IllegalStateException");
            }
            throw wce;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associate");
        }
    }

    public void dissociate() {
        TxExecutionContextHandler.doDissociate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionImpl doDissociate() {
        TransactionImpl oldTxn;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"doDissociate", (Object[])new Object[0]);
        }
        if ((oldTxn = ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).getTransactionImpl()) != null) {
            JCATranWrapper txWrapper;
            ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).suspend();
            Xid xid = oldTxn.getXid();
            ByteArray key = new ByteArray(xid.getGlobalTransactionId());
            HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
            synchronized (hashMap) {
                txWrapper = txnTable.get(key);
                if (null == txWrapper) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"doDissociate", (Object)oldTxn);
                    }
                    return oldTxn;
                }
                txWrapper.removeAssociation();
            }
            txWrapper.resume();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"doDissociate", (Object)oldTxn);
        }
        return oldTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static JCATranWrapper getTxWrapper(Xid xid, boolean addAssociation) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getTxWrapper", (Object[])new Object[]{xid, addAssociation});
        }
        ByteArray key = new ByteArray(xid.getGlobalTransactionId());
        HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
        // MONITORENTER : hashMap
        JCATranWrapper txWrapper = txnTable.get(key);
        if (txWrapper == null) {
            if (!tc.isEntryEnabled()) throw new XAException(-4);
            Tr.exit((TraceComponent)tc, (String)"getTxWrapper", (Object)"throwing XAER_NOTA");
            throw new XAException(-4);
        }
        if (addAssociation) {
            if (txWrapper.hasAssociation()) {
                if (!tc.isEntryEnabled()) throw new XAException(-6);
                Tr.exit((TraceComponent)tc, (String)"getTxWrapper", (Object)"throwing XAER_PROTO");
                throw new XAException(-6);
            }
            txWrapper.addAssociation();
        }
        // MONITOREXIT : hashMap
        if (!tc.isEntryEnabled()) return txWrapper;
        Tr.exit((TraceComponent)tc, (String)"getTxWrapper", (Object)txWrapper);
        return txWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected JCATranWrapper findTxWrapper(int timeout, Xid xid, String providerId) throws WorkCompletedException {
        JCATranWrapper txWrapper;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"findTxWrapper", (Object[])new Object[]{timeout, xid, providerId});
            }
            ByteArray key = new ByteArray(xid.getGlobalTransactionId());
            HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
            // MONITORENTER : hashMap
            if (!txnTable.containsKey(key)) {
                if (((TranManagerSet)TransactionManagerFactory.getTransactionManager()).isQuiesced()) {
                    if (!tc.isEntryEnabled()) throw new WorkCompletedException("In quiesce period", "3");
                    Tr.exit((TraceComponent)tc, (String)"findTxWrapper", (Object)"quiescing");
                    throw new WorkCompletedException("In quiesce period", "3");
                }
                JCARecoveryData jcard = (JCARecoveryData)((TranManagerSet)TransactionManagerFactory.getTransactionManager()).registerJCAProvider(providerId);
                try {
                    jcard.logRecoveryEntry();
                }
                catch (Exception e) {
                    if (!tc.isEntryEnabled()) throw new WorkCompletedException(e.getLocalizedMessage(), "3");
                    Tr.exit((TraceComponent)tc, (String)"findTxWrapper", (Object)e);
                    throw new WorkCompletedException(e.getLocalizedMessage(), "3");
                }
                txWrapper = this.createWrapper(timeout, xid, jcard);
                txnTable.put(key, txWrapper);
            } else {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Already encountered", (Object[])new Object[]{key});
                }
                if (!(txWrapper = txnTable.get(key)).hasAssociation()) {
                    if (!txWrapper.isPrepared()) {
                        txWrapper.addAssociation();
                        txWrapper.suspend();
                        break block14;
                    } else {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"findTxWrapper", (Object)"already prepared");
                        }
                        // MONITOREXIT : hashMap
                        return null;
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findTxWrapper", (Object)"already associated");
                }
                // MONITOREXIT : hashMap
                return null;
            }
        }
        // MONITOREXIT : hashMap
        if (!tc.isEntryEnabled()) return txWrapper;
        Tr.exit((TraceComponent)tc, (String)"findTxWrapper", (Object)txWrapper);
        return txWrapper;
    }

    protected JCATranWrapper createWrapper(int timeout, Xid xid, JCARecoveryData jcard) throws WorkCompletedException {
        return new JCATranWrapperImpl(timeout, xid, jcard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTxn(TransactionImpl txn) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTxn", (Object[])new Object[]{txn});
        }
        ByteArray key = new ByteArray(txn.getXid().getGlobalTransactionId());
        HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
        synchronized (hashMap) {
            if (!txnTable.containsKey(key)) {
                txnTable.put(key, new JCATranWrapperImpl(txn, true, false));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTxn");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void removeTxn(Xid xid) {
        JCATranWrapper wrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeTxn", (Object[])new Object[]{xid});
        }
        ByteArray key = new ByteArray(xid.getGlobalTransactionId());
        HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
        synchronized (hashMap) {
            wrapper = txnTable.remove(key);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeTxn", (Object)wrapper);
        }
    }

    protected void reAssociate(TransactionImpl txn) {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"reAssociate", (Object[])new Object[]{txn});
            }
            if (txn.isRAImport()) {
                ExecutionContext ec = new ExecutionContext();
                ec.setXid(txn.getXid());
                try {
                    this.associate(ec, txn.getJCARecoveryData().getWrapper().getProviderId());
                }
                catch (WorkCompletedException e) {
                    if (tc.isEventEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"reAssociate", (Object)((Object)e));
                    }
                    break block8;
                }
            }
            try {
                ((TranManagerSet)TransactionManagerFactory.getTransactionManager()).resume(txn);
            }
            catch (Exception e) {
                if (!tc.isEventEnabled()) break block8;
                Tr.event((TraceComponent)tc, (String)"reAssociate", (Object[])new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reAssociate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Xid[] recover(int flag) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recover", (Object[])new Object[]{Util.printFlag(flag)});
        }
        if (((TranManagerSet)TransactionManagerFactory.getTransactionManager()).isReplayComplete()) {
            Xid[] xids;
            HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
            synchronized (hashMap) {
                ArrayList<Xid> xidList = new ArrayList<Xid>();
                for (JCATranWrapper txWrapper : txnTable.values()) {
                    TransactionImpl txn = txWrapper.getTransaction();
                    switch (txn.getTransactionState().getState()) {
                        case 2: 
                        case 7: 
                        case 8: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("recovering txn with state: " + txn.getTransactionState()), (Object[])new Object[0]);
                            }
                            Xid xid = txn.getJCAXid();
                            xidList.add(xid);
                            break;
                        }
                    }
                }
                xids = xidList.toArray(new Xid[0]);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"recover", (Object)xids);
            }
            return xids;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recover", (Object)"throwing XAER_RMFAIL");
        }
        throw new XAException(-7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAssociation(JCATranWrapper txWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAssociation", (Object[])new Object[]{txWrapper});
        }
        HashMap<ByteArray, JCATranWrapper> hashMap = txnTable;
        synchronized (hashMap) {
            txWrapper.removeAssociation();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAssociation");
        }
    }

    public static TxExecutionContextHandler instance() {
        return _instance;
    }
}

