/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.metrics.writer;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.metrics.Constants;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics.helper.Util;
import com.ibm.ws.microprofile.metrics.writer.OutputWriter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JSONMetadataWriter
implements OutputWriter {
    private static final TraceComponent tc = Tr.register(JSONMetadataWriter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    protected final Writer writer;
    protected final Locale locale;
    static final long serialVersionUID = 7078687430023882834L;

    public JSONMetadataWriter(Writer writer, Locale locale) {
        this.writer = writer;
        this.locale = locale;
    }

    @Override
    public void write(String registryName, String metric) throws NoSuchRegistryException, NoSuchMetricException, IOException {
        try {
            this.serialize(this.getMetricsMetadataAsJson(registryName, metric));
        }
        catch (EmptyRegistryException emptyRegistryException) {
            FFDCFilter.processException((Throwable)emptyRegistryException, (String)"com.ibm.ws.microprofile.metrics.writer.JSONMetadataWriter", (String)"54", (Object)this, (Object[])new Object[]{registryName, metric});
        }
    }

    @Override
    public void write(String registryName) throws NoSuchRegistryException, EmptyRegistryException, IOException {
        this.serialize(this.getMetricsMetadataAsJson(registryName));
    }

    @Override
    @FFDCIgnore(value={EmptyRegistryException.class, NoSuchRegistryException.class})
    public void write() throws IOException {
        JSONObject payload = new JSONObject();
        for (String registryName : Constants.REGISTRY_NAMES_LIST) {
            try {
                payload.put((Object)registryName, (Object)this.getMetricsMetadataAsJson(registryName));
            }
            catch (NoSuchRegistryException noSuchRegistryException) {
            }
            catch (EmptyRegistryException emptyRegistryException) {}
        }
        this.serialize(payload);
    }

    protected JSONObject getMetricsMetadataAsJson(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        return this.getJsonFromMetricMetadataMap(Util.getMetricsMetadataAsMap(registryName), Util.getMetricsAsMap(registryName));
    }

    protected JSONObject getMetricsMetadataAsJson(String registryName, String metricName) throws NoSuchRegistryException, EmptyRegistryException, NoSuchMetricException {
        return this.getJsonFromMetricMetadataMap(Util.getMetricsMetadataAsMap(registryName, metricName), Util.getMetricsAsMap(registryName, metricName));
    }

    protected JSONObject getJsonFromMetricMetadataMap(Map<String, Metadata> metadataMap, Map<MetricID, Metric> metricMap) {
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Metadata> entry : metadataMap.entrySet()) {
            String metricName = entry.getKey();
            JSONObject metaDataJSONObject = this.getJsonFromObject(metadataMap.get(metricName));
            metaDataJSONObject.put((Object)"tags", (Object)this.getJsonArrayTags(metricMap, metricName));
            jsonObject.put((Object)metricName, (Object)metaDataJSONObject);
        }
        return jsonObject;
    }

    protected JSONArray getJsonArrayTags(Map<MetricID, Metric> metricMap, String metricName) {
        JSONArray jsonArray = new JSONArray();
        for (MetricID metricIDSet : metricMap.keySet()) {
            if (!metricIDSet.getName().equals(metricName)) continue;
            JSONArray metricTagJsonArray = new JSONArray();
            Map tagMap = metricIDSet.getTags();
            if (tagMap == null) continue;
            for (Map.Entry tagEntry : tagMap.entrySet()) {
                metricTagJsonArray.add((Object)((String)tagEntry.getKey() + "=" + (String)tagEntry.getValue()));
            }
            if (metricTagJsonArray.size() == 0) continue;
            jsonArray.add((Object)metricTagJsonArray);
        }
        return jsonArray;
    }

    protected JSONObject getJsonFromObject(Metadata metadata) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)this.sanitizeMetadata(metadata.getName()));
        jsonObject.put((Object)"displayName", (Object)this.sanitizeMetadata(metadata.getDisplayName()));
        String description = metadata.getDescription().isPresent() ? (String)metadata.getDescription().get() : "";
        jsonObject.put((Object)"description", (Object)Tr.formatMessage((TraceComponent)tc, (Locale)this.locale, (String)description, (Object[])new Object[0]));
        jsonObject.put((Object)"type", (Object)this.sanitizeMetadata(metadata.getType()));
        jsonObject.put((Object)"unit", (Object)this.sanitizeMetadata((String)metadata.getUnit().get()));
        return jsonObject;
    }

    protected String sanitizeMetadata(String s) {
        if (s == null || s.trim().isEmpty()) {
            return "";
        }
        return s;
    }

    protected String getJsonFromMap(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        StringBuilder tagList = new StringBuilder();
        String delimiter = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            tagList.append(delimiter).append(entry.getKey()).append('=').append(entry.getValue());
            delimiter = ",";
        }
        return tagList.toString();
    }

    protected void serialize(JSONObject payload) throws IOException {
        payload.serialize(this.writer);
    }
}

