/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.internal.helper;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.microprofile.metrics.exceptions.EmptyRegistryException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchMetricException;
import com.ibm.ws.microprofile.metrics.exceptions.NoSuchRegistryException;
import com.ibm.ws.microprofile.metrics23.helper.Util23;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.internal.impl.MetricRegistry30Impl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Util30
extends Util23 {
    private static final TraceComponent tc = Tr.register(Util30.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = 2596845240076050838L;

    public static Map<MetricID, Metric> getMetricsAsMap(String registryName, String metricName) throws NoSuchRegistryException, NoSuchMetricException, EmptyRegistryException {
        MetricRegistry registry = Util30.getRegistry(registryName);
        SortedSet metricIDSet = registry.getMetricIDs();
        HashMap<MetricID, Metric> returnMap = new HashMap<MetricID, Metric>();
        HashSet<MetricID> potentialMatches = new HashSet<MetricID>();
        for (MetricID tempmid : metricIDSet) {
            if (!tempmid.getName().equals(metricName)) continue;
            potentialMatches.add(tempmid);
        }
        if (metricIDSet.isEmpty()) {
            throw new EmptyRegistryException();
        }
        if (potentialMatches.size() == 0) {
            throw new NoSuchMetricException();
        }
        for (MetricID tmid : potentialMatches) {
            returnMap.put(tmid, registry.getMetric(tmid));
        }
        return returnMap;
    }

    public static Tag[] getCachedGlobalTags() {
        return MetricRegistry30Impl.getCachedGlobalTags();
    }

    public static Map<MetricID, Metric> getMetricsAsMap(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        MetricRegistry registry = Util30.getRegistry(registryName);
        Map metricMap = registry.getMetrics();
        if (metricMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        return metricMap;
    }

    public static Map<String, Metadata> getMetricsMetadataAsMap(String registryName) throws NoSuchRegistryException, EmptyRegistryException {
        MetricRegistry registry = Util30.getRegistry(registryName);
        HashMap<String, Metadata> metricMetadataMap = new HashMap<String, Metadata>();
        for (String name : registry.getNames()) {
            metricMetadataMap.put(name, registry.getMetadata(name));
        }
        if (metricMetadataMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        return metricMetadataMap;
    }

    public static Map<String, Metadata> getMetricsMetadataAsMap(String registryName, String metricName) throws NoSuchRegistryException, EmptyRegistryException, NoSuchMetricException {
        MetricRegistry registry = Util30.getRegistry(registryName);
        HashMap<String, Metadata> metricMetadataMap = new HashMap<String, Metadata>();
        for (String name : registry.getNames()) {
            metricMetadataMap.put(name, registry.getMetadata(name));
        }
        HashMap<String, Metadata> returnMap = new HashMap<String, Metadata>();
        if (metricMetadataMap.isEmpty()) {
            throw new EmptyRegistryException();
        }
        if (!metricMetadataMap.containsKey(metricName)) {
            throw new NoSuchMetricException();
        }
        returnMap.put(metricName, (Metadata)metricMetadataMap.get(metricName));
        return returnMap;
    }

    public static Map<String, Number> getTimerNumbers(Timer timer, String tags, double conversionFactor) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count" + tags, timer.getCount());
        results.put("elapsedTime" + tags, timer.getElapsedTime().toNanos());
        results.put("meanRate" + tags, timer.getMeanRate());
        results.put("oneMinRate" + tags, timer.getOneMinuteRate());
        results.put("fiveMinRate" + tags, timer.getFiveMinuteRate());
        results.put("fifteenMinRate" + tags, timer.getFifteenMinuteRate());
        results.put("max" + tags, (double)timer.getSnapshot().getMax() / conversionFactor);
        results.put("mean" + tags, timer.getSnapshot().getMean() / conversionFactor);
        results.put("min" + tags, (double)timer.getSnapshot().getMin() / conversionFactor);
        results.put("stddev" + tags, timer.getSnapshot().getStdDev() / conversionFactor);
        results.put("p50" + tags, timer.getSnapshot().getMedian() / conversionFactor);
        results.put("p75" + tags, timer.getSnapshot().get75thPercentile() / conversionFactor);
        results.put("p95" + tags, timer.getSnapshot().get95thPercentile() / conversionFactor);
        results.put("p98" + tags, timer.getSnapshot().get98thPercentile() / conversionFactor);
        results.put("p99" + tags, timer.getSnapshot().get99thPercentile() / conversionFactor);
        results.put("p999" + tags, timer.getSnapshot().get999thPercentile() / conversionFactor);
        return results;
    }

    public static Map<String, Number> getHistogramNumbers(Histogram histogram, String tags) {
        HashMap<String, Number> results = new HashMap<String, Number>();
        results.put("count" + tags, histogram.getCount());
        results.put("sum" + tags, histogram.getSum());
        results.put("max" + tags, histogram.getSnapshot().getMax());
        results.put("mean" + tags, histogram.getSnapshot().getMean());
        results.put("min" + tags, histogram.getSnapshot().getMin());
        results.put("stddev" + tags, histogram.getSnapshot().getStdDev());
        results.put("p50" + tags, histogram.getSnapshot().getMedian());
        results.put("p75" + tags, histogram.getSnapshot().get75thPercentile());
        results.put("p95" + tags, histogram.getSnapshot().get95thPercentile());
        results.put("p98" + tags, histogram.getSnapshot().get98thPercentile());
        results.put("p99" + tags, histogram.getSnapshot().get99thPercentile());
        results.put("p999" + tags, histogram.getSnapshot().get999thPercentile());
        return results;
    }

    public static Map<String, Object> getSimpleTimerNumbersAsObjects(SimpleTimer simpleTimer, String tags, double conversionFactor) {
        HashMap<String, Object> results = new HashMap<String, Object>();
        results.put("count" + tags, simpleTimer.getCount());
        results.put("elapsedTime" + tags, simpleTimer.getElapsedTime().toNanos());
        Double value = simpleTimer.getMaxTimeDuration() != null ? Double.valueOf((double)simpleTimer.getMaxTimeDuration().toNanos() * conversionFactor) : null;
        results.put("maxTimeDuration" + tags, value);
        value = simpleTimer.getMinTimeDuration() != null ? Double.valueOf((double)simpleTimer.getMinTimeDuration().toNanos() * conversionFactor) : null;
        results.put("minTimeDuration" + tags, value);
        return results;
    }
}

