/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import jakarta.el.ELException;
import jakarta.el.ELProcessor;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ELHelper {
    public static final String OBFUSCATED_STRING = "******";
    private static final TraceComponent tc = Tr.register(ELHelper.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private static final ThreadLocal<Map<String, String>> valuesMap = new ThreadLocal<Map<String, String>>(){
        static final long serialVersionUID = 3940849460821255429L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        protected Map<String, String> initialValue() {
            return new HashMap<String, String>(1);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.identitystore.ELHelper$1", 1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
        }
    };
    private static final String DEFFERRED_EXP_START = "#{";
    private static final String IMMEDIATE_EXP_START = "${";
    static final long serialVersionUID = -7621833726456676391L;

    @Trivial
    public Object evaluateElExpression(String expression) {
        return this.evaluateElExpression(expression, false);
    }

    @Trivial
    @ManualTrace
    protected Object evaluateElExpression(String expression, boolean mask) {
        String methodName = "evaluateElExpression";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"evaluateElExpression", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        EvalPrivilegedAction evalPrivilegedAction = new EvalPrivilegedAction(expression, mask);
        Object result = AccessController.doPrivileged(evalPrivilegedAction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"evaluateElExpression", result == null ? null : (mask ? OBFUSCATED_STRING : result));
        }
        return result;
    }

    @Trivial
    public static boolean isDeferredExpression(String expression) {
        return ELHelper.isDeferredExpression(expression, false);
    }

    @Trivial
    @ManualTrace
    static boolean isDeferredExpression(String expression, boolean mask) {
        String methodName = "isDeferredExpression";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isDeferredExpression", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        boolean result = false;
        if (expression != null) {
            boolean bl = result = expression.startsWith(DEFFERRED_EXP_START) && expression.endsWith("}");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isDeferredExpression", (Object)result);
        }
        return result;
    }

    @Trivial
    public static boolean isImmediateExpression(String expression) {
        return ELHelper.isImmediateExpression(expression, false);
    }

    @Trivial
    @ManualTrace
    static boolean isImmediateExpression(String expression, boolean mask) {
        String methodName = "isImmediateExpression";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isImmediateExpression", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        boolean result = false;
        if (expression != null) {
            boolean bl = result = expression.startsWith(IMMEDIATE_EXP_START) && expression.endsWith("}");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isImmediateExpression", (Object)result);
        }
        return result;
    }

    public Integer processInt(String name, String expression, int value, boolean immediateOnly) {
        Integer result = null;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + expression + "' for '" + name + "' evaluated to null.");
            }
            if (obj instanceof Number) {
                result = ((Number)obj).intValue();
                immediate = ELHelper.isImmediateExpression(expression);
            } else {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to an integer value.");
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    public Boolean processBoolean(String name, String expression, boolean value, boolean immediateOnly) {
        Boolean result = null;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + expression + "' for '" + name + "' evaluated to null.");
            }
            if (obj instanceof Boolean) {
                result = (Boolean)obj;
                immediate = ELHelper.isImmediateExpression(expression);
            } else {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a Boolean value.");
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    @FFDCIgnore(value={Exception.class})
    public <T> T processGeneric(String name, String expression, T value, boolean immediateOnly) {
        Object result = null;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + expression + "' for '" + name + "' evaluated to null.");
            }
            try {
                result = obj;
                immediate = ELHelper.isImmediateExpression(expression);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a " + value.getClass().getName() + " value.");
            }
        }
        return (T)(immediateOnly && !immediate ? null : result);
    }

    public String[] processStringArray(String name, String expression, String[] value, boolean immediateOnly) {
        String[] result = null;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + expression + "' for '" + name + "' evaluated to null.");
            }
            if (obj instanceof String[]) {
                result = (String[])obj;
                immediate = ELHelper.isImmediateExpression(expression);
            } else {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String[] value.");
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    protected LdapIdentityStoreDefinition.LdapSearchScope processLdapSearchScope(String name, String expression, LdapIdentityStoreDefinition.LdapSearchScope value, boolean immediateOnly) {
        LdapIdentityStoreDefinition.LdapSearchScope result;
        boolean immediate = false;
        if (expression.isEmpty()) {
            result = value;
        } else {
            Object obj = this.evaluateElExpression(expression);
            if (obj instanceof LdapIdentityStoreDefinition.LdapSearchScope) {
                result = (LdapIdentityStoreDefinition.LdapSearchScope)obj;
                immediate = ELHelper.isImmediateExpression(expression);
            } else if (obj instanceof String) {
                result = LdapIdentityStoreDefinition.LdapSearchScope.valueOf((String)((String)obj).toUpperCase());
                immediate = ELHelper.isImmediateExpression(expression);
            } else {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to an LdapSearchScope type.");
            }
        }
        return immediateOnly && !immediate ? null : result;
    }

    @Trivial
    public String processString(String name, String expression, boolean immediateOnly) {
        return this.processString(name, expression, immediateOnly, false);
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    public String processString(String name, String expression, boolean immediateOnly, boolean mask) {
        String finalResult;
        String result;
        String methodName = "processString";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processString", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
        }
        boolean immediate = false;
        try {
            Object obj = this.evaluateElExpression(expression, mask);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "' evaluated to null.");
            }
            if (!(obj instanceof String)) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String value.");
            }
            result = (String)obj;
            immediate = ELHelper.isImmediateExpression(expression, mask);
        }
        catch (ELException e) {
            result = expression;
            immediate = true;
        }
        String string = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processString", finalResult == null ? null : (mask ? OBFUSCATED_STRING : finalResult));
        }
        return finalResult;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    public List<String> processStringOrStringArray(String name, String expression, boolean immediateOnly, boolean mask) {
        ArrayList<String> finalResult;
        boolean immediate;
        ArrayList<String> result;
        block15: {
            String methodName = "processStringOrStringArray";
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"processStringOrStringArray", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
            }
            result = new ArrayList<String>(1);
            immediate = false;
            try {
                Object obj = this.evaluateElExpression(expression, mask);
                if (obj == null) {
                    throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "' evaluated to null.");
                }
                if (obj instanceof String) {
                    result.add((String)obj);
                    immediate = ELHelper.isImmediateExpression(expression, mask);
                    break block15;
                }
                if (obj instanceof String[]) {
                    String[] elInnerArray;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processStringOrStringArray", (Object[])new Object[]{"The expression '" + (mask ? OBFUSCATED_STRING : expression) + "' evaluated to String array."});
                    }
                    for (String innerString : elInnerArray = (String[])obj) {
                        try {
                            Object innerEvaluatedObj = this.evaluateElExpression(innerString, mask);
                            if (innerEvaluatedObj == null) {
                                throw new IllegalArgumentException("Inner EL expression '" + (mask ? OBFUSCATED_STRING : innerString) + "' for '" + name + "' evaluated to null.");
                            }
                            if (!(innerEvaluatedObj instanceof String)) {
                                boolean warningAboutNested = false;
                                if (innerEvaluatedObj instanceof String[]) {
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"processStringOrStringArray", (Object[])new Object[]{"Currently not recursively evaluating String arrays more than 1 level."});
                                    }
                                    warningAboutNested = true;
                                }
                                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String value." + (warningAboutNested ? " Nested String arrays detected." : ""));
                            }
                            result.add((String)innerEvaluatedObj);
                            immediate = ELHelper.isImmediateExpression(expression, mask);
                        }
                        catch (ELException ee) {
                            result.add(innerString);
                            immediate = true;
                        }
                    }
                    break block15;
                }
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String or String array value.");
            }
            catch (ELException e) {
                result.add(expression);
                immediate = true;
            }
        }
        ArrayList<String> arrayList = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStringOrStringArray", finalResult == null ? null : (mask ? OBFUSCATED_STRING : finalResult));
        }
        return finalResult;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    public String[] processStringArray(String name, String expression, boolean immediateOnly, boolean mask) {
        String[] finalResult;
        String[] result;
        String methodName = "processStringArray";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStringArray", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
        }
        boolean immediate = false;
        try {
            Object obj = this.evaluateElExpression(expression, mask);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "' evaluated to null.");
            }
            if (!(obj instanceof String[])) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String value.");
            }
            result = (String[])obj;
            immediate = ELHelper.isImmediateExpression(expression, mask);
        }
        catch (ELException e) {
            throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a String[] value.");
        }
        Object object = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStringArray", finalResult == null ? null : (mask ? "******" : finalResult));
        }
        return finalResult;
    }

    @Trivial
    @ManualTrace
    @FFDCIgnore(value={ELException.class})
    protected Stream<String> processStringStream(String name, String expression, boolean immediateOnly, boolean mask) {
        Stream finalResult;
        Stream result;
        String methodName = "processStringStream";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processStringStream", (Object[])new Object[]{name, expression == null ? null : (mask ? OBFUSCATED_STRING : expression), immediateOnly, mask});
        }
        boolean immediate = false;
        try {
            Object obj = this.evaluateElExpression(expression, mask);
            if (obj == null) {
                throw new IllegalArgumentException("EL expression '" + (mask ? OBFUSCATED_STRING : expression) + "' for '" + name + "' evaluated to null.");
            }
            if (!(obj instanceof Stream)) {
                throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a Stream<String> value.");
            }
            result = (Stream)obj;
            immediate = ELHelper.isImmediateExpression(expression, mask);
        }
        catch (ELException e) {
            throw new IllegalArgumentException("Expected '" + name + "' to evaluate to a Stream<String> value.");
        }
        Stream stream = finalResult = immediateOnly && !immediate ? null : result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processStringStream", finalResult == null ? null : (mask ? OBFUSCATED_STRING : finalResult));
        }
        return finalResult;
    }

    protected Set<IdentityStore.ValidationType> processUseFor(String useForExpression, IdentityStore.ValidationType[] useFor, boolean immediateOnly) {
        EnumSet<IdentityStore.ValidationType> result = null;
        boolean immediate = false;
        if (useForExpression.isEmpty()) {
            result = EnumSet.copyOf(Arrays.asList(useFor));
        } else {
            IdentityStore.ValidationType[] types;
            Object obj = this.evaluateElExpression(useForExpression);
            if (obj instanceof IdentityStore.ValidationType[]) {
                Tr.debug((TraceComponent)tc, (String)("processUseFor (validationtype): " + obj), (Object[])new Object[0]);
                types = (IdentityStore.ValidationType[])obj;
                result = EnumSet.copyOf(Arrays.asList(types));
                immediate = ELHelper.isImmediateExpression(useForExpression);
            } else if (obj instanceof String) {
                Tr.debug((TraceComponent)tc, (String)("processUseFor (String): " + (String)obj), (Object[])new Object[0]);
                types = new IdentityStore.ValidationType[2];
                String validation = ((String)obj).toLowerCase();
                if (validation.contains("validate")) {
                    types[0] = IdentityStore.ValidationType.VALIDATE;
                }
                if (validation.contains("provide_groups")) {
                    types[1] = IdentityStore.ValidationType.PROVIDE_GROUPS;
                }
                result = EnumSet.copyOf(Arrays.asList(types));
                immediate = ELHelper.isImmediateExpression(useForExpression);
            } else {
                Tr.debug((TraceComponent)tc, (String)"processUseFor obj was not an instance of string or ValidationType[]", (Object[])new Object[0]);
                throw new IllegalArgumentException("Expected 'useForExpression' to evaluate to an array of ValidationType.");
            }
        }
        if (result == null || result.isEmpty()) {
            Tr.debug((TraceComponent)tc, (String)"processUseFor result is empty or null", (Object[])new Object[0]);
            throw new IllegalArgumentException("The identity store must be configured with at least one ValidationType.");
        }
        for (IdentityStore.ValidationType v : result) {
            Tr.debug((TraceComponent)tc, (String)("processUseFor result: " + v), (Object[])new Object[0]);
        }
        return immediateOnly && !immediate ? null : Collections.unmodifiableSet(result);
    }

    @Trivial
    static String removeBrackets(String expression) {
        return ELHelper.removeBrackets(expression, false);
    }

    @Trivial
    @ManualTrace
    static String removeBrackets(String expression, boolean mask) {
        String methodName = "removeBrackets";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeBrackets", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        if (((expression = expression.trim()).startsWith(IMMEDIATE_EXP_START) || expression.startsWith(DEFFERRED_EXP_START)) && expression.endsWith("}")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeBrackets", expression == null ? null : (mask ? OBFUSCATED_STRING : expression));
        }
        return expression;
    }

    @Trivial
    @ManualTrace
    static String[] checkAndSplitBeforeEvaluation(String expression, boolean mask) {
        String methodName = "checkAndSplitBeforeEvaluation";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"checkAndSplitBeforeEvaluation", (Object[])new Object[]{expression == null ? null : (mask ? OBFUSCATED_STRING : expression), mask});
        }
        Object[] expressionStrings = null;
        int immExp = expression.indexOf(IMMEDIATE_EXP_START);
        int defExp = expression.indexOf(DEFFERRED_EXP_START);
        if (defExp == -1 && immExp == -1) {
            return null;
        }
        String openBracketToUse = IMMEDIATE_EXP_START;
        int starterIndex = immExp;
        if (defExp >= 0) {
            openBracketToUse = DEFFERRED_EXP_START;
            starterIndex = defExp;
        }
        if (expression.startsWith(openBracketToUse) && expression.endsWith("}") && starterIndex == expression.lastIndexOf(openBracketToUse)) {
            return null;
        }
        ArrayList<String> tempArraySplitStrings = new ArrayList<String>(3);
        String stringToSplit = expression;
        String lastSplit = "";
        while (!stringToSplit.isEmpty()) {
            lastSplit = stringToSplit;
            if (stringToSplit.startsWith(openBracketToUse)) {
                int exprEnd = stringToSplit.indexOf("}");
                if (exprEnd == -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"checkAndSplitBeforeEvaluation", (Object[])new Object[]{"Mismatched expression brackets, will use the rest of the string: " + (mask ? OBFUSCATED_STRING : stringToSplit)});
                    }
                    exprEnd = stringToSplit.length();
                } else {
                    ++exprEnd;
                }
                tempArraySplitStrings.add(stringToSplit.substring(0, exprEnd));
                stringToSplit = stringToSplit.substring(exprEnd);
            } else {
                int end = stringToSplit.contains(openBracketToUse) ? stringToSplit.indexOf(openBracketToUse) : stringToSplit.length();
                tempArraySplitStrings.add(stringToSplit.substring(0, end));
                stringToSplit = stringToSplit.substring(end);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAndSplitBeforeEvaluation", (Object[])new Object[]{"String left to split: " + (mask ? OBFUSCATED_STRING : stringToSplit) + ", Array of splits:" + (mask ? OBFUSCATED_STRING : tempArraySplitStrings)});
            }
            if (!lastSplit.equals(stringToSplit)) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"checkAndSplitBeforeEvaluation", (Object[])new Object[]{"Splitting logic failed, ended loop with the same string as started with: " + (mask ? OBFUSCATED_STRING : stringToSplit)});
            }
            tempArraySplitStrings.add(stringToSplit);
            break;
        }
        expressionStrings = tempArraySplitStrings.toArray(new String[tempArraySplitStrings.size()]);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"checkAndSplitBeforeEvaluation", expressionStrings == null ? null : (mask ? OBFUSCATED_STRING : Arrays.toString(expressionStrings)));
        }
        return expressionStrings;
    }

    @Trivial
    public void addValue(String expression, String value, boolean mask) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"addValue", (Object[])new Object[]{expression + ":" + (mask ? OBFUSCATED_STRING : value)});
        }
        valuesMap.get().put(expression, value);
    }

    public void removeValue(String expression) {
        valuesMap.get().remove(expression);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class EvalPrivilegedAction
    implements PrivilegedAction<Object> {
        private final String expression;
        private final boolean mask;
        static final long serialVersionUID = 5380949017343508182L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public EvalPrivilegedAction(String expression, boolean mask) {
            this.expression = expression;
            this.mask = mask;
        }

        @Override
        @Trivial
        public Object run() {
            ELProcessor elProc = CDIHelper.getELProcessor();
            String[] expressionStrings = ELHelper.checkAndSplitBeforeEvaluation(this.expression, this.mask);
            if (!((Map)valuesMap.get()).isEmpty()) {
                Map variables = (Map)valuesMap.get();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"EvalPrivilegedAction", (Object[])new Object[]{"Found threadLocal values to set on the ELProcessor: " + (this.mask ? ELHelper.OBFUSCATED_STRING : variables)});
                }
                for (Map.Entry entry : variables.entrySet()) {
                    elProc.setValue((String)entry.getKey(), entry.getValue());
                }
            }
            if (expressionStrings == null) {
                return elProc.eval(ELHelper.removeBrackets(this.expression, this.mask));
            }
            StringBuffer stb = new StringBuffer();
            for (String expr : expressionStrings) {
                if (ELHelper.isDeferredExpression(expr, this.mask) || ELHelper.isImmediateExpression(expr)) {
                    stb.append(elProc.eval(ELHelper.removeBrackets(expr, this.mask)).toString());
                    continue;
                }
                stb.append(expr);
            }
            return stb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.identitystore.ELHelper$EvalPrivilegedAction", EvalPrivilegedAction.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
        }
    }
}

