/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.CDIHelper;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

@Default
@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class IdentityStoreHandlerImpl
implements IdentityStoreHandler {
    private static final TraceComponent tc = Tr.register(IdentityStoreHandlerImpl.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private final ConcurrentHashMap<String, Set<IdentityStore>> identityStoreMap = new ConcurrentHashMap();
    private static final Comparator<IdentityStore> priorityComparator = new Comparator<IdentityStore>(){
        static final long serialVersionUID = 881258636990031723L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        public int compare(IdentityStore o1, IdentityStore o2) {
            int result = 1;
            if (o1.equals(o2)) {
                result = 0;
            } else if (o1.priority() < o2.priority()) {
                result = -1;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"compare", (Object[])new Object[]{o1, o2, result, this});
            }
            return result;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.identitystore.IdentityStoreHandlerImpl$2", 2.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
        }
    };
    static final long serialVersionUID = -5760572175591365065L;

    public CredentialValidationResult validate(Credential credential) {
        return this.validate(this.getIdentityStores(this.identityStoreMap), credential);
    }

    public CredentialValidationResult validate(Set<IdentityStore> identityStores, Credential credential) {
        CredentialValidationResult firstInvalid = null;
        CredentialValidationResult result = CredentialValidationResult.NOT_VALIDATED_RESULT;
        boolean supportGroups = false;
        boolean isValidated = false;
        if (!identityStores.isEmpty()) {
            for (IdentityStore is : identityStores) {
                if (!is.validationTypes().contains(IdentityStore.ValidationType.VALIDATE)) continue;
                isValidated = true;
                result = is.validate(credential);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("validation status : " + result.getStatus() + ", identityStore : " + is), (Object[])new Object[0]);
                }
                if (result.getStatus() == CredentialValidationResult.Status.VALID) {
                    if (!is.validationTypes().contains(IdentityStore.ValidationType.PROVIDE_GROUPS)) break;
                    supportGroups = true;
                    break;
                }
                if (result.getStatus() != CredentialValidationResult.Status.INVALID || firstInvalid != null) continue;
                firstInvalid = result;
            }
            if (result != null && result.getStatus() == CredentialValidationResult.Status.VALID) {
                Set<String> groups = this.getGroups(identityStores, result, supportGroups);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IdentityStore ID : " + result.getIdentityStoreId() + ", CallerPrincipal : " + (result.getCallerPrincipal() != null ? result.getCallerPrincipal().getName() : "null") + ", CallerDN : " + result.getCallerDn() + ", CallerUniqueId : " + result.getCallerUniqueId() + ", Groups : " + groups), (Object[])new Object[0]);
                }
                result = new CredentialValidationResult(result.getIdentityStoreId(), result.getCallerPrincipal(), result.getCallerDn(), result.getCallerUniqueId(), groups);
            } else if (firstInvalid != null) {
                result = firstInvalid;
            } else if (!isValidated) {
                Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_NO_VALIDATION", (Object[])new Object[0]);
                result = CredentialValidationResult.NOT_VALIDATED_RESULT;
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No IdentityStore bean is registered.", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validation status : " + result.getStatus()), (Object[])new Object[0]);
        }
        return result;
    }

    protected Set<String> getGroups(Set<IdentityStore> identityStores, CredentialValidationResult result, boolean supportGroups) {
        Set groups;
        HashSet<String> combinedGroups = new HashSet<String>();
        if (supportGroups && (groups = result.getCallerGroups()) != null && !groups.isEmpty()) {
            combinedGroups.addAll(groups);
        }
        for (IdentityStore is : identityStores) {
            Set validationTypes = is.validationTypes();
            if (validationTypes == null) continue;
            boolean isProvideGroups = validationTypes.contains(IdentityStore.ValidationType.PROVIDE_GROUPS);
            boolean isValidate = validationTypes.contains(IdentityStore.ValidationType.VALIDATE);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IdentityStore : " + is + ", PROVIDE_GROUPS : " + isProvideGroups + ", VALIDATE : " + isValidate), (Object[])new Object[0]);
            }
            if (!isProvideGroups || isValidate) continue;
            Set<String> extraGroups = this.getGroups(is, result);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IdentityStore : " + is + ", groups : " + extraGroups), (Object[])new Object[0]);
            }
            if (extraGroups == null || extraGroups.isEmpty()) continue;
            combinedGroups.addAll(extraGroups);
        }
        return combinedGroups;
    }

    private Set<String> getGroups(final IdentityStore is, final CredentialValidationResult result) {
        PrivilegedAction<Set<String>> action = new PrivilegedAction<Set<String>>(){
            static final long serialVersionUID = 2582177789860945714L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Set<String> run() {
                return is.getCallerGroups(result);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.identitystore.IdentityStoreHandlerImpl$1", 1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
            }
        };
        return AccessController.doPrivileged(action);
    }

    protected Set<IdentityStore> getIdentityStores(ConcurrentHashMap<String, Set<IdentityStore>> identityStoreMap) {
        String moduleName = this.getModuleName();
        Set<IdentityStore> stores = identityStoreMap.get(moduleName);
        if (stores == null) {
            stores = new TreeSet<IdentityStore>(priorityComparator);
            this.scanIdentityStores(stores);
            identityStoreMap.put(moduleName, stores);
        } else if (stores.size() > 1) {
            Set<IdentityStore> oldStores = stores;
            stores = new TreeSet<IdentityStore>(priorityComparator);
            stores.addAll(oldStores);
        }
        return stores;
    }

    protected void scanIdentityStores(Set<IdentityStore> identityStores) {
        Instance identityStoreInstances = null;
        CDI cdi = this.getCDI();
        if (cdi != null) {
            identityStoreInstances = cdi.select(IdentityStore.class, new Annotation[0]);
        }
        if (identityStoreInstances != null) {
            for (IdentityStore identityStore : identityStoreInstances) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IdentityStore from the CDI: " + identityStore + ", validationTypes : " + identityStore.validationTypes() + ", priority : " + identityStore.priority()), (Object[])new Object[0]);
                }
                identityStores.add(identityStore);
            }
        }
        if (!cdi.getBeanManager().equals(CDIHelper.getBeanManager())) {
            for (IdentityStore identityStore : CDIHelper.getBeansFromCurrentModule(IdentityStore.class)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("IdentityStore from module BeanManager: " + identityStore + ", validationTypes : " + identityStore.validationTypes() + ", priority : " + identityStore.priority()), (Object[])new Object[0]);
                }
                identityStores.add(identityStore);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Number of identityStore : " + identityStores.size()), (Object[])new Object[0]);
        }
    }

    protected String getModuleName() {
        return ModulePropertiesUtils.getInstance().getJ2EEModuleName();
    }

    protected void clearIdentityStoreMap() {
        this.identityStoreMap.clear();
    }

    protected CDI getCDI() {
        return CDIHelper.getCDI();
    }
}

