/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.identitystore;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.ELHelper;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.LdapIdentityStoreDefinition;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class LdapIdentityStoreDefinitionWrapper {
    private static final TraceComponent tc = Tr.register(LdapIdentityStoreDefinitionWrapper.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private final String bindDn;
    private final ProtectedString bindDnPassword;
    private final String callerBaseDn;
    private final String callerNameAttribute;
    private final String callerSearchBase;
    private final String callerSearchFilter;
    private final LdapIdentityStoreDefinition.LdapSearchScope callerSearchScope;
    private final String groupMemberAttribute;
    private final String groupMemberOfAttribute;
    private final String groupNameAttribute;
    private final String groupSearchBase;
    private final String groupSearchFilter;
    private final LdapIdentityStoreDefinition.LdapSearchScope groupSearchScope;
    private final LdapIdentityStoreDefinition idStoreDefinition;
    private final Integer maxResults;
    private final Integer priority;
    private final Integer readTimeout;
    private final String url;
    private final Set<IdentityStore.ValidationType> useFor;
    private final ELHelper elHelper;
    static final long serialVersionUID = 5636214725278183944L;

    LdapIdentityStoreDefinitionWrapper(LdapIdentityStoreDefinition idStoreDefinition) {
        if (idStoreDefinition == null) {
            throw new IllegalArgumentException("The LdapIdentityStoreDefinition cannot be null.");
        }
        this.idStoreDefinition = idStoreDefinition;
        this.elHelper = new ELHelper();
        this.bindDn = this.evaluateBindDn(true);
        this.bindDnPassword = this.evaluateBindDnPassword(true);
        this.callerBaseDn = this.evaluateCallerBaseDn(true);
        this.callerNameAttribute = this.evaluateCallerNameAttribute(true);
        this.callerSearchBase = this.evaluateCallerSearchBase(true);
        this.callerSearchFilter = this.evaluateCallerSearchFilter(true);
        this.callerSearchScope = this.evaluateCallerSearchScope(true);
        this.groupMemberAttribute = this.evaluateGroupMemberAttribute(true);
        this.groupMemberOfAttribute = this.evaluateGroupMemberOfAttribute(true);
        this.groupNameAttribute = this.evaluateGroupNameAttribute(true);
        this.groupSearchBase = this.evaluateGroupSearchBase(true);
        this.groupSearchFilter = this.evaluateGroupSearchFilter(true);
        this.groupSearchScope = this.evaluateGroupSearchScope(true);
        this.maxResults = this.evaluateMaxResults(true);
        this.priority = this.evaluatePriority(true);
        this.readTimeout = this.evaluateReadTimeout(true);
        this.url = this.evaluateUrl(true);
        this.useFor = this.evaluateUseFor(true);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateBindDn(boolean immediateOnly) {
        String bindDn = this.idStoreDefinition.bindDn();
        try {
            return this.elHelper.processString("bindDn", bindDn, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(bindDn)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateBindDn", (Object[])new Object[]{"Returning null since bindDn is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"bindDn", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private ProtectedString evaluateBindDnPassword(boolean immediateOnly) {
        String result;
        String bindDnPassword = this.idStoreDefinition.bindDnPassword();
        try {
            result = this.elHelper.processString("bindDnPassword", bindDnPassword, immediateOnly, true);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(bindDnPassword)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateBindDnPassword", (Object[])new Object[]{"Returning null since bindDnPassword is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"bindDnPassword", ""});
            }
            result = "";
        }
        return result == null ? null : new ProtectedString(result.toCharArray());
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerBaseDn(boolean immediateOnly) {
        String callerBaseDn = this.idStoreDefinition.callerBaseDn();
        try {
            return this.elHelper.processString("callerBaseDn", callerBaseDn, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(callerBaseDn)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateCallerBaseDn", (Object[])new Object[]{"Returning null since callerBaseDn is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerBaseDn", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerNameAttribute(boolean immediateOnly) {
        String callerNameAttribute = this.idStoreDefinition.callerNameAttribute();
        try {
            return this.elHelper.processString("callerNameAttribute", callerNameAttribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(callerNameAttribute)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateCallerNameAttribute", (Object[])new Object[]{"Returning null since callerNameAttribute is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerNameAttribute", "uid"});
            }
            return "uid";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerSearchBase(boolean immediateOnly) {
        String callerSearchBase = this.idStoreDefinition.callerSearchBase();
        try {
            return this.elHelper.processString("callerSearchBase", callerSearchBase, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(callerSearchBase)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateCallerSearchBase", (Object[])new Object[]{"Returning null since callerSearchBase is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerSearchBase", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateCallerSearchFilter(boolean immediateOnly) {
        String callerSearchFilter = this.idStoreDefinition.callerSearchFilter();
        try {
            return this.elHelper.processString("callerSearchFilter", callerSearchFilter, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(callerSearchFilter)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateCallerSearchFilter", (Object[])new Object[]{"Returning null since callerSearchFilter is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerSearchFilter", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private LdapIdentityStoreDefinition.LdapSearchScope evaluateCallerSearchScope(boolean immediateOnly) {
        String callerSearchScopeExpression = this.idStoreDefinition.callerSearchScopeExpression();
        try {
            return this.elHelper.processLdapSearchScope("callerSearchScopeExpression", callerSearchScopeExpression, this.idStoreDefinition.callerSearchScope(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(callerSearchScopeExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateCallerSearchScope", (Object[])new Object[]{"Returning null since callerSearchScopeExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"callerSearchScope/callerSearchScopeExpression", "LdapSearchScope.SUBTREE"});
            }
            return LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupMemberAttribute(boolean immediateOnly) {
        String groupMemberAttribute = this.idStoreDefinition.groupMemberAttribute();
        try {
            return this.elHelper.processString("groupMemberAttribute", groupMemberAttribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupMemberAttribute)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupMemberAttribute", (Object[])new Object[]{"Returning null since groupMemberAttribute is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupMemberAttribute", "member"});
            }
            return "member";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupMemberOfAttribute(boolean immediateOnly) {
        String groupMemberOfAttribute = this.idStoreDefinition.groupMemberOfAttribute();
        try {
            return this.elHelper.processString("groupMemberOfAttribute", groupMemberOfAttribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupMemberOfAttribute)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupMemberOfAttribute", (Object[])new Object[]{"Returning null since groupMemberOfAttribute is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupMemberOfAttribute", "memberOf"});
            }
            return "memberOf";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupNameAttribute(boolean immediateOnly) {
        String groupNameAttribute = this.idStoreDefinition.groupNameAttribute();
        try {
            return this.elHelper.processString("groupNameAttribute", groupNameAttribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupNameAttribute)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupNameAttribute", (Object[])new Object[]{"Returning null since groupNameAttribute is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupNameAttribute", "cn"});
            }
            return "cn";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupSearchBase(boolean immediateOnly) {
        String groupSearchBase = this.idStoreDefinition.groupSearchBase();
        try {
            return this.elHelper.processString("groupSearchBase", groupSearchBase, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupSearchBase)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupSearchBase", (Object[])new Object[]{"Returning null since groupSearchBase is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupSearchBase", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateGroupSearchFilter(boolean immediateOnly) {
        String groupSearchFilter = this.idStoreDefinition.groupSearchFilter();
        try {
            return this.elHelper.processString("groupSearchFilter", groupSearchFilter, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupSearchFilter)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupSearchFilter", (Object[])new Object[]{"Returning null since groupSearchFilter is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupSearchFilter", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private LdapIdentityStoreDefinition.LdapSearchScope evaluateGroupSearchScope(boolean immediateOnly) {
        String groupSearchScopeExpression = this.idStoreDefinition.groupSearchScopeExpression();
        try {
            return this.elHelper.processLdapSearchScope("groupSearchScopeExpression", groupSearchScopeExpression, this.idStoreDefinition.groupSearchScope(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(groupSearchScopeExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateGroupSearchScope", (Object[])new Object[]{"Returning null since groupSearchScopeExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"groupSearchScope/groupSearchScopeExpression", "LdapSearchScope.SUBTREE"});
            }
            return LdapIdentityStoreDefinition.LdapSearchScope.SUBTREE;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluateMaxResults(boolean immediateOnly) {
        String maxResultsExpression = this.idStoreDefinition.maxResultsExpression();
        try {
            return this.elHelper.processInt("maxResultsExpression", maxResultsExpression, this.idStoreDefinition.maxResults(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(maxResultsExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateMaxResults", (Object[])new Object[]{"Returning null since maxResultsExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"maxResults/maxResultsExpression", "1000"});
            }
            return 1000;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluatePriority(boolean immediateOnly) {
        String priorityExpression = this.idStoreDefinition.priorityExpression();
        try {
            return this.elHelper.processInt("priorityExpression", priorityExpression, this.idStoreDefinition.priority(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(priorityExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluatePriority", (Object[])new Object[]{"Returning null since priorityExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"priority/priorityExpression", "80"});
            }
            return 80;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Integer evaluateReadTimeout(boolean immediateOnly) {
        String readTimeoutExpression = this.idStoreDefinition.readTimeoutExpression();
        try {
            return this.elHelper.processInt("readTimeoutExpression", readTimeoutExpression, this.idStoreDefinition.readTimeout(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(readTimeoutExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateReadTimeout", (Object[])new Object[]{"Returning null since readTimeoutExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"readTimeout/readTimeoutExpression", "0"});
            }
            return 0;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private String evaluateUrl(boolean immediateOnly) {
        String url = this.idStoreDefinition.url();
        try {
            return this.elHelper.processString("url", url, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(url)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateUrl", (Object[])new Object[]{"Returning null since url is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"url", ""});
            }
            return "";
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    private Set<IdentityStore.ValidationType> evaluateUseFor(boolean immediateOnly) {
        String useForExpression = this.idStoreDefinition.useForExpression();
        try {
            return this.elHelper.processUseFor(useForExpression, this.idStoreDefinition.useFor(), immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression(useForExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"evaluateUseFor", (Object[])new Object[]{"Returning null since useForExpression is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            HashSet<IdentityStore.ValidationType> values = new HashSet<IdentityStore.ValidationType>();
            values.add(IdentityStore.ValidationType.PROVIDE_GROUPS);
            values.add(IdentityStore.ValidationType.VALIDATE);
            if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"JAVAEESEC_WARNING_IDSTORE_CONFIG", (Object[])new Object[]{"useFor/useForExpression", values});
            }
            return values;
        }
    }

    String getBindDn() {
        return this.bindDn != null ? this.bindDn : this.evaluateBindDn(false);
    }

    ProtectedString getBindDnPassword() {
        return this.bindDnPassword != null ? this.bindDnPassword : this.evaluateBindDnPassword(false);
    }

    String getCallerBaseDn() {
        return this.callerBaseDn != null ? this.callerBaseDn : this.evaluateCallerBaseDn(false);
    }

    String getCallerNameAttribute() {
        return this.callerNameAttribute != null ? this.callerNameAttribute : this.evaluateCallerNameAttribute(false);
    }

    String getCallerSearchBase() {
        return this.callerSearchBase != null ? this.callerSearchBase : this.evaluateCallerSearchBase(false);
    }

    String getCallerSearchFilter() {
        return this.callerSearchFilter != null ? this.callerSearchFilter : this.evaluateCallerSearchFilter(false);
    }

    LdapIdentityStoreDefinition.LdapSearchScope getCallerSearchScope() {
        return this.callerSearchScope != null ? this.callerSearchScope : this.evaluateCallerSearchScope(false);
    }

    String getGroupMemberAttribute() {
        return this.groupMemberAttribute != null ? this.groupMemberAttribute : this.evaluateGroupMemberAttribute(false);
    }

    String getGroupMemberOfAttribute() {
        return this.groupMemberOfAttribute != null ? this.groupMemberOfAttribute : this.evaluateGroupMemberOfAttribute(false);
    }

    String getGroupNameAttribute() {
        return this.groupNameAttribute != null ? this.groupNameAttribute : this.evaluateGroupNameAttribute(false);
    }

    String getGroupSearchBase() {
        return this.groupSearchBase != null ? this.groupSearchBase : this.evaluateGroupSearchBase(false);
    }

    String getGroupSearchFilter() {
        return this.groupSearchFilter != null ? this.groupSearchFilter : this.evaluateGroupSearchFilter(false);
    }

    LdapIdentityStoreDefinition.LdapSearchScope getGroupSearchScope() {
        return this.groupSearchScope != null ? this.groupSearchScope : this.evaluateGroupSearchScope(false);
    }

    int getMaxResults() {
        return this.maxResults != null ? this.maxResults : this.evaluateMaxResults(false);
    }

    int getPriority() {
        return this.priority != null ? this.priority : this.evaluatePriority(false);
    }

    int getReadTimeout() {
        return this.readTimeout != null ? this.readTimeout : this.evaluateReadTimeout(false);
    }

    String getUrl() {
        return this.url != null ? this.url : this.evaluateUrl(false);
    }

    Set<IdentityStore.ValidationType> getUseFor() {
        return this.useFor != null ? this.useFor : this.evaluateUseFor(false);
    }

    private boolean isCTS() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){
                static final long serialVersionUID = -3362919483554635238L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Boolean run() throws SecurityException, NullPointerException, IllegalArgumentException {
                    String result = System.getProperty("cts");
                    return result != null && result.equalsIgnoreCase("true");
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStoreDefinitionWrapper$1", 1.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.javaeesec.identitystore.LdapIdentityStoreDefinitionWrapper", (String)"961", (Object)this, (Object[])new Object[0]);
            return false;
        }
    }
}

