/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMessageImpl;
import com.ibm.ws.sib.api.jms.impl.JmsSessionImpl;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.StreamMessage;
import java.io.UnsupportedEncodingException;

public class JmsStreamMessageImpl
extends JmsMessageImpl
implements StreamMessage {
    private static final long serialVersionUID = 3222131330774615635L;
    private JsJmsStreamMessage streamMsg;
    private boolean partReadBytesElement = false;
    private byte[] bytesElement = null;
    private int bytesElementOffset;
    private static TraceComponent tc = SibTr.register(JmsStreamMessageImpl.class, (String)"SIBJms_External", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");

    public JmsStreamMessageImpl() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsStreamMessageImpl");
        }
        this.messageClass = "jms_stream";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsStreamMessageImpl");
        }
    }

    JmsStreamMessageImpl(JsJmsStreamMessage newMsg, JmsSessionImpl newSess) {
        super((JsJmsMessage)newMsg, newSess);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsStreamMessageImpl", (Object)new Object[]{newMsg, newSess});
        }
        this.streamMsg = newMsg;
        this.messageClass = "jms_stream";
        this.streamMsg.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsStreamMessageImpl");
        }
    }

    JmsStreamMessageImpl(StreamMessage streamMessage) throws JMSException {
        super((Message)streamMessage);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"JmsStreamMessageImpl", (Object)streamMessage);
        }
        this.messageClass = "jms_stream";
        streamMessage.reset();
        try {
            while (true) {
                this.writeObject(streamMessage.readObject());
            }
        }
        catch (JMSException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"JmsStreamMessageImpl");
            }
            return;
        }
    }

    public boolean readBoolean() throws JMSException {
        boolean result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readBoolean");
        }
        Object nextObj = this.getNextField("readBoolean");
        try {
            result = JmsMessageImpl.parseBoolean(nextObj, "");
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readBoolean", (Object)result);
        }
        return result;
    }

    public byte readByte() throws JMSException {
        byte result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readByte");
        }
        Object nextObj = this.getNextField("readByte");
        try {
            result = JmsMessageImpl.parseByte(nextObj, "");
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readByte", (Object)result);
        }
        return result;
    }

    public short readShort() throws JMSException {
        short result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readShort");
        }
        Object nextObj = this.getNextField("readShort");
        try {
            result = JmsMessageImpl.parseShort(nextObj, "");
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readShort", (Object)result);
        }
        return result;
    }

    public char readChar() throws JMSException {
        Object nextObj;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readChar");
        }
        if ((nextObj = this.getNextField("readChar")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null found");
            }
            throw (NullPointerException)JmsErrorUtils.newThrowable(NullPointerException.class, "NULL_CHAR_CWSIA0164", null, tc);
        }
        if (!(nextObj instanceof Character)) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"non-char item found");
            }
            throw JmsStreamMessageImpl.newBadConvertException(nextObj, "", "Character", tc);
        }
        char result = ((Character)nextObj).charValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readChar", (Object)Character.valueOf(result));
        }
        return result;
    }

    public int readInt() throws JMSException {
        int result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readInt");
        }
        Object nextObj = this.getNextField("readInt");
        try {
            result = JmsMessageImpl.parseInt(nextObj, "");
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readInt", (Object)result);
        }
        return result;
    }

    public long readLong() throws JMSException {
        long result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readLong");
        }
        Object nextObj = this.getNextField("readLong");
        try {
            result = JmsMessageImpl.parseLong(nextObj, "");
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readLong", (Object)result);
        }
        return result;
    }

    public float readFloat() throws JMSException {
        float result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readFloat");
        }
        Object nextObj = this.getNextField("readFloat");
        try {
            result = JmsMessageImpl.parseFloat(nextObj, "");
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readFloat", (Object)Float.valueOf(result));
        }
        return result;
    }

    public double readDouble() throws JMSException {
        double result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readDouble");
        }
        Object nextObj = this.getNextField("readDouble");
        try {
            result = JmsMessageImpl.parseDouble(nextObj, "");
        }
        catch (JMSException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.streamMsg.stepBack();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readDouble", (Object)result);
        }
        return result;
    }

    public String readString() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readString");
        }
        Object obj = this.getNextField("readString");
        String value = null;
        if (obj instanceof String || obj == null) {
            value = (String)obj;
        } else {
            if (obj instanceof byte[]) {
                this.streamMsg.stepBack();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"found byte array not String");
                }
                throw JmsStreamMessageImpl.newBadConvertException(obj, "", "String", tc);
            }
            value = obj.toString();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readString", (Object)value);
        }
        return value;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readBytes", (Object)value);
        }
        int result = 99;
        this.checkBodyReadable("readBytes");
        if (!this.partReadBytesElement) {
            Object obj = this.getNextField("readBytes");
            if (obj == null) {
                result = -1;
            } else if (obj instanceof byte[]) {
                this.bytesElement = (byte[])obj;
                this.bytesElementOffset = 0;
                if (this.bytesElement.length == 0) {
                    result = 0;
                }
            } else {
                this.streamMsg.stepBack();
                throw JmsStreamMessageImpl.newBadConvertException(obj, "", "byte[]", tc);
            }
        }
        if (result == 99) {
            if (value == null) {
                throw (NullPointerException)JmsErrorUtils.newThrowable(NullPointerException.class, "NULL_BUFFER_CWSIA0161", null, tc);
            }
            int nBytesLeft = this.bytesElement.length - this.bytesElementOffset;
            int nBytes = nBytesLeft > value.length ? value.length : nBytesLeft;
            this.partReadBytesElement = nBytes == value.length;
            if (nBytes == 0) {
                result = -1;
            } else {
                System.arraycopy(this.bytesElement, this.bytesElementOffset, value, 0, nBytes);
                this.bytesElementOffset += nBytes;
                result = nBytes;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readBytes", (Object)result);
        }
        return result;
    }

    public Object readObject() throws JMSException {
        Object result;
        Object obj;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"readObject");
        }
        if ((obj = this.getNextField("readObject")) instanceof byte[]) {
            int len = ((byte[])obj).length;
            result = new byte[len];
            System.arraycopy(obj, 0, result, 0, len);
        } else {
            result = obj;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"readObject", (Object)result);
        }
        return result;
    }

    public void writeBoolean(boolean x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBoolean", (Object)x);
        }
        this.checkBodyWriteable("writeBoolean");
        try {
            this.streamMsg.writeBoolean(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeBoolean"}, e, "JmsStreamMessageImpl#1", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBoolean");
        }
    }

    public void writeByte(byte x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeByte", (Object)x);
        }
        this.checkBodyWriteable("writeByte");
        try {
            this.streamMsg.writeByte(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeByte"}, e, "JmsStreamMessageImpl#2", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeByte");
        }
    }

    public void writeShort(short x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeShort", (Object)x);
        }
        this.checkBodyWriteable("writeShort");
        try {
            this.streamMsg.writeShort(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeShort"}, e, "JmsStreamMessageImpl#3", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeShort");
        }
    }

    public void writeChar(char x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeChar", (Object)Character.valueOf(x));
        }
        this.checkBodyWriteable("writeChar");
        try {
            this.streamMsg.writeChar(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeChar"}, e, "JmsStreamMessageImpl#4", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeChar");
        }
    }

    public void writeInt(int x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeInt", (Object)x);
        }
        this.checkBodyWriteable("writeInt");
        try {
            this.streamMsg.writeInt(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeInt"}, e, "JmsStreamMessageImpl#5", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeInt");
        }
    }

    public void writeLong(long x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeLong", (Object)x);
        }
        this.checkBodyWriteable("writeLong");
        try {
            this.streamMsg.writeLong(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeLong"}, e, "JmsStreamMessageImpl#6", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeLong");
        }
    }

    public void writeFloat(float x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeFloat", (Object)Float.valueOf(x));
        }
        this.checkBodyWriteable("writeFloat");
        try {
            this.streamMsg.writeFloat(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeFloat"}, e, "JmsStreamMessageImpl#7", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeFloat");
        }
    }

    public void writeDouble(double x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeDouble", (Object)x);
        }
        this.checkBodyWriteable("writeDouble");
        try {
            this.streamMsg.writeDouble(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeDouble"}, e, "JmsStreamMessageImpl#8", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeDouble");
        }
    }

    public void writeString(String x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeString", (Object)x);
        }
        this.checkBodyWriteable("writeString");
        try {
            this.streamMsg.writeString(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeString"}, e, "JmsStreamMessageImpl#9", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeString");
        }
    }

    public void writeBytes(byte[] x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeBytes", (Object)x);
        }
        this.checkBodyWriteable("writeBytes");
        if (x != null) {
            byte[] c = new byte[x.length];
            System.arraycopy(x, 0, c, 0, x.length);
            x = c;
        }
        try {
            this.streamMsg.writeBytes(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeBytes"}, e, "JmsStreamMessageImpl#10", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBytes");
        }
    }

    public void writeBytes(byte[] x, int offset, int len) throws JMSException {
        this.checkBodyWriteable("writeBytes");
        byte[] subA = new byte[len];
        System.arraycopy(x, offset, subA, 0, len);
        try {
            this.streamMsg.writeBytes(subA);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeBytes"}, e, "JmsStreamMessageImpl#11", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeBytes");
        }
    }

    public void writeObject(Object x) throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"writeObject", (Object)x);
        }
        this.checkBodyWriteable("writeObject");
        if (!(x == null || x instanceof String || x instanceof Number || x instanceof Boolean || x instanceof Character || x instanceof byte[])) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("value is bad type: " + x.getClass().getName()));
            }
            throw (JMSException)JmsErrorUtils.newThrowable(MessageFormatException.class, "BAD_OBJECT_CWSIA0189", new Object[]{x.getClass().getName()}, tc);
        }
        if (x instanceof byte[]) {
            byte[] v = (byte[])x;
            byte[] tmp = new byte[v.length];
            System.arraycopy(v, 0, tmp, 0, v.length);
            x = tmp;
        }
        try {
            this.streamMsg.writeObject(x);
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.writeObject"}, e, "JmsStreamMessageImpl#12", this, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"writeObject");
        }
    }

    public void reset() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"reset");
        }
        this.setBodyReadOnly();
        this.streamMsg.reset();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"reset");
        }
    }

    @Override
    protected JsJmsMessage instantiateMessage() throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"instantiateMessage");
        }
        JsJmsStreamMessage newMsg = null;
        try {
            newMsg = jmfact.createJmsStreamMessage();
        }
        catch (MessageCreateFailedException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception caught: ", (Object)((Object)e));
            }
            throw e;
        }
        this.streamMsg = newMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"instantiateMessage", (Object)newMsg);
        }
        return newMsg;
    }

    private Object getNextField(String callingMethodName) throws MessageEOFException, MessageNotReadableException, MessageFormatException, JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextField", (Object)callingMethodName);
        }
        this.checkBodyReadable(callingMethodName);
        if (this.partReadBytesElement) {
            throw (MessageFormatException)JmsErrorUtils.newThrowable(MessageFormatException.class, "INCOMPLETE_BYTE_ARRAY_CWSIA0163", null, tc);
        }
        Object nextObj = null;
        try {
            nextObj = this.streamMsg.readObject();
        }
        catch (UnsupportedEncodingException e) {
            throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "EXCEPTION_RECEIVED_CWSIA0022", new Object[]{e, "JmsStreamMessageImpl.getNextField"}, e, "JmsStreamMessageImpl#13", this, tc);
        }
        if (nextObj == JsJmsStreamMessage.END_OF_STREAM) {
            throw (MessageEOFException)JmsErrorUtils.newThrowable(MessageEOFException.class, "END_STREAM_CWSIA0162", null, tc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextField", (Object)nextObj);
        }
        return nextObj;
    }
}

