/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.xml.ws.WebFault;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.NullConduitSelector;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.OneShotAsyncExecutor;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.FaultAction;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.Names;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
final class InternalContextUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(InternalContextUtils.class);
    static final long serialVersionUID = -7707837943898418679L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private InternalContextUtils() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void rebaseResponse(EndpointReferenceType reference, AddressingProperties inMAPs, final Message inMessage) {
        block29: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "rebaseResponse", new Object[]{reference, inMAPs, inMessage});
            }
            String namespaceURI = inMAPs.getNamespaceURI();
            if (!ContextUtils.retrievePartialResponseSent((Message)inMessage)) {
                ContextUtils.storePartialResponseSent((Message)inMessage);
                Exchange exchange = inMessage.getExchange();
                Message fullResponse = exchange.getOutMessage();
                Message partialResponse = ContextUtils.createMessage((Exchange)exchange);
                InternalContextUtils.ensurePartialResponseMAPs(partialResponse, namespaceURI);
                ContextUtils.propogateReceivedMAPs((AddressingProperties)inMAPs, (Message)partialResponse);
                Destination target = inMessage.getDestination();
                if (target == null) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "rebaseResponse");
                    }
                    return;
                }
                try {
                    DelegatingInputStream in;
                    if (reference == null) {
                        reference = ContextUtils.getNoneEndpointReference();
                    }
                    Conduit backChannel = target.getBackChannel(inMessage);
                    Exception exception = (Exception)inMessage.getContent(Exception.class);
                    if (backChannel != null && !inMessage.getExchange().isOneWay() && ContextUtils.isFault((Message)inMessage)) {
                        exchange.setOutMessage(ContextUtils.createMessage((Exchange)exchange));
                        exchange.put(ConduitSelector.class, (Object)new NullConduitSelector());
                        exchange.put((Object)"org.apache.cxf.http.no_io_exceptions", (Object)true);
                        Destination destination = InternalContextUtils.createDecoupledDestination(exchange, reference);
                        exchange.setDestination(destination);
                        if (ContextUtils.retrieveAsyncPostResponseDispatch((Message)inMessage)) {
                            DelegatingInputStream in2 = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class);
                            if (in2 != null) {
                                in2.cacheInput();
                            }
                            inMessage.getInterceptorChain().reset();
                            if (inMessage.get((Object)Message.PATH_INFO) != null) {
                                inMessage.remove((Object)Message.PATH_INFO);
                            }
                            inMessage.getInterceptorChain().doIntercept(inMessage);
                        }
                        partialResponse.put((Object)"forced.faultstring", (Object)("The server sent HTTP status code :" + inMessage.getExchange().get((Object)Message.RESPONSE_CODE)));
                        partialResponse.setContent(Exception.class, (Object)exception);
                        partialResponse.put((Object)Message.PROTOCOL_HEADERS, inMessage.get((Object)Message.PROTOCOL_HEADERS));
                        partialResponse.put((Object)Message.ENCODING, inMessage.get((Object)Message.ENCODING));
                        partialResponse.put((Object)ContextUtils.ACTION, inMessage.get((Object)ContextUtils.ACTION));
                        partialResponse.put((Object)"jakarta.xml.ws.addressing.context.inbound", inMessage.get((Object)"jakarta.xml.ws.addressing.context.inbound"));
                        partialResponse.put((Object)"jakarta.xml.ws.addressing.context.outbound", inMessage.get((Object)"jakarta.xml.ws.addressing.context.outbound"));
                        exchange.setOutMessage(partialResponse);
                        PhaseInterceptorChain newChian = ((PhaseInterceptorChain)inMessage.getInterceptorChain()).cloneChain();
                        partialResponse.setInterceptorChain((InterceptorChain)newChian);
                        exchange.setDestination(target);
                        exchange.setOneWay(false);
                        exchange.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(backChannel, exchange.getEndpoint()));
                        if (newChian != null && !newChian.doIntercept(partialResponse) && partialResponse.getContent(Exception.class) != null) {
                            if (partialResponse.getContent(Exception.class) instanceof Fault) {
                                throw (Fault)partialResponse.getContent(Exception.class);
                            }
                            throw new Fault((Throwable)partialResponse.getContent(Exception.class));
                        }
                        if (LOG != null && LOG.isLoggable(Level.FINER)) {
                            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "rebaseResponse");
                        }
                        return;
                    }
                    if (backChannel == null) break block29;
                    partialResponse.put((Object)"org.apache.cxf.partial.response", (Object)Boolean.TRUE);
                    partialResponse.put((Object)"org.apache.cxf.partial.response.empty", (Object)Boolean.TRUE);
                    boolean robust = MessageUtils.getContextualBoolean((Message)inMessage, (String)"org.apache.cxf.oneway.robust", (boolean)false);
                    if (robust) {
                        BindingOperationInfo boi = exchange.getBindingOperationInfo();
                        exchange.put(Executor.class, (Object)InternalContextUtils.getExecutor(inMessage));
                        inMessage.getInterceptorChain().pause();
                        inMessage.getInterceptorChain().resume();
                        MessageObserver faultObserver = inMessage.getInterceptorChain().getFaultObserver();
                        if (null != inMessage.getContent(Exception.class) && null != faultObserver) {
                            inMessage.getExchange().setOneWay(false);
                            faultObserver.onMessage(inMessage);
                            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "rebaseResponse");
                            }
                            return;
                        }
                        exchange.put(BindingOperationInfo.class, (Object)boi);
                    }
                    InterceptorChain chain = fullResponse != null ? fullResponse.getInterceptorChain() : OutgoingChainInterceptor.getOutInterceptorChain((Exchange)exchange);
                    exchange.setOutMessage(partialResponse);
                    partialResponse.setInterceptorChain(chain);
                    exchange.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(backChannel, exchange.getEndpoint()));
                    if (ContextUtils.retrieveAsyncPostResponseDispatch((Message)inMessage) && !robust && (in = (DelegatingInputStream)inMessage.getContent(DelegatingInputStream.class)) != null) {
                        in.cacheInput();
                    }
                    if (chain != null && !chain.doIntercept(partialResponse) && partialResponse.getContent(Exception.class) != null) {
                        if (partialResponse.getContent(Exception.class) instanceof Fault) {
                            throw (Fault)partialResponse.getContent(Exception.class);
                        }
                        throw new Fault((Throwable)partialResponse.getContent(Exception.class));
                    }
                    if (chain != null) {
                        chain.reset();
                    }
                    exchange.put(ConduitSelector.class, (Object)new NullConduitSelector());
                    if (fullResponse == null) {
                        fullResponse = ContextUtils.createMessage((Exchange)exchange);
                    }
                    exchange.setOutMessage(fullResponse);
                    Destination destination = InternalContextUtils.createDecoupledDestination(exchange, reference);
                    exchange.setDestination(destination);
                    if (!ContextUtils.retrieveAsyncPostResponseDispatch((Message)inMessage) || robust) break block29;
                    if (inMessage.get((Object)Message.PATH_INFO) != null) {
                        inMessage.remove((Object)Message.PATH_INFO);
                    }
                    inMessage.getInterceptorChain().pause();
                    try {
                        InternalContextUtils.getExecutor(inMessage).execute(new Runnable(){
                            static final long serialVersionUID = 3482727156453720982L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public void run() {
                                inMessage.getInterceptorChain().resume();
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.impl.InternalContextUtils$1", 1.class, null, null);
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        FFDCFilter.processException((Throwable)rejectedExecutionException, (String)"org.apache.cxf.ws.addressing.impl.InternalContextUtils", (String)"322", null, (Object[])new Object[]{reference, inMAPs, inMessage});
                        LOG.warning("Executor queue is full, use the caller thread.  Users can specify a larger executor queue to avoid this.");
                        if (!MessageUtils.getContextualBoolean((Message)inMessage, (String)"org.apache.cxf.oneway.rejected_execution_exception")) {
                            inMessage.getInterceptorChain().resume();
                        }
                    }
                }
                catch (Exception backChannel) {
                    void e;
                    FFDCFilter.processException((Throwable)backChannel, (String)"org.apache.cxf.ws.addressing.impl.InternalContextUtils", (String)"335", null, (Object[])new Object[]{reference, inMAPs, inMessage});
                    LOG.log(Level.WARNING, "SERVER_TRANSPORT_REBASE_FAILURE_MSG", (Throwable)e);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "rebaseResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Destination createDecoupledDestination(Exchange exchange, EndpointReferenceType reference) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "createDecoupledDestination", new Object[]{exchange, reference});
        }
        EndpointInfo ei = exchange.getEndpoint().getEndpointInfo();
        DecoupledDestination decoupledDestination = new DecoupledDestination(ei, reference);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            decoupledDestination = decoupledDestination;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "createDecoupledDestination", decoupledDestination);
        }
        return decoupledDestination;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void ensurePartialResponseMAPs(Message partialResponse, String namespaceURI) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "ensurePartialResponseMAPs", new Object[]{partialResponse, namespaceURI});
        }
        AddressingProperties maps = new AddressingProperties();
        maps.setTo(EndpointReferenceUtils.getAnonymousEndpointReference());
        maps.setReplyTo(ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType());
        maps.getReplyTo().setAddress(ContextUtils.getAttributedURI((String)"http://www.w3.org/2005/08/addressing/none"));
        maps.setAction(ContextUtils.getAttributedURI((String)""));
        maps.exposeAs(namespaceURI);
        ContextUtils.storeMAPs((AddressingProperties)maps, (Message)partialResponse, (boolean)true, (boolean)true, (boolean)false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "ensurePartialResponseMAPs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static AttributedURIType getAction(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getAction", new Object[]{message});
        }
        String action = null;
        LOG.fine("Determining action");
        Exception fault = (Exception)message.getContent(Exception.class);
        if (fault instanceof Fault && "http://www.w3.org/2005/08/addressing".equals(((Fault)fault).getFaultCode().getNamespaceURI())) {
            action = "http://www.w3.org/2005/08/addressing/fault";
        } else {
            FaultAction annotation = null;
            if (fault != null) {
                annotation = fault.getClass().getAnnotation(FaultAction.class);
            }
            action = annotation != null && annotation.value() != null ? annotation.value() : InternalContextUtils.getActionFromServiceModel(message, fault);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("action: " + action);
        }
        AttributedURIType attributedURIType = action != null ? ContextUtils.getAttributedURI((String)action) : null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            attributedURIType = attributedURIType;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getAction", attributedURIType);
        }
        return attributedURIType;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getActionFromServiceModel(Message message, Exception fault) {
        String action;
        block7: {
            BindingOperationInfo bindingOpInfo;
            block8: {
                MessageInfo msgInfo;
                String cachedAction;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getActionFromServiceModel", new Object[]{message, fault});
                }
                action = null;
                bindingOpInfo = message.getExchange().getBindingOperationInfo();
                if (bindingOpInfo == null) break block7;
                if (bindingOpInfo.isUnwrappedCapable()) {
                    bindingOpInfo = bindingOpInfo.getUnwrappedOperation();
                }
                if (fault != null) break block8;
                action = (String)message.get((Object)ContextUtils.ACTION);
                if (StringUtils.isEmpty((String)action)) {
                    action = (String)message.get((Object)"SOAPAction");
                }
                if (action != null && !"".equals(action) || (action = (cachedAction = (String)(msgInfo = ContextUtils.isRequestor((Message)message) ? bindingOpInfo.getOperationInfo().getInput() : bindingOpInfo.getOperationInfo().getOutput()).getProperty(ContextUtils.ACTION)) == null ? InternalContextUtils.getActionFromMessageAttributes(msgInfo) : cachedAction) != null || !ContextUtils.isRequestor((Message)message)) break block7;
                SoapOperationInfo soi = InternalContextUtils.getSoapOperationInfo(bindingOpInfo);
                action = soi == null ? null : soi.getAction();
                action = StringUtils.isEmpty((String)action) ? null : action;
                break block7;
            }
            Throwable t = fault.getCause();
            for (BindingFaultInfo bfi : bindingOpInfo.getFaults()) {
                FaultInfo fi = bfi.getFaultInfo();
                if (fi.size() == 0 || t == null || !InternalContextUtils.matchFault(t, fi) || fi.getExtensionAttributes() == null) continue;
                String attr = (String)fi.getExtensionAttributes().get(Names.WSAW_ACTION_QNAME);
                if (attr == null) {
                    attr = (String)fi.getExtensionAttributes().get(new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action"));
                }
                if (attr == null) continue;
                action = attr;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("action determined from service model: " + action);
        }
        String string = action;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getActionFromServiceModel", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean matchFault(Throwable t, FaultInfo fi) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "matchFault", new Object[]{t, fi});
        }
        MessagePartInfo fmpi = fi.getFirstMessagePart();
        Class fiTypeClass = fmpi.getTypeClass();
        if (fiTypeClass != null && t.getClass().isAssignableFrom(fiTypeClass)) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "matchFault", bl);
            }
            return bl;
        }
        QName fiName = fmpi.getConcreteName();
        WebFault wf = t.getClass().getAnnotation(WebFault.class);
        boolean bl = wf != null && fiName != null && wf.targetNamespace() != null && wf.targetNamespace().equals(fiName.getNamespaceURI()) && wf.name() != null && wf.name().equals(fiName.getLocalPart());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "matchFault", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static SoapOperationInfo getSoapOperationInfo(BindingOperationInfo bindingOpInfo) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getSoapOperationInfo", new Object[]{bindingOpInfo});
        }
        SoapOperationInfo soi = (SoapOperationInfo)bindingOpInfo.getExtensor(SoapOperationInfo.class);
        if (soi == null && bindingOpInfo.isUnwrapped()) {
            soi = (SoapOperationInfo)bindingOpInfo.getWrappedOperation().getExtensor(SoapOperationInfo.class);
        }
        SoapOperationInfo soapOperationInfo = soi;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            soapOperationInfo = soapOperationInfo;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getSoapOperationInfo", soapOperationInfo);
        }
        return soapOperationInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getActionFromMessageAttributes(MessageInfo msgInfo) {
        String attr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getActionFromMessageAttributes", new Object[]{msgInfo});
        }
        String action = null;
        if (msgInfo != null && msgInfo.getExtensionAttributes() != null && !StringUtils.isEmpty((String)(attr = InternalContextUtils.getAction((Extensible)msgInfo)))) {
            action = attr;
            msgInfo.setProperty(ContextUtils.ACTION, (Object)action);
        }
        String string = action;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getActionFromMessageAttributes", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String getAction(Extensible ext) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getAction", new Object[]{ext});
        }
        Object o = ext.getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2007/05/addressing/metadata", "Action"));
        }
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2005/08/addressing", "Action"));
        }
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action"));
        }
        if (o instanceof QName) {
            String string = ((QName)o).getLocalPart();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                string = string;
                LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getAction", string);
            }
            return string;
        }
        String string = o == null ? null : o.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getAction", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Executor getExecutor(Message message) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getExecutor", new Object[]{message});
        }
        Endpoint endpoint = message.getExchange().getEndpoint();
        Executor executor = endpoint.getService().getExecutor();
        if (executor == null || SynchronousExecutor.isA((Executor)executor)) {
            WorkQueueManager workQueueManager;
            AutomaticWorkQueue autoWorkQueue;
            Bus bus = message.getExchange().getBus();
            executor = bus != null ? ((autoWorkQueue = (workQueueManager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getNamedWorkQueue("ws-addressing")) != null ? autoWorkQueue : workQueueManager.getAutomaticWorkQueue()) : OneShotAsyncExecutor.getInstance();
        }
        message.getExchange().put(Executor.class, (Object)executor);
        Executor executor2 = executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            executor2 = executor2;
            LOG.exiting("org.apache.cxf.ws.addressing.impl.InternalContextUtils", "getExecutor", executor2);
        }
        return executor2;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class DecoupledDestination
    implements Destination {
        private final EndpointInfo ei;
        private final EndpointReferenceType reference;
        static final long serialVersionUID = -3791996158846512612L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DecoupledDestination(EndpointInfo ei, EndpointReferenceType reference) {
            this.ei = ei;
            this.reference = reference;
        }

        public EndpointReferenceType getAddress() {
            return this.reference;
        }

        public Conduit getBackChannel(Message inMessage) throws IOException {
            if (ContextUtils.isNoneAddress((EndpointReferenceType)this.reference)) {
                return null;
            }
            Bus bus = inMessage.getExchange().getBus();
            inMessage.getExchange().setOneWay(true);
            ConduitInitiator conduitInitiator = ((ConduitInitiatorManager)bus.getExtension(ConduitInitiatorManager.class)).getConduitInitiatorForUri(this.reference.getAddress().getValue());
            if (conduitInitiator != null) {
                Conduit c = conduitInitiator.getConduit(this.ei, this.reference, bus);
                c.setMessageObserver(new MessageObserver(){
                    static final long serialVersionUID = -7509984072393261885L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public void onMessage(Message m) {
                        InputStream is = (InputStream)m.getContent(InputStream.class);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception exception) {
                                FFDCFilter.processException((Throwable)exception, (String)"org.apache.cxf.ws.addressing.impl.InternalContextUtils$DecoupledDestination$1", (String)"113", (Object)this, (Object[])new Object[]{m});
                            }
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.impl.InternalContextUtils$DecoupledDestination$1", 1.class, null, null);
                    }
                });
                return c;
            }
            return null;
        }

        public MessageObserver getMessageObserver() {
            return null;
        }

        public void shutdown() {
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.ws.addressing.impl.InternalContextUtils$DecoupledDestination", DecoupledDestination.class, null, null);
        }
    }
}

