/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.jwk.impl;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.interfaces.JWK;
import com.ibm.ws.security.common.random.RandomUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JWKImpl
implements JWK {
    private static final TraceComponent tc = Tr.register(JWKImpl.class, (String)"SecurityCommonJWK", (String)"com.ibm.ws.security.common.jwk.internal.resources.JWKCommonMessages");
    protected String kid = null;
    protected String x5t = null;
    protected String alg = null;
    protected String use = null;
    protected String kty = null;
    protected int size = 2048;
    protected PublicKey pubKey = null;
    protected PrivateKey priKey = null;
    protected byte[] sharedKey = null;
    protected JSONObject keyObject = new JSONObject();
    protected long created = new Date().getTime();
    protected int kidLength = 20;
    static final long serialVersionUID = -6167188219412870059L;

    public JWKImpl(int size, String alg, String use, String type) {
        this.generateCommon();
        this.alg = alg;
        this.use = use;
        this.kty = type;
    }

    public JWKImpl(JSONObject keyObject) {
        this.keyObject = keyObject;
    }

    @Override
    public void generateKey() {
    }

    public void generateCommon() {
        this.kid = RandomUtils.getRandomAlphaNumeric((int)this.kidLength);
        this.created = new Date().getTime();
    }

    @Override
    public void parse() {
        this.parse(this.keyObject);
    }

    protected void parse(JSONObject keyObject) {
        JSONObject jkid = (JSONObject)keyObject.get((Object)"kid");
        JSONObject jx5t = (JSONObject)keyObject.get((Object)"x5t");
        JSONObject jalg = (JSONObject)keyObject.get((Object)"alg");
        JSONObject jkty = (JSONObject)keyObject.get((Object)"kty");
        JSONObject juse = (JSONObject)keyObject.get((Object)"use");
        if (jkid != null) {
            this.kid = jkid.toString();
        }
        if (jx5t != null) {
            this.x5t = jx5t.toString();
        }
        if (jalg != null) {
            this.alg = jalg.toString();
        }
        if (juse != null) {
            this.use = juse.toString();
        }
        if (jkty != null) {
            this.kty = jkty.toString();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyType=" + this.kty), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Algorithm=" + this.alg), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("KeyID=" + this.kid), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("KeyThumprint=" + this.x5t), (Object[])new Object[0]);
        }
        if ("sig".equals(this.use)) {
            this.buildPublicKey(keyObject, this.kty);
        }
    }

    protected void buildPublicKey(JSONObject keyObject, String kty) {
        if ("RSA".equals(kty)) {
            this.buildRSAPublicKey(keyObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildRSAPublicKey(JSONObject keyObject) {
        block5: {
            JSONObject jModule = (JSONObject)keyObject.get((Object)"n");
            JSONObject jExponent = (JSONObject)keyObject.get((Object)"e");
            String sModule = null;
            String sExponent = null;
            if (jModule != null && jExponent != null) {
                sModule = jModule.toString();
                sExponent = jExponent.toString();
                byte[] modulusBytes = Base64.decodeBase64((String)sModule);
                byte[] exponentBytes = Base64.decodeBase64((String)sExponent);
                BigInteger modulus = new BigInteger(1, modulusBytes);
                BigInteger exponent = new BigInteger(exponentBytes);
                try {
                    RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
                    KeyFactory factory = KeyFactory.getInstance("RSA");
                    this.pubKey = factory.generatePublic(spec);
                }
                catch (InvalidKeySpecException spec) {
                    FFDCFilter.processException((Throwable)spec, (String)"com.ibm.ws.security.common.jwk.impl.JWKImpl", (String)"136", (Object)this, (Object[])new Object[]{keyObject});
                    if (tc.isDebugEnabled()) {
                        void ikse;
                        Tr.debug((TraceComponent)tc, (String)("Invalid Key=" + ikse), (Object[])new Object[0]);
                    }
                }
                catch (NoSuchAlgorithmException ikse) {
                    void nsae;
                    FFDCFilter.processException((Throwable)ikse, (String)"com.ibm.ws.security.common.jwk.impl.JWKImpl", (String)"142", (Object)this, (Object[])new Object[]{keyObject});
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)("Invald Algorithm=" + nsae), (Object[])new Object[0]);
                }
            }
        }
    }

    public String getKeyID() {
        return this.kid;
    }

    public String getKeyX5t() {
        return this.x5t;
    }

    public String getAlgorithm() {
        return this.alg;
    }

    public String getKeyUse() {
        return this.use;
    }

    public String getKeyType() {
        return this.kty;
    }

    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    public PrivateKey getPrivateKey() {
        return this.priKey;
    }

    public byte[] getSharedKey() {
        return null;
    }

    public long getCreated() {
        return this.created;
    }

    public void setKidLength(int length) {
        this.kidLength = length;
    }

    public int getKidLength() {
        return this.kidLength;
    }

    public void toJsonObject() {
        this.keyObject.put((Object)"kid", (Object)this.kid);
        this.keyObject.put((Object)"use", (Object)"sig");
    }

    @Override
    public JSONObject getJsonObject() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JSON Web Key:", (Object[])new Object[]{this.keyObject});
        }
        return this.keyObject;
    }
}

