/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.security.internal.jacc;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ejbcontainer.EJBMethodMetaData;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.jacc.MethodInfo;
import com.ibm.ws.security.authorization.jacc.RoleInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JaccUtil {
    private static TraceComponent tc = Tr.register(JaccUtil.class, (String)"SecurityCollaborator", (String)"com.ibm.ws.ejbcontainer.security.internal.resources.EJBSecurityMessages");
    static final long serialVersionUID = -6263546655730734167L;

    public static Map<RoleInfo, List<MethodInfo>> convertMethodInfoList(List<EJBMethodMetaData> methodInfos) {
        HashMap<RoleInfo, List<MethodInfo>> methodMap = null;
        if (methodInfos != null && !methodInfos.isEmpty()) {
            methodMap = new HashMap<RoleInfo, List<MethodInfo>>();
            for (EJBMethodMetaData mi : methodInfos) {
                String methodName = mi.getMethodName();
                String methodIntName = mi.getEJBMethodInterface().specName();
                Method method = mi.getMethod();
                ArrayList<String> params = null;
                if (method != null) {
                    params = new ArrayList<String>();
                    for (Class<?> cl : method.getParameterTypes()) {
                        params.add(cl.getName());
                    }
                }
                List roles = mi.getRolesAllowed();
                MethodInfo methodInfo = new MethodInfo(methodName, methodIntName, params);
                if (mi.isDenyAll() || mi.isPermitAll()) {
                    RoleInfo ri = null;
                    ri = mi.isDenyAll() ? RoleInfo.DENY_ALL : RoleInfo.PERMIT_ALL;
                    JaccUtil.putMethodInfo(methodMap, ri, methodInfo);
                } else if (roles != null && !roles.isEmpty()) {
                    for (String role : roles) {
                        JaccUtil.putMethodInfo(methodMap, new RoleInfo(role), methodInfo);
                    }
                }
                if (!tc.isDebugEnabled()) continue;
                StringBuffer buf = new StringBuffer();
                for (Map.Entry entry : methodMap.entrySet()) {
                    RoleInfo ri = (RoleInfo)entry.getKey();
                    List miList = (List)entry.getValue();
                    buf.append("\n-----------\nRoleInfo: ").append(ri.toString());
                    buf.append("MethodInfo : number of methods : ").append(miList.size());
                    for (MethodInfo minfo : miList) {
                        buf.append("\n").append(minfo.toString());
                    }
                }
                Tr.debug((TraceComponent)tc, (String)buf.toString(), (Object[])new Object[0]);
            }
        }
        return methodMap;
    }

    public static List<EJBMethodMetaData> mergeMethodInfos(BeanMetaData bmd) {
        EJBMethodInfoImpl[][] list;
        ArrayList<EJBMethodMetaData> miList = new ArrayList<EJBMethodMetaData>();
        for (EJBMethodInfoImpl[] miArray : list = new EJBMethodInfoImpl[][]{bmd.homeMethodInfos, bmd.localHomeMethodInfos, bmd.methodInfos, bmd.localMethodInfos, bmd.timedMethodInfos, bmd.wsEndpointMethodInfos, bmd.lifecycleInterceptorMethodInfos}) {
            if (miArray == null || miArray.length <= 0) continue;
            miList.addAll(Arrays.asList(miArray));
        }
        if (miList.isEmpty()) {
            miList = null;
        }
        return miList;
    }

    protected static void putMethodInfo(Map<RoleInfo, List<MethodInfo>> methodMap, RoleInfo ri, MethodInfo methodInfo) {
        List<MethodInfo> methodInfoList = methodMap.get(ri);
        if (methodInfoList == null) {
            methodInfoList = new ArrayList<MethodInfo>();
            methodInfoList.add(methodInfo);
            methodMap.put(ri, methodInfoList);
        } else if (!methodInfoList.contains(methodInfo)) {
            methodInfoList.add(methodInfo);
        }
    }
}

