/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authentication.utility;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SubjectHelper {
    private static final TraceComponent tc = Tr.register(SubjectHelper.class, null, null);
    static final long serialVersionUID = -2679843572021519452L;

    public boolean isUnauthenticated(Subject subject) {
        if (subject == null) {
            return true;
        }
        WSCredential wsCred = this.getWSCredential(subject);
        if (wsCred == null) {
            return true;
        }
        return wsCred.isUnauthenticated();
    }

    public String getRealm(Subject subject) throws Exception {
        String realm = null;
        WSCredential credential = this.getWSCredential(subject);
        if (credential != null) {
            realm = credential.getRealmName();
        }
        return realm;
    }

    public WSCredential getWSCredential(Subject subject) {
        WSCredential wsCredential = null;
        Set<WSCredential> wsCredentials = subject.getPublicCredentials(WSCredential.class);
        Iterator<WSCredential> wsCredentialsIterator = wsCredentials.iterator();
        if (wsCredentialsIterator.hasNext()) {
            wsCredential = wsCredentialsIterator.next();
        }
        return wsCredential;
    }

    public String getIDTokenFromRunAsSubject() {
        Hashtable<String, ?> hashtableFromRunAsSubject = this.getHashtableFromRunAsSubject();
        if (hashtableFromRunAsSubject == null) {
            return null;
        }
        return (String)hashtableFromRunAsSubject.get("id_token");
    }

    public Hashtable<String, ?> getHashtableFromSubject(final Subject subject, final String[] properties) {
        if (subject == null) {
            return null;
        }
        return (Hashtable)AccessController.doPrivileged(new PrivilegedAction<Hashtable<String, ?>>(){
            static final long serialVersionUID = 8403741094066435368L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Hashtable<String, ?> run() {
                Set<Object> list_private;
                Hashtable hashtableFromPrivate;
                Set<Object> list_public;
                Hashtable hashtableFromPublic;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in public cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPublic = SubjectHelper.this.getHashtable(list_public = subject.getPublicCredentials(), properties)) != null) {
                    return hashtableFromPublic;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in private cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPrivate = SubjectHelper.this.getHashtable(list_private = subject.getPrivateCredentials(), properties)) != null) {
                    return hashtableFromPrivate;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$1", 1.class, null, null);
            }
        });
    }

    private Hashtable<String, ?> getHashtable(Set<Object> creds, String[] properties) {
        int i = 0;
        for (Object cred : creds) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Object[" + i + "] in credential list: " + cred), (Object[])new Object[0]);
            }
            if (cred instanceof Hashtable) {
                for (int j = 0; j < properties.length; ++j) {
                    if (((Hashtable)cred).get(properties[j]) == null) continue;
                    return (Hashtable)cred;
                }
            }
            ++i;
        }
        return null;
    }

    public static GSSCredential getGSSCredentialFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        GSSCredential gssCredential = AccessController.doPrivileged(new PrivilegedAction<GSSCredential>(){
            static final long serialVersionUID = 1363074790083390286L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public GSSCredential run() {
                Iterator<GSSCredential> privCredItr;
                GSSCredential gssCredInSubject = null;
                Set<GSSCredential> privCredentials = subject.getPrivateCredentials(GSSCredential.class);
                if (privCredentials != null && (privCredItr = privCredentials.iterator()).hasNext()) {
                    gssCredInSubject = privCredItr.next();
                }
                return gssCredInSubject;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$2", 2.class, null, null);
            }
        });
        if (gssCredential == null) {
            return SubjectHelper.createGSSCredential(subject);
        }
        return gssCredential;
    }

    public static GSSCredential createGSSCredential(Subject subject) {
        KerberosTicket tgt = SubjectHelper.getKerberosTicketFromSubject(subject, null);
        if (tgt != null) {
            return SubjectHelper.createGSSCredential(subject, tgt);
        }
        return null;
    }

    private static KerberosTicket getKerberosTicketFromSubject(final Subject subject, final String user) {
        KerberosTicket tgt = AccessController.doPrivileged(new PrivilegedAction<KerberosTicket>(){
            static final long serialVersionUID = -7146177311615792679L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public KerberosTicket run() {
                KerberosTicket kerberosTicketInSubject = null;
                Set<KerberosTicket> privCredentials = subject.getPrivateCredentials(KerberosTicket.class);
                if (privCredentials != null) {
                    for (KerberosTicket kTicket : privCredentials) {
                        if (user == null) {
                            return kTicket;
                        }
                        if (!kTicket.getClient().getName().startsWith(user)) continue;
                        return kTicket;
                    }
                }
                return kerberosTicketInSubject;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$3", 3.class, null, null);
            }
        });
        return tgt;
    }

    public static boolean isSpnTGTInSubject(Subject subject, String user) {
        boolean result = false;
        KerberosTicket tgt = SubjectHelper.getKerberosTicketFromSubject(subject, user);
        if (tgt != null) {
            result = true;
        }
        return result;
    }

    public static boolean isTGTInSubjectValid(Subject subject, String user) {
        boolean result = false;
        KerberosTicket tgt = SubjectHelper.getKerberosTicketFromSubject(subject, user);
        if (tgt != null) {
            return tgt.isCurrent();
        }
        return result;
    }

    private static GSSCredential createGSSCredential(Subject subject, final KerberosTicket ticket) {
        GSSCredential gssCred = null;
        PrivilegedAction<Object> action = new PrivilegedAction<Object>(){
            static final long serialVersionUID = 8133146334442070446L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public Object run() {
                GSSCredential inGssCrd;
                block3: {
                    inGssCrd = null;
                    try {
                        String clientName = ticket.getClient().getName();
                        Oid krbOid = new Oid("1.2.840.113554.1.2.2");
                        if (clientName != null && clientName.length() > 0) {
                            GSSManager gssMgr = GSSManager.getInstance();
                            GSSName gssName = gssMgr.createName(clientName, GSSName.NT_USER_NAME, krbOid);
                            inGssCrd = gssMgr.createCredential(gssName.canonicalize(krbOid), Integer.MAX_VALUE, krbOid, 0);
                        }
                    }
                    catch (GSSException clientName) {
                        void e;
                        FFDCFilter.processException((Throwable)clientName, (String)"com.ibm.ws.security.authentication.utility.SubjectHelper$4", (String)"273", (Object)this, (Object[])new Object[0]);
                        if (!tc.isDebugEnabled()) break block3;
                        Tr.debug((TraceComponent)tc, (String)"getGSSCredential unexpected exception", (Object[])new Object[]{e});
                    }
                }
                return inGssCrd;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$4", 4.class, null, null);
            }
        };
        gssCred = (GSSCredential)WSSubject.doAs(subject, action);
        return gssCred;
    }

    @Sensitive
    public Hashtable<String, Object> createNewHashtableInSubject(@Sensitive Subject subject) {
        return AccessController.doPrivileged(new NewHashtablePrivilegedAction(subject));
    }

    @Sensitive
    public Hashtable<String, ?> getSensitiveHashtableFromSubject(@Sensitive Subject subject) {
        if (System.getSecurityManager() == null) {
            return this.getHashtableFromSubject(subject);
        }
        return (Hashtable)AccessController.doPrivileged(new GetHashtablePrivilegedAction(subject));
    }

    public Hashtable<String, ?> getHashtableFromRunAsSubject() {
        try {
            Subject runAsSubject = WSSubject.getRunAsSubject();
            if (runAsSubject == null) {
                return null;
            }
            return this.getHashtableFromSubject(runAsSubject);
        }
        catch (Exception runAsSubject) {
            FFDCFilter.processException((Throwable)runAsSubject, (String)"com.ibm.ws.security.authentication.utility.SubjectHelper", (String)"343", (Object)this, (Object[])new Object[0]);
            return null;
        }
    }

    @Trivial
    private Hashtable<String, ?> getHashtableFromSubject(Subject subject) {
        Set<Hashtable> s = subject.getPrivateCredentials(Hashtable.class);
        if (s == null || s.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Subject has no Hashtable, return null.", (Object[])new Object[0]);
            }
            return null;
        }
        return s.iterator().next();
    }

    @Sensitive
    public Hashtable<String, ?> getSensitiveHashtableFromSubject(final @Sensitive Subject subject, final @Sensitive String[] properties) {
        return (Hashtable)AccessController.doPrivileged(new PrivilegedAction<Hashtable<String, ?>>(){
            static final long serialVersionUID = -1290943062061820413L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Hashtable<String, ?> run() {
                Set<Object> list_private;
                Hashtable hashtableFromPrivate;
                Set<Object> list_public;
                Hashtable hashtableFromPublic;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in public cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPublic = SubjectHelper.this.getSensitiveHashtable(list_public = subject.getPublicCredentials(), properties)) != null) {
                    return hashtableFromPublic;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Looking for custom properties in private cred list.", (Object[])new Object[0]);
                }
                if ((hashtableFromPrivate = SubjectHelper.this.getSensitiveHashtable(list_private = subject.getPrivateCredentials(), properties)) != null) {
                    return hashtableFromPrivate;
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$5", 5.class, null, null);
            }
        });
    }

    @Trivial
    private Hashtable<String, ?> getSensitiveHashtable(Set<Object> creds, String[] properties) {
        ArrayList<String> props = new ArrayList<String>();
        for (String property : properties) {
            props.add(property);
        }
        for (Object e : creds) {
            if (!(e instanceof Hashtable) || !((Hashtable)e).keySet().containsAll(props)) continue;
            return (Hashtable)e;
        }
        return null;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class GetHashtablePrivilegedAction
    implements PrivilegedAction<Hashtable<String, ?>> {
        private final Subject subject;
        static final long serialVersionUID = 6059079643025409777L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public GetHashtablePrivilegedAction(Subject subject) {
            this.subject = subject;
        }

        @Override
        @Trivial
        public Hashtable<String, ?> run() {
            return SubjectHelper.this.getHashtableFromSubject(this.subject);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$GetHashtablePrivilegedAction", GetHashtablePrivilegedAction.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class NewHashtablePrivilegedAction
    implements PrivilegedAction<Hashtable<String, Object>> {
        private final Subject subject;
        static final long serialVersionUID = -2404547509038192839L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public NewHashtablePrivilegedAction(Subject subject) {
            this.subject = subject;
        }

        @Override
        public Hashtable<String, Object> run() {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            this.subject.getPrivateCredentials().add(hashtable);
            return hashtable;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.authentication.utility.SubjectHelper$NewHashtablePrivilegedAction", NewHashtablePrivilegedAction.class, null, null);
        }
    }
}

