/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.product.utility.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    static final MessageDigest messagedigest;

    public static String getMD5String(String str) {
        messagedigest.update(str.getBytes());
        return MD5Utils.byteArrayToHexString(messagedigest.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5String(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            int numRead = 0;
            while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
                messagedigest.update(buffer, 0, numRead);
            }
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Exception exception) {}
            }
        }
        return MD5Utils.byteArrayToHexString(messagedigest.digest());
    }

    private static String byteArrayToHexString(byte[] byteArray) {
        StringBuffer stringbuffer = new StringBuffer(2 * byteArray.length);
        for (int i = 0; i < byteArray.length; ++i) {
            char upper = hexDigits[(byteArray[i] & 0xF0) >> 4];
            char lower = hexDigits[byteArray[i] & 0xF];
            stringbuffer.append(upper);
            stringbuffer.append(lower);
        }
        return stringbuffer.toString();
    }

    static {
        try {
            messagedigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

