/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jndi.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jndi.WSEncryptedStringRefAddr;
import com.ibm.ws.jndi.internal.JNDIObjectFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.jndi.referenceEntry"})
public class JNDIReferenceEntry {
    private static final TraceComponent tc = Tr.register(JNDIReferenceEntry.class, (String)"Naming", (String)"com.ibm.ws.jndi.internal.resources.JNDIMessages");
    private static final String PROPERTIES_PREFIX = "properties.0.";
    private static final String PROPERTIES_REFERENCE_TYPE = "properties.0.config.referenceType";
    private JNDIObjectFactory factory;
    private ServiceRegistration<?> registration;
    static final long serialVersionUID = -8622293556339813589L;

    @org.osgi.service.component.annotations.Reference(name="factory")
    protected void setFactory(JNDIObjectFactory factory) {
        this.factory = factory;
    }

    protected void unsetFactory(ServiceReference<?> ref) {
    }

    /*
     * WARNING - void declaration
     */
    protected void activate(BundleContext context, Map<String, Object> props) {
        String jndiName = (String)props.get("jndiName");
        Reference ref = new Reference(this.factory.getObjectClassName(), this.factory.getClassName(), null);
        boolean decode = (Boolean)props.get("decode");
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            StringRefAddr sra;
            String key = entry.getKey();
            if (!key.startsWith(PROPERTIES_PREFIX) || key.equals(PROPERTIES_REFERENCE_TYPE)) continue;
            String addrType = key.substring(PROPERTIES_PREFIX.length());
            String contents = (String)entry.getValue();
            if (decode && PasswordUtil.isEncrypted((String)contents)) {
                try {
                    PasswordUtil.decode((String)contents);
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jndi.internal.JNDIReferenceEntry", (String)"66", (Object)this, (Object[])new Object[]{context, props});
                    Tr.error((TraceComponent)tc, (String)"jndi.decode.failed", (Object[])new Object[]{contents, e});
                }
                sra = new WSEncryptedStringRefAddr(addrType, contents);
            } else {
                sra = new StringRefAddr(addrType, contents);
            }
            ref.add(sra);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("osgi.jndi.service.name", jndiName);
        this.registration = context.registerService(Reference.class.getName(), (Object)ref, properties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("registration=" + this.registration), (Object[])new Object[0]);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }
}

