/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jpa.container.beanvalidation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jpa.container.beanvalidation.ValidatorFactoryLocator;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ValidatorFactory;
import java.util.Locale;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JPAMessageInterpolator
implements MessageInterpolator {
    private static final TraceComponent tc = Tr.register(JPAMessageInterpolator.class, (String)"JPA", (String)"com.ibm.ws.jpa.jpa");
    private MessageInterpolator ivMessageInterpolator = null;
    private final ValidatorFactoryLocator ivValidatorFactoryLocator;
    static final long serialVersionUID = -1113714295108654649L;

    JPAMessageInterpolator(ValidatorFactoryLocator locator) {
        this.ivValidatorFactoryLocator = locator;
    }

    private void obtainMessageInterpolator() {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        ValidatorFactory validatorFactory = this.ivValidatorFactoryLocator.getValidatorFactory();
        this.ivMessageInterpolator = validatorFactory.getMessageInterpolator();
        if (isTraceOn && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Obtained the MessageInterpolator: " + this.ivMessageInterpolator), (Object[])new Object[0]);
        }
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
        if (this.ivMessageInterpolator == null) {
            this.obtainMessageInterpolator();
        }
        return this.ivMessageInterpolator.interpolate(messageTemplate, context);
    }

    public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
        if (this.ivMessageInterpolator == null) {
            this.obtainMessageInterpolator();
        }
        return this.ivMessageInterpolator.interpolate(messageTemplate, context, locale);
    }
}

