/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.security;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.security.Authentication;
import com.ibm.ws.messaging.security.Authorization;
import com.ibm.ws.messaging.security.MessagingSecurityException;
import com.ibm.ws.messaging.security.MessagingSecurityService;
import com.ibm.ws.messaging.security.RuntimeSecurityService;
import com.ibm.ws.messaging.security.authentication.MessagingAuthenticationException;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component(configurationPid={"com.ibm.ws.messaging.security.RuntimeSecurityServiceImpl"}, configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, property={"service.vendor=IBM"})
public class RuntimeSecurityServiceImpl
implements RuntimeSecurityService {
    private static TraceComponent tc = SibTr.register(RuntimeSecurityServiceImpl.class, (String)"MessagingSecurity", (String)"com.ibm.ws.messaging.security.CWWKMMessages");
    private static final String CLASS_NAME = "com.ibm.ws.messaging.security.RuntimeSecurityService";
    private MessagingSecurityService messagingSecurityService = null;
    private final Authentication authentication = new Authentication(this);
    private final Authorization authorization = new Authorization(this);
    private Subject unauthenticatedSubject = null;

    public RuntimeSecurityServiceImpl() {
        String methodName = "RuntimeSecurityServiceImpl";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RuntimeSecurityServiceImpl", (Object)new Object[]{this});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RuntimeSecurityServiceImpl");
        }
    }

    @Activate
    void activate() {
        String methodName = "activate";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"activate", (Object)new Object[]{this, this.messagingSecurityService == null});
        }
    }

    @Reference(service=MessagingSecurityService.class, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setMessagingSecurityService(MessagingSecurityService messagingSecurityService) {
        String methodName = "setMessagingSecurityService";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessagingSecurityService", (Object)new Object[]{this, messagingSecurityService});
        }
        this.messagingSecurityService = messagingSecurityService;
        this.authentication.setMessagingAuthenticationService(messagingSecurityService.getMessagingAuthenticationService());
        this.authorization.setMessagingAuthorizationService(messagingSecurityService.getMessagingAuthorizationService());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessagingSecurityService");
        }
    }

    @Override
    public boolean isMessagingSecure() {
        String methodName = "isMessagingSecure";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMessagingSecure", (Object)this);
        }
        boolean result = false;
        if (this.messagingSecurityService != null) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMessagingSecure", (Object)result);
        }
        return result;
    }

    @Override
    public Subject createUnauthenticatedSubject() {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityServicecreateUnauthenticatedSubject");
        if (this.unauthenticatedSubject == null) {
            this.unauthenticatedSubject = new Subject();
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityServicecreateUnauthenticatedSubject", (Object)this.unauthenticatedSubject);
        return this.unauthenticatedSubject;
    }

    @Override
    public Authentication getAuthenticationInstance() {
        return this.authentication;
    }

    @Override
    public Authorization getAuthorizationInstance() {
        return this.authorization;
    }

    @Override
    public String getUniqueUserName(Subject subject) throws MessagingSecurityException {
        if (!this.isMessagingSecure()) {
            return "";
        }
        return this.messagingSecurityService.getUniqueUserName(subject);
    }

    @Override
    public boolean isUnauthenticated(Subject subject) throws MessagingAuthenticationException {
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityServiceisUnauthenticated", (Object)subject);
        boolean result = false;
        if (!this.isMessagingSecure()) {
            result = false;
        } else {
            try {
                result = this.messagingSecurityService.isUnauthenticated(subject);
            }
            catch (Exception e) {
                throw new MessagingAuthenticationException(e.getMessage());
            }
        }
        SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.messaging.security.RuntimeSecurityServiceisUnauthenticated", (Object)subject);
        return result;
    }

    public String toString() {
        return (this.messagingSecurityService == null ? "-" : "+") + super.toString();
    }
}

