/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.webservices.handler.impl;

import com.ibm.webservices.handler.impl.GlobalHandlerService;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.webservices.handler.Handler;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(immediate=true, property={"service.vendor=IBM"})
public class GlobalHandlerServiceImpl
implements GlobalHandlerService {
    static final String HANDLER = "Handler";
    static final TraceComponent tc = Tr.register(GlobalHandlerServiceImpl.class, (String)"WSSPIHandler", null);
    private final ConcurrentServiceReferenceSet<Handler> jaxwsInFlowClientSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxwsOutFlowClientSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxwsInFlowServerSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxwsOutFlowServerSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxrsInFlowClientSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxrsInFlowServerSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxrsOutFlowClientSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private final ConcurrentServiceReferenceSet<Handler> jaxrsOutFlowServerSideGlobalHandlers = new ConcurrentServiceReferenceSet("Handler");
    private static final AtomicInteger saajCount = new AtomicInteger(0);
    public CopyOnWriteArrayList<Handler> jaxrsInFlowClientSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxrsInFlowServerSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxrsOutFlowClientSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxrsOutFlowServerSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxwsInFlowClientSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxwsOutFlowClientSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxwsInFlowServerSideGlobalHandlers1 = new CopyOnWriteArrayList();
    public CopyOnWriteArrayList<Handler> jaxwsOutFlowServerSideGlobalHandlers1 = new CopyOnWriteArrayList();
    private volatile ComponentContext cContext = null;
    static final String KEY_HANDLERS = "Handler";
    static final long serialVersionUID = 5126418288883714948L;

    @Activate
    protected void activate(ComponentContext cContext, Map<String, Object> properties) throws Exception {
        this.cContext = cContext;
        this.jaxwsInFlowClientSideGlobalHandlers.activate(cContext);
        this.jaxwsOutFlowClientSideGlobalHandlers.activate(cContext);
        this.jaxwsInFlowServerSideGlobalHandlers.activate(cContext);
        this.jaxwsOutFlowServerSideGlobalHandlers.activate(cContext);
        this.jaxrsInFlowClientSideGlobalHandlers.activate(cContext);
        this.jaxrsOutFlowClientSideGlobalHandlers.activate(cContext);
        this.jaxrsInFlowServerSideGlobalHandlers.activate(cContext);
        this.jaxrsOutFlowServerSideGlobalHandlers.activate(cContext);
        this.clearAllList();
        Iterator registeredHandlers = this.jaxwsInFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsInFlowServerSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsOutFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsOutFlowServerSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsInFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsInFlowClientSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsOutFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsOutFlowClientSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsOutFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsOutFlowServerSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsInFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsInFlowServerSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsOutFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsOutFlowClientSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsInFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsInFlowClientSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.cContext = null;
        this.jaxwsInFlowClientSideGlobalHandlers.deactivate(this.cContext);
        this.jaxwsOutFlowClientSideGlobalHandlers.deactivate(this.cContext);
        this.jaxwsInFlowServerSideGlobalHandlers.deactivate(this.cContext);
        this.jaxwsOutFlowServerSideGlobalHandlers.deactivate(this.cContext);
        this.jaxrsInFlowClientSideGlobalHandlers.deactivate(this.cContext);
        this.jaxrsOutFlowClientSideGlobalHandlers.deactivate(this.cContext);
        this.jaxrsInFlowServerSideGlobalHandlers.deactivate(this.cContext);
        this.jaxrsOutFlowServerSideGlobalHandlers.deactivate(this.cContext);
    }

    @Reference(service=Handler.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected synchronized void setHandler(ServiceReference<Handler> handlerrRef) {
        String engineType = handlerrRef.getProperty("engine.type") == null ? "ALL" : (String)handlerrRef.getProperty("engine.type");
        String flowType = handlerrRef.getProperty("flow.type") == null ? "INOUT" : (String)handlerrRef.getProperty("flow.type");
        boolean serverSide = handlerrRef.getProperty("isServerSide") == null ? true : Boolean.parseBoolean(handlerrRef.getProperty("isServerSide").toString());
        boolean clientSide = handlerrRef.getProperty("isClientSide") == null ? true : Boolean.parseBoolean(handlerrRef.getProperty("isClientSide").toString());
        String importPackage = (String)handlerrRef.getBundle().getHeaders("").get("Import-package");
        String dynamicImportPackage = (String)handlerrRef.getBundle().getHeaders("").get("DynamicImport-Package");
        if (importPackage != null && importPackage.contains("jakarta.xml.ws.handler.soap") || dynamicImportPackage != null && dynamicImportPackage.contains("jakarta.xml.ws.handler.soap")) {
            saajCount.getAndIncrement();
        }
        if (engineType.equalsIgnoreCase("JAX_WS")) {
            if (serverSide && flowType.equalsIgnoreCase("IN")) {
                this.jaxwsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (serverSide && flowType.equalsIgnoreCase("OUT")) {
                this.jaxwsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (serverSide && flowType.equalsIgnoreCase("INOUT")) {
                this.jaxwsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxwsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("IN")) {
                this.jaxwsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("OUT")) {
                this.jaxwsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("INOUT")) {
                this.jaxwsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxwsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
        } else if (engineType.equalsIgnoreCase("JAX_RS")) {
            if (serverSide && flowType.equalsIgnoreCase("IN")) {
                this.jaxrsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (serverSide && flowType.equalsIgnoreCase("OUT")) {
                this.jaxrsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (serverSide && flowType.equalsIgnoreCase("INOUT")) {
                this.jaxrsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("IN")) {
                this.jaxrsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("OUT")) {
                this.jaxrsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("INOUT")) {
                this.jaxrsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
        } else if (engineType.equalsIgnoreCase("ALL")) {
            if (serverSide && flowType.equalsIgnoreCase("IN")) {
                this.jaxwsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (serverSide && flowType.equalsIgnoreCase("OUT")) {
                this.jaxwsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (serverSide && flowType.equalsIgnoreCase("INOUT")) {
                this.jaxwsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxwsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsOutFlowServerSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsInFlowServerSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("IN")) {
                this.jaxwsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("OUT")) {
                this.jaxwsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
            if (clientSide && flowType.equalsIgnoreCase("INOUT")) {
                this.jaxwsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxwsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsOutFlowClientSideGlobalHandlers.addReference(handlerrRef);
                this.jaxrsInFlowClientSideGlobalHandlers.addReference(handlerrRef);
            }
        }
        this.clearAllList();
        Iterator registeredHandlers = this.jaxwsInFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsInFlowServerSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsOutFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsOutFlowServerSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsInFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsInFlowClientSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsOutFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsOutFlowClientSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsOutFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsOutFlowServerSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsInFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsInFlowServerSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsOutFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsOutFlowClientSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsInFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsInFlowClientSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
    }

    private synchronized void clearAllList() {
        this.jaxwsInFlowServerSideGlobalHandlers1.clear();
        this.jaxwsOutFlowServerSideGlobalHandlers1.clear();
        this.jaxwsInFlowClientSideGlobalHandlers1.clear();
        this.jaxwsOutFlowClientSideGlobalHandlers1.clear();
        this.jaxrsOutFlowServerSideGlobalHandlers1.clear();
        this.jaxrsInFlowServerSideGlobalHandlers1.clear();
        this.jaxrsOutFlowClientSideGlobalHandlers1.clear();
        this.jaxrsInFlowClientSideGlobalHandlers1.clear();
    }

    protected synchronized void unsetHandler(ServiceReference<Handler> handlerRef) {
        this.jaxwsInFlowClientSideGlobalHandlers.removeReference(handlerRef);
        this.jaxwsOutFlowClientSideGlobalHandlers.removeReference(handlerRef);
        this.jaxwsInFlowServerSideGlobalHandlers.removeReference(handlerRef);
        this.jaxwsOutFlowServerSideGlobalHandlers.removeReference(handlerRef);
        this.jaxrsInFlowClientSideGlobalHandlers.removeReference(handlerRef);
        this.jaxrsOutFlowClientSideGlobalHandlers.removeReference(handlerRef);
        this.jaxrsInFlowServerSideGlobalHandlers.removeReference(handlerRef);
        this.jaxrsOutFlowServerSideGlobalHandlers.removeReference(handlerRef);
        String importPackage = (String)handlerRef.getBundle().getHeaders("").get("Import-package");
        String dynamicImportPackage = (String)handlerRef.getBundle().getHeaders("").get("DynamicImport-Package");
        if (importPackage != null && importPackage.contains("jakarta.xml.ws.handler.soap") || dynamicImportPackage != null && dynamicImportPackage.contains("jakarta.xml.ws.handler.soap")) {
            saajCount.getAndDecrement();
        }
        this.clearAllList();
        Iterator registeredHandlers = this.jaxwsInFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsInFlowServerSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsOutFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsOutFlowServerSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsInFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsInFlowClientSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxwsOutFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxwsOutFlowClientSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsOutFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsOutFlowServerSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsInFlowServerSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsInFlowServerSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsOutFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsOutFlowClientSideGlobalHandlers1.add(0, (Handler)registeredHandlers.next());
        }
        registeredHandlers = this.jaxrsInFlowClientSideGlobalHandlers.getServices();
        while (registeredHandlers.hasNext()) {
            this.jaxrsInFlowClientSideGlobalHandlers1.add((Handler)registeredHandlers.next());
        }
    }

    @Override
    public List<Handler> getJAXWSServerSideInFlowGlobalHandlers() {
        return this.jaxwsInFlowServerSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXWSClientSideInFlowGlobalHandlers() {
        return this.jaxwsInFlowClientSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXWSServerSideOutFlowGlobalHandlers() {
        return this.jaxwsOutFlowServerSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXWSClientSideOutFlowGlobalHandlers() {
        return this.jaxwsOutFlowClientSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXRSServerSideInFlowGlobalHandlers() {
        return this.jaxrsInFlowServerSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXRSClientSideInFlowGlobalHandlers() {
        return this.jaxrsInFlowClientSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXRSServerSideOutFlowGlobalHandlers() {
        return this.jaxrsOutFlowServerSideGlobalHandlers1;
    }

    @Override
    public List<Handler> getJAXRSClientSideOutFlowGlobalHandlers() {
        return this.jaxrsOutFlowClientSideGlobalHandlers1;
    }

    @Override
    public boolean getSaajFlag() {
        boolean result = saajCount.get() > 0;
        return result;
    }
}

