/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session.utils;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.session.ILoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.AccessController;

public class SessionLoader
implements ILoader {
    private static final ThreadContextAccessor threadContextAccessor = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    private final SerializationService _serializationService;
    private ClassLoader _classLoader;

    private static ClassLoader getContextClassLoader() {
        return threadContextAccessor.getContextClassLoaderForUnprivileged(Thread.currentThread());
    }

    public SessionLoader(SerializationService serializationService, ClassLoader classLoader, boolean isApplicationSession) {
        this._serializationService = serializationService;
        this._classLoader = isApplicationSession ? null : classLoader;
    }

    @Override
    public Object loadObject(InputStream inputStream) throws IOException, ClassNotFoundException {
        Object object;
        block4: {
            ClassLoader classLoader = this._classLoader;
            if (classLoader == null) {
                classLoader = SessionLoader.getContextClassLoader();
            }
            ObjectInputStream objectInputStream = this._serializationService.createObjectInputStream(inputStream, classLoader);
            object = null;
            try {
                object = objectInputStream.readObject();
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.session.SessionLoader.loadObject", (String)"82", (Object)this);
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                if (!(t instanceof ClassNotFoundException)) break block4;
                throw (ClassNotFoundException)t;
            }
        }
        return object;
    }
}

