/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.transaction.impl;

import com.ibm.jbatch.container.exception.TransactionManagementException;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.transaction.HeuristicMixedException;
import jakarta.transaction.HeuristicRollbackException;
import jakarta.transaction.NotSupportedException;
import jakarta.transaction.RollbackException;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JTAUserTransactionAdapter
implements TransactionManagerAdapter {
    private static final String CLASSNAME = JTAUserTransactionAdapter.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected UserTransaction userTran = null;
    protected String jndiLoc = null;
    static final long serialVersionUID = -5593719056845391826L;

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JTAUserTransactionAdapter(String jndiLoc) {
        logger.entering(CLASSNAME, "init", jndiLoc);
        this.jndiLoc = jndiLoc;
        try {
            InitialContext ctxt = new InitialContext();
            this.userTran = (UserTransaction)ctxt.lookup(jndiLoc);
            logger.fine("JNDI user transaction manager found");
        }
        catch (NamingException namingException) {
            void ne;
            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"65", (Object)this, (Object[])new Object[]{jndiLoc});
            throw new TransactionManagementException("Caught exception: " + ne.getMessage() + " looking up user transaction at JNDI location:  " + jndiLoc, (Throwable)ne);
        }
        logger.exiting(CLASSNAME, "init");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JTAUserTransactionAdapter() {
        this("java:comp/UserTransaction");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void begin() throws TransactionManagementException {
        logger.entering(CLASSNAME, "begin");
        try {
            this.userTran.begin();
            logger.log(Level.FINE, "jakarta.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (NotSupportedException notSupportedException) {
            void e;
            FFDCFilter.processException((Throwable)notSupportedException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"86", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException((Throwable)e);
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"88", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "begin");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void commit() throws TransactionManagementException {
        logger.entering(CLASSNAME, "commit");
        try {
            this.userTran.commit();
            logger.log(Level.FINE, "jakarta.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (SecurityException securityException) {
            void e;
            FFDCFilter.processException((Throwable)securityException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"103", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException((Throwable)e);
        }
        catch (IllegalStateException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"105", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        catch (RollbackException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"107", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        catch (HeuristicMixedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"109", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        catch (HeuristicRollbackException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"111", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"113", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "commit");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void rollback() throws TransactionManagementException {
        logger.entering(CLASSNAME, "rollback");
        try {
            if (this.userTran.getStatus() != 6) {
                this.userTran.rollback();
            }
            logger.log(Level.FINE, "jakarta.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (IllegalStateException illegalStateException) {
            void e;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"132", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException((Throwable)e);
        }
        catch (SecurityException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"134", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"136", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "rollback");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public int getStatus() throws TransactionManagementException {
        logger.entering(CLASSNAME, "getStatus");
        int status = 0;
        try {
            status = this.userTran.getStatus();
            logger.log(Level.FINE, "jakarta.transaction.Status: {0}", status);
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"153", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "getStatus", status);
        return status;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setRollbackOnly() throws TransactionManagementException {
        logger.entering(CLASSNAME, "setRollbackOnly");
        try {
            this.userTran.setRollbackOnly();
            logger.log(Level.FINE, "jakarta.transaction.Status: {0}", this.userTran.getStatus());
        }
        catch (IllegalStateException illegalStateException) {
            void e;
            FFDCFilter.processException((Throwable)illegalStateException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"169", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException((Throwable)e);
        }
        catch (SystemException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"171", (Object)this, (Object[])new Object[0]);
            throw new TransactionManagementException(e);
        }
        logger.exiting(CLASSNAME, "setRollbackOnly");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setTransactionTimeout(int seconds) throws TransactionManagementException {
        logger.entering(CLASSNAME, "setTransactionTimeout", seconds);
        try {
            this.userTran.setTransactionTimeout(seconds);
        }
        catch (SystemException systemException) {
            void e;
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.jbatch.container.transaction.impl.JTAUserTransactionAdapter", (String)"185", (Object)this, (Object[])new Object[]{seconds});
            throw new TransactionManagementException((Throwable)e);
        }
        logger.exiting(CLASSNAME, "setTransactionTimeout");
    }
}

