/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="jobLogger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JoblogUtil {
    public static final String JobLogLoggerName = "com.ibm.ws.batch.JobLogger";
    private static final Logger jobLogger = Logger.getLogger("com.ibm.ws.batch.JobLogger");
    private static volatile boolean includeServerLogging = true;
    static final long serialVersionUID = -7156212464871826313L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JoblogUtil() {
        if (jobLogger != null && jobLogger.isLoggable(Level.FINER)) {
            jobLogger.entering("com.ibm.jbatch.container.ws.JoblogUtil", "<init>", new Object[0]);
        }
        if (jobLogger != null && jobLogger.isLoggable(Level.FINER)) {
            jobLogger.exiting("com.ibm.jbatch.container.ws.JoblogUtil", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logToJobLogAndTraceOnly(Level level, String msg, Object[] params, Logger traceLogger) {
        String formattedMsg = JoblogUtil.getFormattedMessage(msg, params, "Job event.");
        JoblogUtil.logRawMsgToJobLogAndTraceOnly(level, formattedMsg, traceLogger);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logRawMsgToJobLogAndTraceOnly(Level level, String msg, Logger traceLogger) {
        if (level.intValue() > Level.FINE.intValue()) {
            traceLogger.log(Level.FINE, msg);
            JoblogUtil.logToJoblogIfNotTraceLoggable(Level.FINE, msg, traceLogger);
        } else {
            traceLogger.log(level, msg);
            JoblogUtil.logToJoblogIfNotTraceLoggable(level, msg, traceLogger);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logToJobLogAndTrace(Level level, String msg, Object[] params, Logger traceLogger) {
        String formattedMsg = JoblogUtil.getFormattedMessage(msg, params, "Job event.");
        JoblogUtil.logRawMsgToJobLogAndTrace(level, formattedMsg, traceLogger);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void logRawMsgToJobLogAndTrace(Level level, String msg, Logger traceLogger) {
        JoblogUtil.logToJoblogIfNotTraceLoggable(level, msg, traceLogger);
        JoblogUtil.logToTrace(level, msg, traceLogger);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void logToTrace(Level level, String msg, Logger traceLogger) {
        traceLogger.log(level, msg);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void logToTrace(Level level, String msg, Object[] params, Logger traceLogger) {
        String formattedMsg = JoblogUtil.getFormattedMessage(msg, params, "Job event.");
        traceLogger.log(level, formattedMsg);
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void logToJoblogIfNotTraceLoggable(Level level, String msg, Logger traceLogger) {
        if (includeServerLogging) {
            if (!traceLogger.isLoggable(level)) {
                jobLogger.log(level, msg);
            }
        } else {
            jobLogger.log(level, msg);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getFormattedMessage(String msgKey, Object[] fillIns, String defaultMsg) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.jbatch.container.internal.resources.JBatchMessages");
        if (resourceBundle == null) {
            return defaultMsg;
        }
        String msg = resourceBundle.getString(msgKey);
        return msg != null ? MessageFormat.format(msg, fillIns) : defaultMsg;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void setIncludeServerLogging(boolean include) {
        if (jobLogger != null && jobLogger.isLoggable(Level.FINER)) {
            jobLogger.entering("com.ibm.jbatch.container.ws.JoblogUtil", "setIncludeServerLogging", new Object[]{include});
        }
        includeServerLogging = include;
        if (jobLogger != null && jobLogger.isLoggable(Level.FINER)) {
            jobLogger.exiting("com.ibm.jbatch.container.ws.JoblogUtil", "setIncludeServerLogging");
        }
    }
}

