/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.io.async;

import com.ibm.io.async.AbstractAsyncChannel;
import com.ibm.io.async.AsyncChannelFuture;
import com.ibm.io.async.AsyncTimeoutException;
import com.ibm.io.async.IAsyncFuture;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;

final class AsyncFuture
extends AsyncChannelFuture
implements IAsyncFuture {
    private static final TraceComponent tc = Tr.register(AsyncFuture.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
    private ByteBuffer[] buffers;
    protected volatile long byteCount = -1L;
    protected boolean isRead;
    protected WsByteBuffer jitBuffer = null;
    protected ByteBuffer[] jitBufferArray = new ByteBuffer[1];

    AsyncFuture(AbstractAsyncChannel channel) {
        super(channel);
    }

    void setBuffers(ByteBuffer[] buffers) {
        this.buffers = buffers;
    }

    void setJITBuffer(WsByteBuffer jitBuffer) {
        this.jitBuffer = jitBuffer;
        if (jitBuffer != null) {
            this.jitBufferArray[0] = jitBuffer.getWrappedByteBufferNonSafe();
            this.setBuffers(this.jitBufferArray);
        }
    }

    @Override
    public WsByteBuffer getJITBuffer() {
        return this.jitBuffer;
    }

    protected void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    protected boolean isRead() {
        return this.isRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completed(long bytesAffected) {
        boolean needToFire = true;
        Object object = this.completedSemaphore;
        synchronized (object) {
            if (this.completed || !this.channel.isOpen()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Future completed after already cancelled or socket was closed", (Object[])new Object[0]);
                }
                return;
            }
            this.completed = true;
            if (this.getTimeoutWorkItem() != null) {
                this.getTimeoutWorkItem().state = 2L;
            }
            this.byteCount = bytesAffected;
            long numbytes = bytesAffected;
            for (ByteBuffer buffer : this.buffers) {
                int bufspace = buffer.remaining();
                if (bytesAffected > (long)bufspace) {
                    buffer.position(buffer.limit());
                    numbytes -= (long)bufspace;
                    continue;
                }
                buffer.position(buffer.position() + (int)numbytes);
                numbytes = 0L;
                break;
            }
            if (this.firstListener == null) {
                needToFire = false;
                this.completedSemaphore.notifyAll();
            }
        }
        if (needToFire) {
            this.fireCompletionActions();
        }
    }

    @Override
    public ByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public long readByteCount() {
        return this.byteCount;
    }

    @Override
    public final long getByteCount() throws InterruptedException, IOException {
        try {
            return this.getByteCount(0L);
        }
        catch (AsyncTimeoutException e) {
            if (this.exception != null && this.exception instanceof AsyncTimeoutException) {
                throw (AsyncTimeoutException)this.exception;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected timeout on blocking getByteCount: " + this.exception), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"145", (Object)this);
            IOException ie = new IOException("Unexpected timeout");
            ie.initCause(e);
            throw ie;
        }
    }

    @Override
    public long getByteCount(long timeout) throws InterruptedException, IOException {
        this.waitForCompletion(timeout);
        if (this.exception != null) {
            this.throwException();
        }
        return this.byteCount;
    }

    @Override
    public void resetFuture() {
        super.resetFuture();
        this.setJITBuffer(null);
    }
}

