/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.tcpchannel.internal;

import com.ibm.io.async.AsyncChannelGroup;
import com.ibm.io.async.AsyncException;
import com.ibm.io.async.AsyncLibrary;
import com.ibm.io.async.AsyncSocketChannel;
import com.ibm.io.async.IAsyncProvider;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.tcpchannel.internal.AioReadCompletionListener;
import com.ibm.ws.tcpchannel.internal.AioSocketIOChannel;
import com.ibm.ws.tcpchannel.internal.AioTCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.AioTCPWriteRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.AioWorkQueueManager;
import com.ibm.ws.tcpchannel.internal.AioWriteCompletionListener;
import com.ibm.ws.tcpchannel.internal.ChannelTermination;
import com.ibm.ws.tcpchannel.internal.ConnectionManager;
import com.ibm.ws.tcpchannel.internal.SocketIOChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannel;
import com.ibm.ws.tcpchannel.internal.TCPChannelConfiguration;
import com.ibm.ws.tcpchannel.internal.TCPChannelFactory;
import com.ibm.ws.tcpchannel.internal.TCPConnLink;
import com.ibm.ws.tcpchannel.internal.TCPPort;
import com.ibm.ws.tcpchannel.internal.TCPReadRequestContextImpl;
import com.ibm.ws.tcpchannel.internal.TCPWriteRequestContextImpl;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;

public class AioTCPChannel
extends TCPChannel
implements ChannelTermination {
    private AsyncChannelGroup asyncChannelGroup;
    private static Hashtable<String, AsyncChannelGroup> groups = new Hashtable();
    private static AioReadCompletionListener aioReadCompletionListener = null;
    private static AioWriteCompletionListener aioWriteCompletionListener = null;
    private static boolean jitSupportedByNative;
    private static final TraceComponent tc;
    private static AioWorkQueueManager wqm;

    @Override
    public ChannelTermination setup(ChannelData chanData, TCPChannelConfiguration oTCPChannelConfig, TCPChannelFactory _f) throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setup", (Object[])new Object[0]);
        }
        super.setup(chanData, oTCPChannelConfig, _f);
        try {
            IAsyncProvider provider = AsyncLibrary.createInstance();
            jitSupportedByNative = this.getConfig().getAllocateBuffersDirect() ? provider.hasCapability(4) : false;
        }
        catch (AsyncException ae) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AioTCPChannel couldn't load native AIO library: " + ae.getMessage()), (Object[])new Object[0]);
            }
            throw new ChannelException(ae);
        }
        if (!this.getConfig().isInbound()) {
            boolean startSelectors = false;
            if (wqm == null) {
                wqm = new AioWorkQueueManager();
                startSelectors = true;
            }
            this.connectionManager = new ConnectionManager(this, wqm);
            if (startSelectors) {
                boolean startImmediately = true;
                wqm.startSelectors(false, startImmediately);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setup");
        }
        return this;
    }

    @Override
    public void init() throws ChannelException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object[])new Object[0]);
        }
        super.init();
        if (!this.getConfig().isInbound()) {
            try {
                this.asyncChannelGroup = this.findOrCreateACG();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Created completion port for outbound connections, completionPort = " + this.asyncChannelGroup.getCompletionPort()), (Object[])new Object[0]);
                }
            }
            catch (AsyncException ae) {
                ChannelException ce = new ChannelException("Error creating async channel group ");
                ce.initCause(ae);
                throw ce;
            }
        }
        aioReadCompletionListener = new AioReadCompletionListener();
        aioWriteCompletionListener = new AioWriteCompletionListener();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    @Override
    public void start() throws ChannelException {
        super.start();
        this.getAsyncChannelGroup().activate();
    }

    @Override
    public void terminate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"terminate", (Object[])new Object[0]);
        }
        AsyncLibrary.shutdown();
        groups.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    @Override
    public TCPPort createEndPoint() throws ChannelException {
        TCPPort tcpPort = super.createEndPoint();
        try {
            this.asyncChannelGroup = this.findOrCreateACG();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("AioTCPChannel created completion port for inbound connections on host " + this.getConfig().getHostname() + ", port " + this.getConfig().getPort() + ", completionPort = " + this.asyncChannelGroup.getCompletionPort()), (Object[])new Object[0]);
            }
        }
        catch (AsyncException ae) {
            ChannelException ce = new ChannelException("Error creating async channel group ");
            ce.initCause(ae);
            throw ce;
        }
        return tcpPort;
    }

    private AsyncChannelGroup findOrCreateACG() throws AsyncException {
        String groupName;
        AsyncChannelGroup group;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findOrCreateACG", (Object[])new Object[0]);
        }
        if ((group = groups.get(groupName = this.getConfig().getWorkGroupName())) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("create new AsyncChannelGroup: " + groupName), (Object[])new Object[0]);
            }
            group = new AsyncChannelGroup(groupName);
            groups.put(groupName, group);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findOrCreateACG");
        }
        return group;
    }

    @Override
    public TCPReadRequestContextImpl createReadInterface(TCPConnLink connLink) {
        return new AioTCPReadRequestContextImpl(connLink);
    }

    @Override
    public TCPWriteRequestContextImpl createWriteInterface(TCPConnLink connLink) {
        return new AioTCPWriteRequestContextImpl(connLink);
    }

    public static AioReadCompletionListener getAioReadCompletionListener() {
        return aioReadCompletionListener;
    }

    public static AioWriteCompletionListener getAioWriteCompletionListener() {
        return aioWriteCompletionListener;
    }

    public static boolean getJitSupportedByNative() {
        return jitSupportedByNative;
    }

    @Override
    public SocketIOChannel createOutboundSocketIOChannel() throws IOException {
        AsyncSocketChannel achannel = AsyncSocketChannel.open(this.getAsyncChannelGroup());
        Socket socket = achannel.socket();
        return AioSocketIOChannel.createIOChannel(socket, achannel, this);
    }

    @Override
    public SocketIOChannel createInboundSocketIOChannel(SocketChannel sc) throws IOException {
        AsyncSocketChannel asc = new AsyncSocketChannel(sc, this.getAsyncChannelGroup());
        return AioSocketIOChannel.createIOChannel(sc.socket(), asc, this);
    }

    protected AsyncChannelGroup getAsyncChannelGroup() {
        return this.asyncChannelGroup;
    }

    @Override
    protected void dumpStatistics() {
        super.dumpStatistics();
        this.asyncChannelGroup.dumpStatistics();
    }

    static {
        tc = Tr.register(AioTCPChannel.class, (String)"TCPChannel", (String)"com.ibm.ws.tcpchannel.internal.resources.TCPChannelMessages");
        wqm = null;
    }
}

