/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;

public class FramePushPromise
extends Frame {
    int promisedStreamID = 0;
    public byte[] headerBlockFragment = null;
    int paddingLength = 0;

    public FramePushPromise(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.PUSH_PROMISE;
    }

    public FramePushPromise(int streamId, byte[] headerBlockFragment, int promisedStream, int paddingLength, boolean endHeaders, boolean padded, boolean reserveBit) {
        super(streamId, headerBlockFragment.length + 4, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.headerBlockFragment = headerBlockFragment;
        this.paddingLength = paddingLength;
        this.PADDED_FLAG = padded;
        this.END_HEADERS_FLAG = endHeaders;
        this.reservedBit = reserveBit;
        this.promisedStreamID = promisedStream;
        if (padded) {
            this.payloadLength += paddingLength + 1;
        }
        this.frameType = FrameTypes.PUSH_PROMISE;
        this.writeFrameLength += this.payloadLength;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.setFlags();
        int payloadIndex = 0;
        byte paddingLength = 0;
        if (this.PADDED_FLAG) {
            paddingLength = frp.grabNextByte();
            ++payloadIndex;
        }
        byte nextPayloadByte = frp.grabNextByte();
        ++payloadIndex;
        this.reservedBit = utils.getReservedBit(nextPayloadByte);
        nextPayloadByte = (byte)(nextPayloadByte & 0x7F);
        this.promisedStreamID = frp.grabNext24BitInt(nextPayloadByte);
        int headerBlockLength = this.payloadLength - (payloadIndex += 3) - paddingLength;
        this.headerBlockFragment = new byte[headerBlockLength];
        int i = 0;
        while (payloadIndex++ < this.payloadLength - paddingLength) {
            this.headerBlockFragment[i++] = frp.grabNextByte();
        }
        if (this.PADDED_FLAG) {
            while (payloadIndex++ < this.payloadLength) {
                frp.grabNextByte();
            }
        }
    }

    @Override
    public WsByteBuffer buildFrameForWrite() {
        int i;
        WsByteBuffer buffer = super.buildFrameForWrite();
        byte[] frame = buffer.hasArray() ? buffer.array() : super.createFrameArray();
        this.setFrameHeaders(frame, (byte)5);
        int frameIndex = 9;
        if (this.PADDED_FLAG) {
            utils.Move8BitstoByteArray(this.paddingLength, frame, frameIndex);
            ++frameIndex;
        }
        utils.Move31BitstoByteArray(this.promisedStreamID, frame, frameIndex);
        frameIndex += 4;
        for (i = 0; i < this.headerBlockFragment.length; ++i) {
            frame[frameIndex] = this.headerBlockFragment[i];
            ++frameIndex;
        }
        for (i = 0; i < this.paddingLength; ++i) {
            frame[frameIndex] = 0;
            ++frameIndex;
        }
        buffer.put(frame, 0, this.writeFrameLength);
        buffer.flip();
        return buffer;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.streamId == 0) {
            throw new ProtocolException("PUSH_PROMISE Frame stream ID cannot be 0x0");
        }
        if (this.getPayloadLength() > settings.getMaxFrameSize()) {
            throw new FrameSizeException("PUSH_PROMISE payload greater than max allowed");
        }
        if (this.paddingLength >= this.payloadLength) {
            throw new ProtocolException("PUSH_PROMISE padding length must be less than the length of the payload");
        }
    }

    @Override
    protected void setFlags() {
        this.END_HEADERS_FLAG = utils.getFlag(this.flags, 2);
        this.PADDED_FLAG = utils.getFlag(this.flags, 3);
    }

    public int getPromisedStreamId() {
        return this.promisedStreamID;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public byte[] getHeaderBlockFragment() {
        return this.headerBlockFragment;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("FrameReserveBit: ").append(this.getFrameReserveBit()).append("\n");
        frameToString.append("PaddingLength: ").append(this.getPaddingLength()).append("\n");
        frameToString.append("PromisedStreamID: ").append(this.getPromisedStreamId()).append("\n");
        return frameToString.toString();
    }
}

