/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.cookies;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.genericbnf.internal.GenericUtils;
import com.ibm.ws.http.channel.internal.values.CookieData;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import java.util.LinkedList;
import java.util.List;

public class CookieHeaderByteParser {
    private static final TraceComponent tc = Tr.register(CookieHeaderByteParser.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private int bytePosition = 0;
    private byte[] name;
    private byte[] value;
    private boolean useEE10Cookies;

    public List<HttpCookie> parse(byte[] headerValue, HeaderKeys cookieHeader) throws IllegalArgumentException {
        if (null == headerValue) {
            throw new IllegalArgumentException("Null input");
        }
        this.name = null;
        this.value = null;
        this.bytePosition = 0;
        this.useEE10Cookies = HttpDispatcher.useEE10Cookies();
        CookieData token = null;
        HttpCookie cookie = null;
        LinkedList<HttpCookie> cookiesList = new LinkedList<HttpCookie>();
        int version = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("parse [" + GenericUtils.nullOutPasswords(headerValue, (byte)38) + "] " + cookieHeader), (Object[])new Object[0]);
        }
        while (this.bytePosition < headerValue.length) {
            token = this.matchAndParse(headerValue, cookieHeader);
            this.parseValue(headerValue, token);
            if (null == token) {
                if (null != this.name && 0 != this.name.length) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Creating cookie, version " + version), (Object[])new Object[0]);
                    }
                    try {
                        cookie = new HttpCookie(GenericUtils.getEnglishString(this.name), GenericUtils.getEnglishString(this.value));
                    }
                    catch (IllegalArgumentException iae) {
                        this.name = null;
                        this.value = null;
                        continue;
                    }
                    cookie.setVersion(version);
                    cookiesList.add(cookie);
                }
            } else if (null != this.value) {
                if (CookieData.cookieVersion.equals(token)) {
                    try {
                        version = GenericUtils.asIntValue(this.value);
                        if (null != cookie) {
                            cookie.setVersion(version);
                        }
                    }
                    catch (NumberFormatException ne) {
                        FFDCFilter.processException((Throwable)ne, (String)(this.getClass().getName() + ".parse"), (String)"166");
                        version = 0;
                    }
                } else if (null != cookie) {
                    token.set(cookie, this.value);
                }
            }
            token = null;
            this.name = null;
            this.value = null;
        }
        return cookiesList;
    }

    private CookieData matchAndParse(byte[] data, HeaderKeys hdr) {
        boolean foundDollar;
        byte b;
        int pos;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"matchAndParse  Entry", (Object[])new Object[0]);
        }
        int start = -1;
        int stop = -1;
        for (pos = this.bytePosition; pos < data.length && 61 != (b = data[pos]); ++pos) {
            if (59 == b || 44 == b) {
                if (-1 == start) continue;
                --pos;
                break;
            }
            if (32 == b || 9 == b) continue;
            if (-1 == start) {
                start = pos;
            }
            stop = pos;
        }
        this.bytePosition = pos + 1;
        if (-1 == start) {
            return null;
        }
        if (-1 == stop) {
            stop = pos;
        } else if (data.length == stop) {
            --stop;
        }
        boolean bl = foundDollar = 36 == data[start];
        if (foundDollar) {
            ++start;
        } else if (34 == data[start] && 34 == data[stop]) {
            ++start;
            --stop;
        }
        int len = stop - start + 1;
        if (0 >= len) {
            return null;
        }
        CookieData token = CookieData.match(data, start, len);
        if (null != token && null != hdr) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"matchAndParse", (Object[])new Object[]{" token name [" + token.getName() + "] , foundDollar [" + foundDollar + "]"});
            }
            if (this.useEE10Cookies) {
                if (foundDollar) {
                    String cName = token.getName();
                    if (cName.equalsIgnoreCase("version")) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"matchAndParse", (Object[])new Object[]{" dollar version "});
                        }
                        if (!token.validForHeader(hdr, foundDollar)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Token not valid for header, " + hdr + " " + token), (Object[])new Object[0]);
                            }
                            token = null;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"matchAndParse", (Object[])new Object[]{" dollar " + cName + " , token [" + token + "]"});
                        }
                        token = null;
                    }
                } else if (!token.validForHeader(hdr, foundDollar)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Token not valid for header, " + hdr + " " + token), (Object[])new Object[0]);
                    }
                    token = null;
                }
            } else if (!token.validForHeader(hdr, foundDollar)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token not valid for header, " + hdr + " " + token), (Object[])new Object[0]);
                }
                token = null;
            }
        }
        if (null == token) {
            if (foundDollar && this.useEE10Cookies) {
                --start;
                ++len;
            }
            this.name = new byte[len];
            System.arraycopy(data, start, this.name, 0, len);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("name: " + GenericUtils.getEnglishString(this.name)), (Object[])new Object[0]);
            }
        }
        return token;
    }

    private void parseValue(byte[] data, CookieData token) {
        int len;
        byte b;
        int pos;
        int start = -1;
        int stop = -1;
        int num_quotes = 0;
        for (pos = this.bytePosition; pos < data.length && 59 != (b = data[pos]); ++pos) {
            if (34 == b) {
                ++num_quotes;
            }
            if (44 == b && (!CookieData.cookiePort.equals(token) ? !CookieData.cookieExpires.equals(token) : 2 <= num_quotes)) break;
            if (32 == b || 9 == b) continue;
            if (-1 == start) {
                start = pos;
            }
            stop = pos;
        }
        this.bytePosition = pos + 1;
        if (-1 == start) {
            this.value = new byte[0];
            return;
        }
        if (-1 == stop) {
            this.value = new byte[0];
            return;
        }
        if (34 == data[start] && 34 == data[stop]) {
            ++start;
            --stop;
        }
        if (0 <= (len = stop - start + 1)) {
            this.value = new byte[len];
            if (0 < len) {
                System.arraycopy(data, start, this.value, 0, len);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("value: " + GenericUtils.nullOutPasswords(this.value, (byte)38)), (Object[])new Object[0]);
                }
            }
        }
    }
}

