/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collective.member.internal.publisher;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.collective.member.internal.publisher.MBeanAttributeDiscovery;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collective.repository.publisher.RepositoryPublisher;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ServerQuiesceListener.class}, immediate=true, property={"service.vendor=IBM"})
public class DynamicMBeanDiscovery
implements ServiceTrackerCustomizer<Object, ServiceReference<?>>,
NotificationListener,
NotificationFilter,
ServerQuiesceListener {
    private static final TraceComponent tc = Tr.register(DynamicMBeanDiscovery.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
    private static final long serialVersionUID = 1L;
    private EventAdmin eventAdmin;
    private ScheduledExecutorService executorService;
    private BundleContext bc;
    private ServiceTracker<Object, ServiceReference<?>> mbeanTracker;
    private final Map<String, Map<String, AttributeChangeNotification>> mBeanAttrs = new HashMap<String, Map<String, AttributeChangeNotification>>();
    private final Set<String> removedMBeans = new HashSet<String>();
    private final Map<String, Long> reincarnatedMBeans = new HashMap<String, Long>();
    private final AtomicBoolean isServerStopping = new AtomicBoolean(false);

    @Reference(service=EventAdmin.class)
    protected void setEventAdminService(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unsetEventAdminService(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    @Reference(service=RepositoryPublisher.class)
    protected void setRepositoryPublisher(RepositoryPublisher ref) {
    }

    protected void unsetRepositoryPublisher(RepositoryPublisher ref) {
    }

    @Reference(service=ScheduledExecutorService.class)
    protected void setExecutorService(ScheduledExecutorService service) {
        this.executorService = service;
    }

    protected void unsetExecutorService(ScheduledExecutorService service) {
        if (this.executorService == service) {
            this.executorService = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Activate
    protected void activate(ComponentContext cc) {
        this.bc = cc.getBundleContext();
        HashMap<String, String> eventProps = new HashMap<String, String>();
        eventProps.put("operation", "DELETE");
        eventProps.put("dataName", "sys.mbeans");
        this.eventAdmin.postEvent(new Event("com/ibm/wsspi/collective/repository/publish/data", eventProps));
        try {
            this.mbeanTracker = new ServiceTracker(this.bc, this.bc.createFilter("(jmx.objectname=*)"), (ServiceTrackerCustomizer)this);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void ise;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery", (String)"158", (Object)this, (Object[])new Object[]{cc});
            throw new RuntimeException("InvalidSyntaxException while registering ServiceTracker. This is VERY unexpected.", (Throwable)ise);
        }
        this.executorService.submit(new OpenTracker(this.mbeanTracker));
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.isServerStopping.set(true);
        this.mbeanTracker.close();
    }

    public void serverStopping() {
        this.isServerStopping.set(true);
        this.mbeanTracker.close();
    }

    public ServiceReference<?> addingService(ServiceReference<Object> reference) {
        String objectName = (String)reference.getProperty("jmx.objectname");
        if (objectName != null) {
            this.setMBean(reference, objectName);
        }
        return reference;
    }

    public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
    }

    public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
        this.unsetMBean(reference);
    }

    /*
     * WARNING - void declaration
     */
    private void setMBean(ServiceReference<Object> ref, String objectName) {
        block3: {
            String publishAttrsOverride;
            Object mbean = this.bc.getService(ref);
            if (this.shouldPublishAttributes(mbean, publishAttrsOverride = (String)ref.getProperty("publishAttributesToCollectiveController"))) {
                try {
                    this.publishMBean(mbean, objectName);
                }
                catch (NotCompliantMBeanException notCompliantMBeanException) {
                    void e;
                    FFDCFilter.processException((Throwable)notCompliantMBeanException, (String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery", (String)"254", (Object)this, (Object[])new Object[]{ref, objectName});
                    if (!tc.isEventEnabled()) break block3;
                    Tr.event((TraceComponent)tc, (String)"Unexpected NotCompliantMBeanException during setMBean", (Object[])new Object[]{e});
                }
            }
        }
    }

    private boolean shouldPublishAttributes(Object mbean, String publishAttrsOverride) {
        return this.doesMBeanEmitAttributeChangeNotifications(mbean) && publishAttrsOverride == null || Boolean.valueOf(publishAttrsOverride) != false;
    }

    private boolean doesMBeanEmitAttributeChangeNotifications(Object mbean) {
        MBeanNotificationInfo[] infos;
        if (mbean instanceof NotificationBroadcaster && (infos = ((NotificationBroadcaster)mbean).getNotificationInfo()) != null) {
            for (MBeanNotificationInfo info : infos) {
                if (!AttributeChangeNotification.class.getName().equals(info.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void unsetMBean(ServiceReference<Object> ref) {
        if (!this.isServerStopping.get() && !FrameworkState.isStopping()) {
            Object mbean = this.bc.getService(ref);
            this.unpublishMBean(mbean, (String)ref.getProperty("jmx.objectname"));
        }
    }

    private synchronized void publishMBean(Object mbean, String objectName) throws NotCompliantMBeanException {
        if (this.removedMBeans.contains(objectName)) {
            this.reincarnatedMBeans.put(objectName, System.currentTimeMillis());
            this.removedMBeans.remove(objectName);
        }
        if (mbean instanceof NotificationBroadcaster) {
            ((NotificationBroadcaster)mbean).addNotificationListener(this, this, objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registered the collective repository NotificationListener (for AttributeChanges) with MBean", (Object[])new Object[]{mbean});
            }
        }
        List<Attribute> attrs = MBeanAttributeDiscovery.discoverAttributes(mbean);
        for (Attribute attr : attrs) {
            this.safePostEvent(this.createPublishMBeanAttributeUpdateEvent(objectName, attr.getName(), attr.getValue(), false));
        }
    }

    private void safePostEvent(Event event) {
        if (this.eventAdmin != null) {
            this.eventAdmin.postEvent(event);
        }
    }

    @FFDCIgnore(value={ListenerNotFoundException.class})
    private synchronized void unpublishMBean(Object mbean, String objectName) {
        block3: {
            this.mBeanAttrs.remove(objectName);
            this.removedMBeans.add(objectName);
            this.reincarnatedMBeans.remove(objectName);
            this.safePostEvent(this.createPublishDeleteMBeanEvent(objectName));
            if (mbean instanceof NotificationBroadcaster) {
                try {
                    ((NotificationBroadcaster)mbean).removeNotificationListener(this);
                }
                catch (ListenerNotFoundException e) {
                    if (!tc.isEventEnabled()) break block3;
                    Tr.event((TraceComponent)tc, (String)"Unexpected ListenerNotFoundException during unpublishMBean", (Object[])new Object[]{e});
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void handleNotification(Notification notification, Object handback) {
        block6: {
            try {
                AttributeChangeNotification acn = (AttributeChangeNotification)notification;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)this.showAttrNotifInfo(acn), (Object[])new Object[0]);
                }
                if (this.validateNotificationOrder(acn)) {
                    this.safePostEvent(this.createPublishMBeanAttributeUpdateOnlyEvent(acn, (String)handback));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Skip publishing this earlier notification: " + this.showAttrNotifInfo(acn)), (Object[])new Object[0]);
                }
            }
            catch (Exception acn) {
                void e;
                FFDCFilter.processException((Throwable)acn, (String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery", (String)"436", (Object)this, (Object[])new Object[]{notification, handback});
                if (!tc.isEventEnabled()) break block6;
                Tr.event((TraceComponent)tc, (String)"Unexpected Exception while handling notification", (Object[])new Object[]{e});
            }
        }
    }

    private boolean validateNotificationOrder(AttributeChangeNotification acn) {
        boolean isValid = false;
        Map<String, AttributeChangeNotification> attrs = null;
        if (!this.isObsoleteNotification(acn)) {
            attrs = this.getAttributeMap(acn);
            AttributeChangeNotification prevAcn = attrs.get(acn.getAttributeName());
            if (prevAcn == null) {
                isValid = true;
            } else if (acn.getTimeStamp() > prevAcn.getTimeStamp()) {
                isValid = true;
            } else if (acn.getTimeStamp() == prevAcn.getTimeStamp() && acn.getSequenceNumber() > prevAcn.getSequenceNumber()) {
                isValid = true;
            }
        }
        if (isValid) {
            attrs.put(acn.getAttributeName(), acn);
        }
        return isValid;
    }

    private boolean isObsoleteNotification(AttributeChangeNotification acn) {
        Long notificationTime;
        boolean isObsolete = false;
        Long creationTime = this.reincarnatedMBeans.get(acn.getSource());
        if (creationTime != null && (notificationTime = Long.valueOf(acn.getTimeStamp())) < creationTime) {
            isObsolete = true;
        }
        return isObsolete;
    }

    private Map<String, AttributeChangeNotification> getAttributeMap(AttributeChangeNotification acn) {
        Map<String, AttributeChangeNotification> attrs = this.mBeanAttrs.get(acn.getSource());
        if (attrs == null) {
            attrs = new HashMap<String, AttributeChangeNotification>();
            this.mBeanAttrs.put(acn.getSource().toString(), attrs);
        }
        return attrs;
    }

    private Event createPublishMBeanAttributeUpdateEvent(String objectName, String attrName, Object attrValue, boolean updateOnly) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (updateOnly) {
            props.put("operation", "UPDATE_ONLY");
        } else {
            props.put("operation", "UPDATE");
        }
        props.put("sendStatusEvent", "true");
        props.put("mbeanObjectName", objectName);
        props.put("mbeanAttributeName", attrName);
        props.put("mbeanAttributeValue", attrValue);
        return new Event("com/ibm/wsspi/collective/repository/publish/mbean", props);
    }

    private Event createPublishMBeanAttributeUpdateOnlyEvent(AttributeChangeNotification acn, String objectName) {
        if (objectName == null) {
            throw new IllegalArgumentException("ObjectName handback was null for AttributeChangeNotification: " + acn);
        }
        return this.createPublishMBeanAttributeUpdateEvent(objectName, acn.getAttributeName(), acn.getNewValue(), true);
    }

    private Event createPublishDeleteMBeanEvent(String objectName) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("operation", "DELETE");
        props.put("mbeanObjectName", objectName);
        return new Event("com/ibm/wsspi/collective/repository/publish/mbean", props);
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        return notification instanceof AttributeChangeNotification;
    }

    private String showAttrNotifInfo(AttributeChangeNotification acn) {
        StringBuffer sb = new StringBuffer();
        sb.append("AttributeName=");
        sb.append(acn.getAttributeName());
        sb.append(", OldValue=");
        sb.append(acn.getOldValue());
        sb.append(", NewValue=");
        sb.append(acn.getNewValue());
        sb.append(", SequenceNumber=");
        sb.append(acn.getSequenceNumber());
        sb.append(", TimeStamp=");
        sb.append(acn.getTimeStamp());
        return sb.toString();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class OpenTracker
    implements Callable<Void> {
        private final ServiceTracker<Object, ServiceReference<?>> mbeanTracker;
        static final long serialVersionUID = -4448367959580358443L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public OpenTracker(ServiceTracker<Object, ServiceReference<?>> mbeanTracker) {
            this.mbeanTracker = mbeanTracker;
        }

        @Override
        public Void call() {
            if (DynamicMBeanDiscovery.this.isServerStopping.get() || FrameworkState.isStopping()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"OpenTracker invoked while the server or framework is stopping, or it was canceled. Do nothing.", (Object[])new Object[0]);
                }
                return null;
            }
            this.mbeanTracker.open();
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.collective.member.internal.publisher.DynamicMBeanDiscovery$OpenTracker", OpenTracker.class, (String)"Collective", (String)"com.ibm.ws.collective.member.internal.resources.CollectiveMemberMessages");
        }
    }
}

