/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Trivial
public class MapDictionary<K, V>
extends Dictionary<K, V>
implements Map<K, V> {
    private Map<K, V> localMap = new HashMap();
    private boolean isReadOnly = false;

    @Trivial
    public MapDictionary() {
    }

    public MapDictionary(Map<K, V> source) {
        this();
        if (source != null) {
            this.localMap.putAll(source);
        }
    }

    public void setReadOnly(boolean flag) {
        if (!this.isReadyOnly()) {
            this.isReadOnly = flag;
        }
    }

    public boolean isReadyOnly() {
        return this.isReadOnly;
    }

    @Override
    public Enumeration<V> elements() {
        return new DictionaryEnumeration<V>(this.values().iterator());
    }

    @Override
    public Enumeration<K> keys() {
        return new DictionaryEnumeration<K>(this.keySet().iterator());
    }

    @Override
    public V get(Object key) {
        return this.localMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.localMap.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        if (this.isReadyOnly()) {
            throw new UnsupportedOperationException("Can't add property to read-only dictionary");
        }
        return this.localMap.put(key, value);
    }

    @Override
    public V remove(Object key) {
        if (this.isReadyOnly()) {
            throw new UnsupportedOperationException("Can't remove property from read-only dictionary");
        }
        return this.localMap.remove(key);
    }

    @Override
    public int size() {
        return this.localMap.size();
    }

    @Override
    public void clear() {
        if (this.isReadyOnly()) {
            throw new UnsupportedOperationException("Can't clear read-only dictionary");
        }
        this.localMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.localMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.localMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> localSet = this.localMap.entrySet();
        if (this.isReadyOnly()) {
            return Collections.unmodifiableSet(localSet);
        }
        return localSet;
    }

    @Override
    public Set<K> keySet() {
        Set<K> localSet = this.localMap.keySet();
        if (this.isReadyOnly()) {
            return Collections.unmodifiableSet(localSet);
        }
        return localSet;
    }

    @Override
    public Collection<V> values() {
        Collection<V> localValues = this.localMap.values();
        if (this.isReadyOnly()) {
            return Collections.unmodifiableCollection(localValues);
        }
        return localValues;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.isReadyOnly()) {
            throw new UnsupportedOperationException("Can't add properties to read-only dictionary");
        }
        this.localMap.putAll(map);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class DictionaryEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> localIterator;
        static final long serialVersionUID = 5201200512507886763L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public DictionaryEnumeration(Iterator<T> iterator) {
            this.localIterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.localIterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.localIterator.next();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.event.internal.MapDictionary$DictionaryEnumeration", DictionaryEnumeration.class, (String)"EventEngine", null);
        }
    }
}

