/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.tagfilescan.TagFileScanResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class ParsedTagFileElement {
    String path;
    String tagFileName;
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    protected static final Level logLevel = Level.FINEST;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.ParsedTagFileElement";
    static final long serialVersionUID = 8078486868781451188L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ParsedTagFileElement(String path, String tagFileName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{path, tagFileName});
        }
        this.path = path;
        this.tagFileName = tagFileName;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JspCoreException.class})
    public TagFileInfo createTagFileObject(TagLibraryInfoImpl tli, JspTranslationContext ctxt, JspInputSource tagFileInputSource, JspOptions jspOptions, JspConfigurationManager configManager) {
        TagFileInfo tfi;
        block6: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "createTagFileObject", new Object[]{tli, ctxt, tagFileInputSource, jspOptions, configManager});
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "createTagFileObject", "about to do createTagFileObject for = [" + this.path + " " + this.tagFileName + "]");
            }
            tfi = null;
            try {
                JspTranslator jspTranslator = JspTranslatorFactory.getFactory().createTranslator("TagFileScan", tagFileInputSource, ctxt, configManager.createJspConfiguration(), jspOptions, new HashMap());
                JspVisitorInputMap inputMap = new JspVisitorInputMap();
                inputMap.put("TagLibraryInfo", tli);
                inputMap.put("TagFileName", this.tagFileName);
                inputMap.put("TagFilePath", this.path);
                HashMap results = jspTranslator.processVisitors(inputMap);
                TagFileScanResult result = (TagFileScanResult)results.get("TagFileScan");
                tfi = new TagFileInfo(this.tagFileName, this.path, result.getTagInfo());
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(logLevel)) {
                    logger.logp(logLevel, CLASS_NAME, "createTagFileObject", "Finished createTagFileObject for  = [" + this.path + " " + this.tagFileName + "]  TagFileInfo tfi= [" + tfi + "]");
                }
            }
            catch (JspCoreException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block6;
                logger.logp(Level.FINE, CLASS_NAME, "createTagFileObject", "exception creating a tag-file object", e);
            }
        }
        TagFileInfo tagFileInfo = tfi;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagFileInfo = tagFileInfo;
            logger.exiting(CLASS_NAME, "createTagFileObject", tagFileInfo);
        }
        return tagFileInfo;
    }
}

