/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.taglib.TagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.tools.JspFileUtils;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.JspTranslator;
import com.ibm.ws.jsp.translator.JspTranslatorFactory;
import com.ibm.ws.jsp.translator.utils.FileLocker;
import com.ibm.ws.jsp.translator.utils.JspTranslationResult;
import com.ibm.ws.jsp.translator.utils.SDEInstaller;
import com.ibm.ws.jsp.translator.utils.SmapGenerator;
import com.ibm.ws.jsp.translator.utils.TagFileId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.smap.SmapVisitorResult;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.context.translation.JspTranslationContext;
import com.ibm.wsspi.jsp.resource.JspClassFactory;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import com.ibm.wsspi.jsp.resource.translation.TagFileResources;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import jakarta.servlet.jsp.tagext.TagFileInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class JspTranslatorUtil {
    private static final String JSP_TRANSLATION_ID = "JspTranslation";
    private static final String DEBUG_JSP_TRANSLATION_ID = "DebugJspTranslation";
    private static final String TAGFILE_TRANSLATION_ID = "TagFileTranslation";
    private static final String DEBUG_TAGFILE_TRANSLATION_ID = "DebugTagFileTranslation";
    private static final String IN_MEMORY_JSP_TRANSLATION_ID = "InMemoryJspTranslation";
    private static final String IN_MEMORY_DEBUG_JSP_TRANSLATION_ID = "InMemoryDebugJspTranslation";
    private static final String IN_MEMORY_TAGFILE_TRANSLATION_ID = "InMemoryTagFileTranslation";
    private static final String IN_MEMORY_DEBUG_TAGFILE_TRANSLATION_ID = "InMemoryDebugTagFileTranslation";
    private static String separatorString = System.getProperty("line.separator");
    private static final long NANOS_IN_A_MILLISECOND = 1000000L;
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil";
    static final long serialVersionUID = 8661736200554361279L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspTranslatorUtil() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JspCompilerResult translateJspAndCompile(JspResources jspResources, JspTranslationContext context, JspConfiguration config, JspOptions options, TagLibraryCache tlc, boolean forceTagFileTranslation, List compilerOptions) throws JspCoreException {
        if (JspTranslatorUtil.logger != null && JspTranslatorUtil.logger.isLoggable(Level.FINER)) {
            JspTranslatorUtil.logger.entering("com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", new Object[]{jspResources, context, config, options, tlc, forceTagFileTranslation, compilerOptions});
        }
        fileLock = true;
        isZOS = options.isZOS();
        compileResult = null;
        startTranslationTime = System.nanoTime();
        zosFileLocker = null;
        if (isZOS && !options.isUseInMemory() && (zosFileLocker = (FileLocker)new JspClassFactory().getInstanceOf("FileLocker")) != null) {
            fileLock = zosFileLocker.obtainFileLock(jspResources.getInputSource().getRelativeURL());
            if (JspTranslatorUtil.logger.isLoggable(Level.FINE)) {
                JspTranslatorUtil.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "obtainFileLock [" + jspResources.getInputSource().getRelativeURL() + "] -> [" + fileLock + "]");
            }
        }
        if (fileLock) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && JspTranslatorUtil.logger.isLoggable(Level.FINE)) {
                    JspTranslatorUtil.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "begin translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                }
                translationResult = null;
                try {
                    translationResult = JspTranslatorUtil.translateJsp(jspResources, context, config, options, tlc, forceTagFileTranslation, compilerOptions);
                }
                catch (JspTranslationException e) {
                    filePath = e.getFilePath();
                    finalException = null;
                    if (filePath != null && !filePath.equals(jspResources.getInputSource().getRelativeURL())) {
                        finalException = new JspTranslationException("jsp.error.exception.caught.translating.included.file", new Object[]{jspResources.getInputSource().getRelativeURL(), JspTranslatorUtil.separatorString + e.getLocalizedMessage() + JspTranslatorUtil.separatorString});
                    } else {
                        msg = jspResources.getInputSource().getRelativeURL() + ":  " + JspTranslatorUtil.separatorString + e.getLocalizedMessage() + JspTranslatorUtil.separatorString;
                        finalException = new JspTranslationException("jsp.error.exception.caught.translating", new Object[]{msg});
                    }
                    finalException.initCause(e);
                    finalException.setStackTrace(e.getStackTrace());
                    throw finalException;
                }
                endTranslationTime = System.nanoTime();
                if (TraceComponent.isAnyTracingEnabled() && JspTranslatorUtil.logger.isLoggable(Level.FINE)) {
                    JspTranslatorUtil.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "completed translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "] time = " + (endTranslationTime - startTranslationTime) / 1000000L + "ms");
                }
                if (TraceComponent.isAnyTracingEnabled() && JspTranslatorUtil.logger.isLoggable(Level.FINEST)) {
                    JspTranslatorUtil.logger.logp(Level.FINEST, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "begin compile phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                }
                if (translationResult.getTagFileCompileResult() != null && translationResult.getTagFileCompileResult().getCompilerReturnValue() != 0) {
                    compileResult = translationResult.getTagFileCompileResult();
                }
                dependencies = null;
                if (translationResult.getTagFileDependencyList().size() > 0) {
                    dependencies = new JspResources[translationResult.getTagFileDependencyList().size()];
                    dependencies = translationResult.getTagFileDependencyList().toArray(dependencies);
                }
                compiler = context.getJspCompilerFactory().createJspCompiler();
                resourcesToCompile = new JspResources[]{jspResources};
                if (options.isDeleteClassFilesBeforeRecompile()) {
                    JspTranslatorUtil.deleteClassFiles(resourcesToCompile);
                }
                compileResult = compiler.compile(resourcesToCompile, dependencies, translationResult.getJspLineIds(), compilerOptions);
                logOutput = false;
                if (compileResult.getCompilerReturnValue() == 0) {
                    if (options.isVerbose() || options.isDeprecation() || compilerOptions != null && (compilerOptions.contains("-verbose") || compilerOptions.contains("-deprecation"))) {
                        logOutput = true;
                    }
                    if (translationResult.hasSmap()) {
                        smapGenerator = translationResult.getSmapGenerator(JspTranslatorUtil.obtainAbsoluteRelativeURL(context, jspResources.getInputSource()));
                        JspTranslatorUtil.installSmap(jspResources, smapGenerator);
                    }
                    jspResources.sync();
                }
                if (TraceComponent.isAnyTracingEnabled() && JspTranslatorUtil.logger.isLoggable(Level.FINEST)) {
                    JspTranslatorUtil.logger.logp(Level.FINEST, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "complete compile phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
                }
                if (!logOutput || !TraceComponent.isAnyTracingEnabled() || !JspTranslatorUtil.logger.isLoggable(Level.WARNING)) ** GOTO lbl72
                JspTranslatorUtil.logger.logp(Level.WARNING, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "[" + compileResult.getCompilerMessage() + "]");
            }
            finally {
                if (isZOS && zosFileLocker != null) {
                    zosFileLocker.releaseFileLock(jspResources.getInputSource().getRelativeURL());
                    if (JspTranslatorUtil.logger.isLoggable(Level.FINE)) {
                        JspTranslatorUtil.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "releaseFileLock");
                    }
                }
            }
        } else if (JspTranslatorUtil.logger.isLoggable(Level.FINE)) {
            JspTranslatorUtil.logger.logp(Level.FINE, "com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", "Failed translation phase uri =[" + jspResources.getInputSource().getRelativeURL() + "]");
        }
lbl72:
        // 6 sources

        v0 = compileResult;
        if (JspTranslatorUtil.logger != null && JspTranslatorUtil.logger.isLoggable(Level.FINER)) {
            v0 = v0;
            JspTranslatorUtil.logger.exiting("com.ibm.ws.jsp.translator.utils.JspTranslatorUtil", "translateJspAndCompile", v0);
        }
        return v0;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String obtainAbsoluteRelativeURL(JspTranslationContext c, JspInputSource source) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "obtainAbsoluteRelativeURL", new Object[]{c, source});
        }
        String key = "";
        key = c.getServletContext().getModuleContainer() != null ? source.getRelativeURL() : source.getAbsoluteURL().toExternalForm();
        String string = key;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "obtainAbsoluteRelativeURL", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static JspTranslationResult translateJsp(JspResources jspResources, JspTranslationContext context, JspConfiguration config, JspOptions options, TagLibraryCache tlc, boolean forceTagFileTranslation, List compilerOptions) throws JspCoreException {
        JspTranslator jspTranslator;
        HashMap resultMap;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "translateJsp", new Object[]{jspResources, context, config, options, tlc, forceTagFileTranslation, compilerOptions});
        }
        JspTranslationResult translationResult = new JspTranslationResult();
        Integer JspIdConsumerCounter = new Integer(-1);
        Object JspIdConsumerPrefix = null;
        ArrayList tagFileDependencyIdList = new ArrayList();
        JspVisitorInputMap inputMap = new JspVisitorInputMap();
        inputMap.put("TagFileDependencies", tagFileDependencyIdList);
        inputMap.put("TagLibraryCache", tlc);
        inputMap.put("JspFiles", jspResources);
        inputMap.put("JspOptions", options);
        inputMap.put("JspUri", jspResources.getInputSource().getRelativeURL());
        inputMap.put("JspIdConsumerCounter", JspIdConsumerCounter);
        inputMap.put("JspIdConsumerPrefix", JspIdConsumerPrefix);
        String jspVisitorCollectionId = null;
        String tagFileVisitorCollectionId = null;
        if (!options.isUseInMemory()) {
            jspVisitorCollectionId = JSP_TRANSLATION_ID;
            tagFileVisitorCollectionId = TAGFILE_TRANSLATION_ID;
            if (options.isDebugEnabled()) {
                jspVisitorCollectionId = DEBUG_JSP_TRANSLATION_ID;
                tagFileVisitorCollectionId = DEBUG_TAGFILE_TRANSLATION_ID;
            }
        } else {
            jspVisitorCollectionId = IN_MEMORY_JSP_TRANSLATION_ID;
            tagFileVisitorCollectionId = IN_MEMORY_TAGFILE_TRANSLATION_ID;
            if (options.isDebugEnabled()) {
                jspVisitorCollectionId = IN_MEMORY_DEBUG_JSP_TRANSLATION_ID;
                tagFileVisitorCollectionId = IN_MEMORY_DEBUG_TAGFILE_TRANSLATION_ID;
            }
        }
        if ((resultMap = (jspTranslator = JspTranslatorFactory.getFactory().createTranslator(jspVisitorCollectionId, jspResources.getInputSource(), context, config, options, tlc.getImplicitTagLibPrefixMap())).processVisitors(inputMap)).containsKey("Smap")) {
            SmapVisitorResult smapResult = (SmapVisitorResult)resultMap.get("Smap");
            translationResult.addSmapGenerator(JspTranslatorUtil.obtainAbsoluteRelativeURL(context, jspResources.getInputSource()), smapResult.getSmapGenerator());
        }
        translationResult.addJspLineIds(jspResources, jspTranslator.getDocument());
        if (tagFileDependencyIdList.size() > 0) {
            Object lock = tlc.getTagFileLock(tagFileDependencyIdList);
            try {
                Object object = lock;
                synchronized (object) {
                    ArrayList<TagFileResources> tagFilesToCompile = new ArrayList<TagFileResources>();
                    ArrayList<TagFileResources> tagFilesNotToCompile = new ArrayList<TagFileResources>();
                    ArrayList tagFileIds = new ArrayList();
                    for (TagFileId tagFileId : tagFileDependencyIdList) {
                        TagLibraryInfoImpl tli = tlc.getTagLibraryInfo(tagFileId.getUri(), tagFileId.getPrefix(), jspResources.getInputSource().getRelativeURL());
                        TagFileInfo tfi = tli.getTagFile(tagFileId.getTagName());
                        JspInputSource tagFileInputSource = context.getJspInputSourceFactory().copyJspInputSource(tli.getInputSource(), tfi.getPath());
                        TagFileResources tagFileResources = context.getJspResourcesFactory().createTagFileResources(tagFileInputSource, tfi);
                        tagFileResources = tlc.getTagFileResources(tagFileResources);
                        translationResult.getTagFileDependencyList().add(tagFileResources);
                        if (forceTagFileTranslation || !tagFileResources.getGeneratedSourceFile().getParentFile().exists()) {
                            tagFileResources.getGeneratedSourceFile().getParentFile().mkdirs();
                        }
                        if (forceTagFileTranslation || tagFileResources.isOutdated()) {
                            JspConfiguration tagConfiguration = config.createEmptyJspConfiguration();
                            if (tli != null && tli.getRequiredVersion() != null) {
                                tagConfiguration.setJspVersion(tli.getRequiredVersion());
                            }
                            tagConfiguration.setElIgnored(config.elIgnored());
                            JspTranslator tagFileTranslator = JspTranslatorFactory.getFactory().createTranslator(tagFileVisitorCollectionId, tagFileInputSource, context, tagConfiguration, options, tlc.getImplicitTagLibPrefixMap());
                            JspVisitorInputMap tagFileInputMap = new JspVisitorInputMap();
                            tagFileInputMap.put("JspOptions", options);
                            tagFileInputMap.put("TagLibraryCache", tlc);
                            tagFileInputMap.put("TagFileFiles", tagFileResources);
                            tagFileInputMap.put("TagFileInfo", tfi);
                            tagFileInputMap.put("isTagFile", new Boolean(true));
                            tagFileInputMap.put("JspUri", jspResources.getInputSource().getRelativeURL());
                            HashMap results = tagFileTranslator.processVisitors(tagFileInputMap);
                            if (results.containsKey("Smap")) {
                                SmapVisitorResult smapResult = (SmapVisitorResult)results.get("Smap");
                                translationResult.addSmapGenerator(JspTranslatorUtil.obtainAbsoluteRelativeURL(context, tagFileResources.getInputSource()), smapResult.getSmapGenerator());
                            }
                            JspTranslationResult.loadJspIdList(tagFileResources, tagFileTranslator.getDocument().getDocumentElement(), tagFileIds);
                            tagFileResources.syncGeneratedSource();
                            tagFilesToCompile.add(tagFileResources);
                            continue;
                        }
                        tagFilesNotToCompile.add(tagFileResources);
                    }
                    if (tagFilesToCompile.size() > 0) {
                        JspResources[] resourcesToCompile = new JspResources[tagFilesToCompile.size()];
                        resourcesToCompile = tagFilesToCompile.toArray(resourcesToCompile);
                        JspCompiler compiler = context.getJspCompilerFactory().createJspCompiler();
                        JspResources[] dependencies = null;
                        if (tagFilesNotToCompile.size() > 0) {
                            dependencies = new JspResources[tagFilesNotToCompile.size()];
                            dependencies = tagFilesNotToCompile.toArray(dependencies);
                        }
                        JspCompilerResult compileResult = compiler.compile(resourcesToCompile, dependencies, tagFileIds, compilerOptions);
                        translationResult.setTagFileCompileResult(compileResult);
                        JspTranslatorUtil.syncTagFileFiles(options, tagFilesToCompile, translationResult, context);
                    }
                }
            }
            finally {
                tlc.releaseTagFileLock(tagFileDependencyIdList);
            }
        }
        JspTranslationResult jspTranslationResult = translationResult;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspTranslationResult = jspTranslationResult;
            logger.exiting(CLASS_NAME, "translateJsp", jspTranslationResult);
        }
        return jspTranslationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void syncTagFileFiles(JspOptions options, List translatedTagFiles, JspTranslationResult translationResult, JspTranslationContext context) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "syncTagFileFiles", new Object[]{options, translatedTagFiles, translationResult, context});
        }
        Iterator itr = translatedTagFiles.iterator();
        while (itr.hasNext()) {
            TagFileResources tagFileResources;
            TagFileResources tagFileResources2 = tagFileResources = (TagFileResources)itr.next();
            synchronized (tagFileResources2) {
                tagFileResources.sync();
                if (translationResult.hasSmap()) {
                    SmapGenerator smapGenerator = translationResult.getSmapGenerator(JspTranslatorUtil.obtainAbsoluteRelativeURL(context, tagFileResources.getInputSource()));
                    JspTranslatorUtil.installSmap(tagFileResources, smapGenerator);
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "syncTagFileFiles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void installSmap(JspResources jspResources, SmapGenerator smapGenerator) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "installSmap", new Object[]{jspResources, smapGenerator});
        }
        int inx = jspResources.getGeneratedSourceFile().getPath().lastIndexOf(".java");
        String classFilePath = jspResources.getGeneratedSourceFile().getPath().substring(0, inx) + ".class";
        File classFile = new File(classFilePath);
        if (smapGenerator != null) {
            try {
                SDEInstaller.install(classFile, smapGenerator);
            }
            catch (IOException e) {
                throw new JspCoreException(e);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "installSmap");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void printTagFileFiles(List translatedTagFileFiles) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "printTagFileFiles", new Object[]{translatedTagFileFiles});
        }
        for (TagFileResources tagFileResources : translatedTagFileFiles) {
            System.out.println("JspTranslatorUtil printTagFileFiles() " + tagFileResources.toString());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "printTagFileFiles");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isExpression(String token) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isExpression", new Object[]{token});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token)", "isExpression(String token)  token = [" + token + "]");
        }
        boolean bool = JspTranslatorUtil.isExpression(token, true);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token)", "isExpression(String token)  returning = [" + bool + "]");
        }
        boolean bl = bool;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isExpression", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isExpression(String token, boolean isXml) {
        String closeExpr;
        String openExpr;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isExpression", new Object[]{token, isXml});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) value= [" + token + "] isXml= [" + isXml + "]");
        }
        if (isXml) {
            openExpr = "%=";
            closeExpr = "%";
        } else {
            openExpr = "<%=";
            closeExpr = "%>";
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) openExpr= [" + openExpr + "] closeExpr= [" + closeExpr + "]");
        }
        if (token.startsWith(openExpr) && token.endsWith(closeExpr)) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) returning true");
            }
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isExpression", bl);
            }
            return bl;
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isExpression(String token, boolean isXml)", "isExpression(String token, boolean isXml) returning false");
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isExpression", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isELInterpreterInput(String token, JspConfiguration jspConfig) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isELInterpreterInput", new Object[]{token, jspConfig});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration)", "isELInterpreterInput(String, JspConfiguration) value= [" + token + "]");
        }
        boolean bl = JspTranslatorUtil.isELInterpreterInput(token, jspConfig, !jspConfig.isDeferredSyntaxAllowedAsLiteral());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isELInterpreterInput", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isELInterpreterInput(String token, JspConfiguration jspConfig, boolean checkDeferred) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isELInterpreterInput", new Object[]{token, jspConfig, checkDeferred});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) value= [" + token + "]");
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) jspConfiguration.elIgnored() =[" + jspConfig.elIgnored() + "]");
            logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) checkDeferred =[" + checkDeferred + "]");
        }
        boolean isELValue = false;
        if (!jspConfig.elIgnored()) {
            int immediateIndex = token.indexOf("${");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) index of ${= [" + immediateIndex + "]");
            }
            int deferredIndex = token.indexOf("#{");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) index of #{= [" + deferredIndex + "]");
            }
            int index = -1;
            if (immediateIndex != -1) {
                index = immediateIndex;
            } else if (deferredIndex != -1 && checkDeferred) {
                index = deferredIndex;
            }
            if (index != -1) {
                char prevChar = ' ';
                if (index > 0) {
                    prevChar = token.charAt(index - 1);
                }
                boolean evalExpressionFollowingTwoBackslashes = WCCustomProperties.EVAL_EXPRESSION_FOLLOWING_TWO_BACKSLASHES;
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) prevChar= [" + prevChar + "]");
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) evalExpressionFollowingTwoBackslashes= [" + evalExpressionFollowingTwoBackslashes + "]");
                }
                if (prevChar != '\\') {
                    isELValue = true;
                } else if (evalExpressionFollowingTwoBackslashes && index > 1 && token.charAt(index - 2) == '\\') {
                    isELValue = true;
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "isELInterpreterInput(String, JspConfiguration, boolean)", "isELInterpreterInput(String, JspConfiguration, boolean) isELValue= [" + isELValue + "]");
                }
            }
        }
        boolean bl = isELValue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isELInterpreterInput", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isExpression(String token, boolean isXml, JspConfiguration jspConfig, boolean checkDeferred) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "isExpression", new Object[]{token, isXml, jspConfig, checkDeferred});
        }
        boolean isExpression = JspTranslatorUtil.isExpression(token, isXml);
        boolean isELInput = JspTranslatorUtil.isELInterpreterInput(token, jspConfig, checkDeferred);
        if (isExpression || isELInput) {
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting(CLASS_NAME, "isExpression", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "isExpression", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void printAllElements(HashMap processedDocuments) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "printAllElements", new Object[]{processedDocuments});
        }
        for (String key : processedDocuments.keySet()) {
            Document document = (Document)processedDocuments.get(key);
            JspTranslatorUtil.printElements(document.getDocumentElement(), 0);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "printAllElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void printElements(Element element, int level) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "printElements", new Object[]{element, level});
        }
        for (int i = 0; i < level; ++i) {
            System.out.print("\t");
        }
        System.out.println("Element - " + element.getNodeName());
        NamedNodeMap attrs = element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            for (int j = 0; j < level; ++j) {
                System.out.print("\t");
            }
            System.out.println("Attr - " + attr.getName() + " : " + attr.getValue() + " : " + attr.getNamespaceURI());
        }
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n instanceof Element) {
                Element childElement = (Element)n;
                System.out.println();
                JspTranslatorUtil.printElements(childElement, level + 1);
                continue;
            }
            if (!(n instanceof CDATASection)) continue;
            System.out.println();
            CDATASection cdata = (CDATASection)n;
            for (int j = 0; j < level + 1; ++j) {
                System.out.print("\t");
            }
            String s = cdata.getData();
            s = s.replaceAll("\r", "");
            s = s.replaceAll("\n", "{cr}");
            System.out.println("CDATA - [" + s + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "printElements");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class toClass(String type, ClassLoader loader) throws ClassNotFoundException {
        int bracketL;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "toClass", new Object[]{type, loader});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "toClass(String, ClassLoader)", " type= [" + type + "] loader= [" + loader + "]");
        }
        Class<Comparable<Boolean>> c = null;
        int i0 = type.indexOf(91);
        int dims = 0;
        if (i0 > 0) {
            for (int i = 0; i < type.length(); ++i) {
                if (type.charAt(i) != '[') continue;
                ++dims;
            }
            type = type.substring(0, i0);
        } else if (i0 == 0 && (bracketL = type.indexOf("[L")) > -1 && type.endsWith(";")) {
            type = type.substring(bracketL + 2, type.length() - 1);
            dims += bracketL + 1;
        }
        if ("boolean".equals(type)) {
            c = Boolean.TYPE;
        } else if ("char".equals(type)) {
            c = Character.TYPE;
        } else if ("byte".equals(type)) {
            c = Byte.TYPE;
        } else if ("short".equals(type)) {
            c = Short.TYPE;
        } else if ("int".equals(type)) {
            c = Integer.TYPE;
        } else if ("long".equals(type)) {
            c = Long.TYPE;
        } else if ("float".equals(type)) {
            c = Float.TYPE;
        } else if ("double".equals(type)) {
            c = Double.TYPE;
        } else {
            if ("void".equals(type)) {
                Class<Void> clazz = Void.class;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    clazz = clazz;
                    logger.exiting(CLASS_NAME, "toClass", clazz);
                }
                return clazz;
            }
            if (type.indexOf(91) < 0) {
                c = loader.loadClass(type);
            }
        }
        if (dims == 0) {
            Class<Boolean> clazz = c;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                clazz = clazz;
                logger.exiting(CLASS_NAME, "toClass", clazz);
            }
            return clazz;
        }
        if (dims == 1) {
            Class<?> clazz = Array.newInstance(c, 1).getClass();
            if (logger != null && logger.isLoggable(Level.FINER)) {
                clazz = clazz;
                logger.exiting(CLASS_NAME, "toClass", clazz);
            }
            return clazz;
        }
        Class<?> clazz = Array.newInstance(c, new int[dims]).getClass();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            clazz = clazz;
            logger.exiting(CLASS_NAME, "toClass", clazz);
        }
        return clazz;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean hasJspBody(Element element) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasJspBody", new Object[]{element});
        }
        boolean hasJspBody = false;
        boolean jspBodyFound = false;
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element childElement;
            Node child = children.item(i);
            if (!(child instanceof Element) || (childElement = (Element)child).getNamespaceURI() == null || !childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page") || !childElement.getLocalName().equals("body") || !childElement.hasChildNodes()) continue;
            hasJspBody = true;
            break;
        }
        boolean bl = hasJspBody;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasJspBody", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean hasBody(Element element) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "hasBody", new Object[]{element});
        }
        boolean hasBody = false;
        NodeList children = element.getChildNodes();
        boolean attrOrBodyTagFound = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                Element childElement = (Element)child;
                if (childElement.getNamespaceURI() != null && childElement.getNamespaceURI().equals("http://java.sun.com/JSP/Page")) {
                    if (childElement.getLocalName().equals("attribute") || childElement.getLocalName().equals("body")) {
                        attrOrBodyTagFound = true;
                        continue;
                    }
                    hasBody = true;
                    break;
                }
                hasBody = true;
                break;
            }
            if (child.getNodeType() != 4) continue;
            hasBody = true;
        }
        if (attrOrBodyTagFound && hasBody) {
            hasBody = false;
        }
        boolean bl = hasBody;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "hasBody", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean booleanValue(String s) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "booleanValue", new Object[]{s});
        }
        boolean allowYesToMeanTrue = true;
        boolean bl = JspTranslatorUtil.booleanValue(s, allowYesToMeanTrue);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "booleanValue", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean booleanValue(String s, boolean allowYesToMeanTrue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "booleanValue", new Object[]{s, allowYesToMeanTrue});
        }
        boolean b = false;
        if (s != null) {
            b = s.equalsIgnoreCase("yes") && allowYesToMeanTrue ? true : Boolean.valueOf(s);
        }
        boolean bl = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "booleanValue", bl);
        }
        return bl;
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void deleteClassFiles(JspResources[] compileFiles) {
        boolean isAnyTraceEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "deleteClassFiles", "deleteClassFilesBeforeRecompile is set to true");
        }
        String classfileName = null;
        if (compileFiles != null && compileFiles.length > 0) {
            for (int i = 0; i < compileFiles.length; ++i) {
                File clFile;
                classfileName = compileFiles[i].getGeneratedSourceFile().toString();
                int end = classfileName.lastIndexOf(".");
                classfileName = classfileName.substring(0, end);
                classfileName = classfileName + ".class";
                if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINE, CLASS_NAME, "deleteClassFiles", "removing classfile " + (i + 1) + " [" + classfileName + "]");
                }
                if ((clFile = new File(classfileName)).exists() && clFile.isFile()) {
                    boolean retval = clFile.delete();
                    if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINE, CLASS_NAME, "deleteClassFiles", "Removed file " + compileFiles[i].getClassName() + "? : [" + retval + "]");
                    }
                } else if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINE, CLASS_NAME, "deleteClassFiles", "File [" + clFile.toString() + "] does not exist.");
                }
                end = classfileName.lastIndexOf(File.separatorChar);
                String directoryName = classfileName.substring(0, end);
                File directory = new File(directoryName);
                File[] icList = directory.listFiles(new JspFileUtils.InnerclassFilenameFilter(compileFiles[i].getClassName()));
                for (int j = 0; j < icList.length; ++j) {
                    if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINE, CLASS_NAME, "deleteClassFiles", "removing innerclassfile " + (j + 1) + " [" + icList[j] + "]");
                    }
                    if (icList[j].exists() && icList[j].isFile()) {
                        boolean retval = icList[j].delete();
                        end = icList[j].toString().lastIndexOf(File.separatorChar);
                        String innerClassName = icList[j].toString().substring(end + 1);
                        if (!isAnyTraceEnabled || !logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINE, CLASS_NAME, "deleteClassFiles", "Removed innerclassfile " + innerClassName + "? : [" + retval + "]");
                        continue;
                    }
                    if (!isAnyTraceEnabled || !logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "deleteClassFiles", "Innerclassfile [" + icList[j].toString() + "] does not exist.");
                }
            }
        }
        if (isAnyTraceEnabled && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "deleteClassFiles", "Exiting");
        }
    }
}

