/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.validator;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.PagesVersionHandler;
import com.ibm.ws.jsp.configuration.JspConfiguration;
import com.ibm.ws.jsp.translator.JspTranslationException;
import com.ibm.ws.jsp.translator.utils.JspId;
import com.ibm.ws.jsp.translator.visitor.JspVisitorInputMap;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateJspResult;
import com.ibm.ws.jsp.translator.visitor.validator.ValidateVisitor;
import com.ibm.wsspi.jsp.context.JspCoreContext;
import com.ibm.wsspi.webcontainer.util.EncodingUtils;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class ValidateJspVisitor
extends ValidateVisitor {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.visitor.validator.ValidateJspVisitor";
    private HashMap userDefinedDirectives;
    private Boolean autoFlushValue;
    private String bufferValue;
    static final long serialVersionUID = 4682548770731741900L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ValidateJspVisitor(JspVisitorUsage visitorUsage, JspConfiguration jspConfiguration, JspCoreContext context, HashMap resultMap, JspVisitorInputMap inputMap) throws JspCoreException {
        super(visitorUsage, jspConfiguration, context, resultMap, inputMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{visitorUsage, jspConfiguration, context, resultMap, inputMap});
        }
        this.userDefinedDirectives = new HashMap();
        this.autoFlushValue = null;
        this.bufferValue = null;
        this.result = new ValidateJspResult(visitorUsage.getJspVisitorDefinition().getId());
        if (jspConfiguration.getBuffer() != null) {
            this.setBufferValue((ValidateJspResult)this.result, null, jspConfiguration.getBuffer());
        }
        if (jspConfiguration.getDefaultContentType() != null) {
            ((ValidateJspResult)this.result).setContentType(jspConfiguration.getDefaultContentType());
        }
        if (jspConfiguration.isErrorOnUndeclaredNamespace()) {
            // empty if block
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspUseBeanStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspUseBeanStart", new Object[]{jspElement});
        }
        super.visitJspUseBeanStart(jspElement);
        ValidateJspResult jspResult = (ValidateJspResult)this.result;
        NamedNodeMap attributes = jspElement.getAttributes();
        if (attributes != null) {
            Attr scopeAttr = jspElement.getAttributeNode("scope");
            if (scopeAttr != null && scopeAttr.getValue().equalsIgnoreCase("session") && !jspResult.isGenSessionVariable()) {
                throw new JspTranslationException(jspElement, "jsp.error.usebean.prohibited.as.session");
            }
        } else {
            throw new JspTranslationException(jspElement, "jsp.error.usebean.contains.no.attributes");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "visitJspUseBeanStart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setBufferValue(ValidateJspResult jspResult, Element jspElement, String bufferValue) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setBufferValue", new Object[]{jspResult, jspElement, bufferValue});
        }
        if (bufferValue.equalsIgnoreCase("none")) {
            jspResult.setBufferSize(0);
        } else {
            String servletVersion = this.jspConfiguration.getServletVersion();
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINEST)) {
                logger.logp(Level.FINEST, CLASS_NAME, "visitPageDirectiveStart", "ServletVersion=" + servletVersion);
            }
            Integer integer = null;
            try {
                String num;
                if (servletVersion.equals("2.3") || servletVersion.equals("2.4")) {
                    int ind = bufferValue.indexOf("k");
                    num = ind == -1 ? bufferValue : bufferValue.substring(0, ind);
                } else {
                    int ind = bufferValue.indexOf("kb");
                    if (ind == -1) {
                        if (jspElement == null) {
                            throw new JspTranslationException("jsp.error.invalid.value.for.buffer");
                        }
                        throw new JspTranslationException(jspElement, "jsp.error.invalid.value.for.buffer");
                    }
                    num = bufferValue.substring(0, ind);
                }
                integer = new Integer(num);
                if (integer < 0) {
                    if (jspElement == null) {
                        throw new JspTranslationException("jsp.error.page.invalid.buffer");
                    }
                    throw new JspTranslationException(jspElement, "jsp.error.page.invalid.buffer");
                }
            }
            catch (NumberFormatException n) {
                if (jspElement == null) {
                    throw new JspTranslationException("jsp.error.page.invalid.buffer");
                }
                throw new JspTranslationException(jspElement, "jsp.error.page.invalid.buffer");
            }
            jspResult.setBufferSize(integer * 1024);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setBufferValue");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitPageDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitPageDirectiveStart", new Object[]{jspElement});
        }
        ValidateJspResult jspResult = (ValidateJspResult)this.result;
        NamedNodeMap attributes = jspElement.getAttributes();
        if (attributes == null) throw new JspTranslationException(jspElement, "jsp.error.page.directive.contains.no.attributes");
        for (int i = 0; i < attributes.getLength(); ++i) {
            String directiveValue;
            Node attribute = attributes.item(i);
            String directiveName = attribute.getNodeName();
            Object oldDirectiveValue = this.addUserPageDirective(directiveName, directiveValue = attribute.getNodeValue());
            if (!(oldDirectiveValue == null || directiveName.equals("import") || directiveName.equals("pageEncoding") || directiveName.equals("jsp:id") || oldDirectiveValue.equals(directiveValue))) {
                throw new JspTranslationException(jspElement, "jsp.error.multiple.occurrences.directive", new Object[]{directiveName, oldDirectiveValue, directiveValue});
            }
            boolean valid = false;
            if (directiveName.equals("language")) {
                if (directiveValue != null && !directiveValue.equals("java")) {
                    throw new JspTranslationException(jspElement, "jsp.error.invalid.value.for.language", new Object[]{directiveValue});
                }
                valid = true;
                jspResult.setLanguage(directiveValue);
            } else if (directiveName.equals("extends")) {
                valid = true;
                jspResult.setExtendsClass(directiveValue);
            } else if (directiveName.equals("import")) {
                valid = true;
            } else if (directiveName.equals("session")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    jspResult.setGenSessionVariable(true);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.invalid.value.for.session");
                    jspResult.setGenSessionVariable(false);
                }
            } else if (directiveName.equals("buffer")) {
                valid = true;
                this.setBufferValue(jspResult, jspElement, directiveValue);
                this.bufferValue = directiveValue;
                if (this.autoFlushValue != null && this.bufferValue.equalsIgnoreCase("none") && !this.autoFlushValue.booleanValue()) {
                    throw new JspTranslationException(jspElement, "jsp.error.page.invalid.autoflush.buffer");
                }
            } else if (directiveName.equals("autoFlush")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    jspResult.setAutoFlush(true);
                    this.autoFlushValue = new Boolean(true);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.autoflush");
                    jspResult.setAutoFlush(false);
                    this.autoFlushValue = new Boolean(false);
                }
                if (this.bufferValue != null && this.bufferValue.equalsIgnoreCase("none") && !this.autoFlushValue.booleanValue()) {
                    throw new JspTranslationException(jspElement, "jsp.error.page.invalid.autoflush.buffer");
                }
            } else if (directiveName.equals("isThreadSafe")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    jspResult.setSingleThreaded(false);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.threadsafe");
                    jspResult.setSingleThreaded(true);
                }
            } else if (directiveName.equals("info")) {
                valid = true;
                jspResult.setInfo(directiveValue);
            } else if (directiveName.equals("errorPage")) {
                valid = true;
                jspResult.setError(directiveValue);
            } else if (directiveName.equals("isErrorPage")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    jspResult.setIsErrorPage(true);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.iserrorpage");
                    jspResult.setIsErrorPage(false);
                }
            } else if (directiveName.equals("contentType")) {
                valid = true;
                jspResult.setContentType(directiveValue);
            } else if (directiveName.equals("pageEncoding")) {
                valid = true;
                JspId jspId = new JspId(jspElement.getAttribute("jsp:id"));
                String configPageEncoding = this.jspConfiguration.getResponseEncoding();
                if (configPageEncoding == null) {
                    configPageEncoding = this.jspConfiguration.getPageEncoding();
                }
                String convertedPageEncoding = EncodingUtils.getJvmConverter((String)directiveValue);
                if (configPageEncoding != null) {
                    if (convertedPageEncoding.toUpperCase().startsWith("UTF-16")) {
                        if (!configPageEncoding.toUpperCase().startsWith("UTF-16")) {
                            throw new JspTranslationException(jspElement, "jsp.error.page.pageencoding.mismatch", new Object[]{convertedPageEncoding, configPageEncoding});
                        }
                        if (configPageEncoding.equalsIgnoreCase("UTF-16LE") || configPageEncoding.equalsIgnoreCase("UTF-16BE")) {
                            convertedPageEncoding = configPageEncoding;
                        }
                    } else if (!convertedPageEncoding.equalsIgnoreCase(configPageEncoding)) {
                        throw new JspTranslationException(jspElement, "jsp.error.page.pageencoding.mismatch", new Object[]{convertedPageEncoding, configPageEncoding});
                    }
                }
                jspResult.setPageEncoding(convertedPageEncoding);
            } else if (directiveName.equals("isELIgnored")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    jspResult.setIsELIgnored(true);
                    this.jspConfiguration.setElIgnored(true);
                    this.jspConfiguration.setElIgnoredSetTrueInPage(true);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.iselignored");
                    jspResult.setIsELIgnored(false);
                    this.jspConfiguration.setElIgnored(false);
                }
            } else if (directiveName.equals("jsp:id")) {
                valid = true;
            } else if (directiveName.startsWith("xmlns")) {
                valid = true;
            } else if (directiveName.equals("trimDirectiveWhitespaces")) {
                valid = true;
                if (this.jspConfiguration.getTrimDirectiveWhitespaces() == null) {
                    if (directiveValue.equalsIgnoreCase("true")) {
                        jspResult.setTrimDirectiveWhitespaces(true);
                        this.jspConfiguration.setTrimDirectiveWhitespaces(true);
                    } else {
                        if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.trimdirectivewhitespaces");
                        jspResult.setTrimDirectiveWhitespaces(false);
                        this.jspConfiguration.setTrimDirectiveWhitespaces(false);
                    }
                } else if (!this.jspConfiguration.getTrimDirectiveWhitespaces().equals(directiveValue)) {
                    throw new JspTranslationException(jspElement, "jsp.error.page.conflict.trimdirectivewhitespaces", new Object[]{this.jspConfiguration.getTrimDirectiveWhitespaces(), directiveName});
                }
            } else if (directiveName.equals("deferredSyntaxAllowedAsLiteral")) {
                valid = true;
                if (this.jspConfiguration.getDeferredSyntaxAllowedAsLiteral() == null) {
                    if (directiveValue.equalsIgnoreCase("true")) {
                        jspResult.setDeferredSyntaxAllowedAsLiteral(true);
                        this.jspConfiguration.setDeferredSyntaxAllowedAsLiteral(true);
                    } else {
                        if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.deferredsyntaxallowedasliteral", new Object[]{this.jspConfiguration.getDeferredSyntaxAllowedAsLiteral(), directiveName});
                        jspResult.setDeferredSyntaxAllowedAsLiteral(false);
                        this.jspConfiguration.setDeferredSyntaxAllowedAsLiteral(false);
                    }
                } else if (!this.jspConfiguration.getDeferredSyntaxAllowedAsLiteral().equals(directiveValue)) {
                    throw new JspTranslationException(jspElement, "jsp.error.page.conflict.deferredsyntaxallowedasliteral");
                }
            }
            if (PagesVersionHandler.isPages31OrHigherLoaded() && directiveName.equals("errorOnELNotFound")) {
                valid = true;
                if (directiveValue.equalsIgnoreCase("true")) {
                    jspResult.setErrorOnELNotFound(true);
                    this.jspConfiguration.setErrorOnELNotFound(true);
                    this.jspConfiguration.setErrorOnELNotFoundSetTrueInPage(true);
                } else {
                    if (!directiveValue.equalsIgnoreCase("false")) throw new JspTranslationException(jspElement, "jsp.error.page.invalid.erroronelnotfound");
                    jspResult.setErrorOnELNotFound(false);
                    this.jspConfiguration.setErrorOnELNotFound(false);
                }
            }
            if (valid) continue;
            throw new JspTranslationException(jspElement, "jsp.error.page.directive.unknown", new Object[]{directiveName});
        }
        if (logger == null || !logger.isLoggable(Level.FINER)) return;
        logger.exiting(CLASS_NAME, "visitPageDirectiveStart");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspInvokeStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspInvokeStart", new Object[]{jspElement});
        }
        throw new JspTranslationException(jspElement, "jsp.error.invoke.only.in.tagfiles");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitJspDoBodyStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitJspDoBodyStart", new Object[]{jspElement});
        }
        throw new JspTranslationException(jspElement, "jsp.error.dobody.only.in.tagfiles");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitTagDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitTagDirectiveStart", new Object[]{jspElement});
        }
        throw new JspTranslationException(jspElement, "jsp.error.tag.directive.only.in.tagfiles");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitAttributeDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitAttributeDirectiveStart", new Object[]{jspElement});
        }
        throw new JspTranslationException(jspElement, "jsp.error.attribute.directive.only.in.tagfiles");
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void visitVariableDirectiveStart(Element jspElement) throws JspCoreException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "visitVariableDirectiveStart", new Object[]{jspElement});
        }
        throw new JspTranslationException(jspElement, "jsp.error.variable.directive.only.in.tagfiles");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object addUserPageDirective(String directiveName, String directiveValue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "addUserPageDirective", new Object[]{directiveName, directiveValue});
        }
        String string = this.userDefinedDirectives.put(directiveName, directiveValue);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "addUserPageDirective", string);
        }
        return string;
    }
}

