/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.servlet.Servlet;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.jasper.runtime.TagHandlerPool;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class PerThreadTagHandlerPool
extends TagHandlerPool {
    public static int MAX_SIZE;
    private int maxSize = MAX_SIZE;
    private int initialSize = 5;
    private ThreadLocal perThread = new ThreadLocal();
    private Hashtable threadData = new Hashtable();
    static final long serialVersionUID = 344683217906484993L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public PerThreadTagHandlerPool() {
    }

    protected void init(Servlet servlet) {
        String maxSizeS = TagHandlerPool.getOption(servlet.getServletConfig(), OPTION_MAXSIZE, null);
        this.maxSize = Integer.parseInt(maxSizeS);
        if (this.maxSize < 0) {
            this.maxSize = MAX_SIZE;
        }
    }

    public PerThreadTagHandlerPool(int capacity) {
        this.maxSize = capacity;
    }

    @Override
    public Tag get(Class handlerClass) throws JspException {
        PerThreadData ptd = (PerThreadData)this.perThread.get();
        if (ptd != null && ptd.current >= 0) {
            return ptd.handlers[ptd.current--];
        }
        try {
            return (Tag)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void reuse(Tag handler) {
        PerThreadData ptd = (PerThreadData)this.perThread.get();
        if (ptd == null) {
            ptd = new PerThreadData();
            ptd.handlers = new Tag[this.initialSize];
            ptd.current = 0;
            this.threadData.put(ptd, ptd);
        }
        if (ptd.current < ptd.handlers.length - 1) {
            ptd.handlers[++ptd.current] = handler;
            return;
        }
        if (ptd.handlers.length < this.maxSize) {
            Tag[] newH = new Tag[ptd.handlers.length + this.initialSize];
            System.arraycopy(ptd.handlers, 0, newH, 0, ptd.handlers.length);
            ptd.handlers = newH;
            ptd.handlers[++ptd.current] = handler;
            return;
        }
        handler.release();
    }

    @Override
    public synchronized void release() {
        Enumeration ptdE = this.threadData.keys();
        while (ptdE.hasMoreElements()) {
            PerThreadData ptd = (PerThreadData)ptdE.nextElement();
            for (int i = ptd.current; i >= 0; --i) {
                if (ptd.handlers == null || ptd.handlers[i] == null) continue;
                ptd.handlers[i].release();
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.jasper.runtime.PerThreadTagHandlerPool", PerThreadTagHandlerPool.class, null, null);
        MAX_SIZE = 100;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static class PerThreadData {
        Tag[] handlers;
        int current;
        static final long serialVersionUID = 3208790239751198020L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PerThreadData() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.jasper.runtime.PerThreadTagHandlerPool$PerThreadData", PerThreadData.class, null, null);
        }
    }
}

